---
search:
  exclude: true
---

### December 2015

#### Bug fixes
  - WebUI:
    - Fixed regex for negative lat/lng coords ([PR2524](https://github.com/librenms/librenms/pull/2524))
    - Fixed map page looping due to device connected to itself ([PR2545](https://github.com/librenms/librenms/pull/2545))
    - Fixed PATH_INFO for nginx ([PR2551](https://github.com/librenms/librenms/pull/2551))
    - urlencode the custom port types ([PR2597](https://github.com/librenms/librenms/pull/2597))
    - Stop non-admin users from being able to get to settings pages ([PR2627](https://github.com/librenms/librenms/pull/2627))
    - Fix JpGraph php version compare ([PR2631](https://github.com/librenms/librenms/pull/2631))
  - Discovery / Polling:
    - Pointed snmp calls for Huawei to correct MIB folder ([PR2541](https://github.com/librenms/librenms/pull/2541))
    - Fixed Ceph unix-agent support. ([PR2588](https://github.com/librenms/librenms/pull/2588))
    - Moved memory graphs from storage to memory polling ([PR2616](https://github.com/librenms/librenms/pull/2616))
    - Mask alert_log mysql output when debug is enabled to stop console crashes ([PR2618](https://github.com/librenms/librenms/pull/2618))
    - Stop Quanta devices being detected as Ubiquiti ([PR2632](https://github.com/librenms/librenms/pull/2632))
    - Fix MySQL unix-agent graphs ([PR2645](https://github.com/librenms/librenms/pull/2645))
    - Added MTA-MIB and NETWORK-SERVICES-MIB to stop warnings printed in poller debug ([PR2653](https://github.com/librenms/librenms/pull/2653))
  - Services:
    - Fix SSL check for PHP 7 ([PR2647](https://github.com/librenms/librenms/pull/2647))
  - Alerting:
    - Fix glue-expansion for alerts ([PR2522](https://github.com/librenms/librenms/pull/2522))
    - Fix HipChat transport ([PR2586](https://github.com/librenms/librenms/pull/2586))
  - Documentation:
    - Removed duplicate mysql-client install from Debian/Ubuntu install docs ([PR2543](https://github.com/librenms/librenms/pull/2543))
  - Misc:
    - Update daily.sh to ignore issues writing to log file ([PR2595](https://github.com/librenms/librenms/pull/2595))

#### Improvements
  - WebUI:
    - Converted sensors page to use bootgrid ([PR2531](https://github.com/librenms/librenms/pull/2531))
    - Added new widgets for dashboard. Notes ([PR2582](https://github.com/librenms/librenms/pull/2582)), Generic image ([PR2617](https://github.com/librenms/librenms/pull/2617))
    - Added config option to disable lazy loading of images ([PR2589](https://github.com/librenms/librenms/pull/2589))
    - Visual update to Navbar. ([PR2593](https://github.com/librenms/librenms/pull/2593))
    - Update alert rules to show actual alert rule ID ([PR2603](https://github.com/librenms/librenms/pull/2603))
    - Initial support added for per user default dashboard ([PR2620](https://github.com/librenms/librenms/pull/2620))
    - Updated Worldmap to show clusters in red if one device is down ([PR2621](https://github.com/librenms/librenms/pull/2621))
    - Cleaned up Billing pages ([PR2671](https://github.com/librenms/librenms/pull/2671))
  - Discovery / Polling
    - Added traffic bits as default for Cambium devices ([PR2525](https://github.com/librenms/librenms/pull/2525))
    - Overwrite eth0 port data from UniFi MIBs for AirFibre devices ([PR2544](https://github.com/librenms/librenms/pull/2544))
    - Added lastupdate column to sensors table for use with alerts ([PR2590](https://github.com/librenms/librenms/pull/2590),[PR2592](https://github.com/librenms/librenms/pull/2592))
    - Updated auto discovery via lldp to check for devices that use mac address in lldpRemPortId ([PR2591](https://github.com/librenms/librenms/pull/2591))
    - Updated auto discovery via lldp with absent lldpRemSysName ([PR2619](https://github.com/librenms/librenms/pull/2619))
  - API:
    - Added ability to filter devices by type and os for Oxidized API call ([PR2539](https://github.com/librenms/librenms/pull/2539))
    - Added ability to update device information ([PR2585](https://github.com/librenms/librenms/pull/2585))
    - Added support for returning device groups ([PR2611](https://github.com/librenms/librenms/pull/2611))
    - Added ability to select port graphs based on ifDescr ([PR2648](https://github.com/librenms/librenms/pull/2648))
  - Documentation:
    - Improved alerting docs explaining more options ([PR2560](https://github.com/librenms/librenms/pull/2560))
    - Added Docs for Ubuntu/Debian Smokeping integration ([PR2610](https://github.com/librenms/librenms/pull/2610))
  - Added detection for:
    - Updated Netonix switch MIBs ([PR2523](https://github.com/librenms/librenms/pull/2523))
    - Updated Fotinet MIBs ([PR2529](https://github.com/librenms/librenms/pull/2529), [PR2534](https://github.com/librenms/librenms/pull/2534))
    - Cisco SG500 ([PR2609](https://github.com/librenms/librenms/pull/2609))
    - Updated processor support for Fortigate ([PR2613](https://github.com/librenms/librenms/pull/2613))
    - Added CPU / Memory support for PBN ([PR2672](https://github.com/librenms/librenms/pull/2672))
  - Misc:
    - Updated validation to check for php extension and classes required ([PR2602](https://github.com/librenms/librenms/pull/2602))
    - Added Radius Authentication support ([PR2615](https://github.com/librenms/librenms/pull/2615))
    - Removed distinct() from alerts query to use indexes ([PR2649](https://github.com/librenms/librenms/pull/2649))

### November 2015

#### Bug fixes
  - WebUI:
    - getRates should return in and out average rates ([PR2375](https://github.com/librenms/librenms/pull/2375))
    - Fix 95th percent lines in negative range ([PR2405](https://github.com/librenms/librenms/pull/2405))
    - Fix percentage bar for billing pages ([PR2419](https://github.com/librenms/librenms/pull/2419))
    - Use HC counters first in realtime graphs ([PR2420](https://github.com/librenms/librenms/pull/2420))
    - Fix netcmd.php URI for sub dir installations ([PR2428](https://github.com/librenms/librenms/pull/2428))
    - Fixed Oxidized fetch config with groups ([PR2501](https://github.com/librenms/librenms/pull/2501))
    - Fixed background colour to white for some graphs ([PR2516](https://github.com/librenms/librenms/pull/2516))
    - Added missing Service description on services page ([PR2679](https://github.com/librenms/librenms/pull/2679))
  - API:
    - Added missing quotes for MySQL queries ([PR2382](https://github.com/librenms/librenms/pull/2382))
  - Discovery / Polling:
    - Specified MIB used when polling ntpd-server ([PR2418](https://github.com/librenms/librenms/pull/2418))
    - Added missing fields when inserting data into applications table ([PR2445](https://github.com/librenms/librenms/pull/2445))
    - Fix auto-discovery failing ([PR2457](https://github.com/librenms/librenms/pull/2457))
    - Juniper hardware inventory fix ([PR2466](https://github.com/librenms/librenms/pull/2466))
    - Fix discovery of Cisco PIX running PixOS 8.0 ([PR2480](https://github.com/librenms/librenms/pull/2480))
    - Fix bug in Proxmox support if only one VM was detected ([PR2490](https://github.com/librenms/librenms/pull/2490), [PR2547](https://github.com/librenms/librenms/pull/2547))
  - Alerting:
    - Strip && and || from query for device-groups ([PR2476](https://github.com/librenms/librenms/pull/2476))
    - Fix transports being triggered when empty keys set ([PR2491](https://github.com/librenms/librenms/pull/2491))
  Misc:
    - Updated device_traffic_descr config to stop graphs failing ([PR2386](https://github.com/librenms/librenms/pull/2386))

#### Improvements
  - WebUI:
    - Status column now sortable for /devices/ ([PR2397](https://github.com/librenms/librenms/pull/2397))
    - Update Gridster library to be responsive ([PR2414](https://github.com/librenms/librenms/pull/2414))
    - Improved rrdtool 1.4/1.5 compatibility ([PR2430](https://github.com/librenms/librenms/pull/2430))
    - Use event_id in query for Eventlog ([PR2437](https://github.com/librenms/librenms/pull/2437))
    - Add graph selector to devices overview ([PR2438](https://github.com/librenms/librenms/pull/2438))
    - Improved Navbar for varying screen sizes ([PR2450](https://github.com/librenms/librenms/pull/2450))
    - Added RIPE NCC API support for lookups ([PR2455](https://github.com/librenms/librenms/pull/2455), [PR2474](https://github.com/librenms/librenms/pull/2474))
    - Improved ports page for device with large number of neighbours ([PR2460](https://github.com/librenms/librenms/pull/2460))
    - Merged all CPU graphs into one on overview page ([PR2470](https://github.com/librenms/librenms/pull/2470))
    - Added support for sorting by traffic on device port page ([PR2508](https://github.com/librenms/librenms/pull/2508))
    - Added support for dynamic graph sizes based on browser size ([PR2510](https://github.com/librenms/librenms/pull/2510))
    - Made device location clickable in device header ([PR2515](https://github.com/librenms/librenms/pull/2515))
    - Visual improvements to bills page ([PR2519](https://github.com/librenms/librenms/pull/2519))
  - Discovery / Polling:
    - Updated Cisco SB discovery ([PR2396](https://github.com/librenms/librenms/pull/2396))
    - Added Ceph support via Applications ([PR2412](https://github.com/librenms/librenms/pull/2412))
    - Added support for per device unix-agent port ([PR2439](https://github.com/librenms/librenms/pull/2439))
    - Added ability to select up/down devices on worldmap ([PR2441](https://github.com/librenms/librenms/pull/2441))
    - Allow powerdns app to be set for Unix Agent ([PR2489](https://github.com/librenms/librenms/pull/2489))
    - Added SLES detection to distro script ([PR2502](https://github.com/librenms/librenms/pull/2502))
  - Added detection for:
    - Added CPU + Memory usage for Ubiquiti UniFi ([PR2421](https://github.com/librenms/librenms/pull/2421))
    - Added support for LigoWave Infinity AP's ([PR2456](https://github.com/librenms/librenms/pull/2456))
  - Alerting:
    - Added ability to globally disable sending alerts ([PR2385](https://github.com/librenms/librenms/pull/2385))
    - Added support for Clickatell, PlaySMS and VictorOps ([PR24104](https://github.com/librenms/librenms/pull/24104), [PR2443](https://github.com/librenms/librenms/pull/2443))
  - Documentation:
    - Improved CentOS install docs ([PR2462](https://github.com/librenms/librenms/pull/2462))
    - Improved Proxmox setup docs ([PR2483](https://github.com/librenms/librenms/pull/2483))
  - Misc:
    - Provide InnoDB config for buffer size issues ([PR2401](https://github.com/librenms/librenms/pull/2401))
    - Added AD Authentication support ([PR2411](https://github.com/librenms/librenms/pull/2411), [PR2425](https://github.com/librenms/librenms/pull/2425), [PR2432](https://github.com/librenms/librenms/pull/2432), [PR2434](https://github.com/librenms/librenms/pull/2434))
    - Added Features document ([PR2436](https://github.com/librenms/librenms/pull/2436), [PR2511](https://github.com/librenms/librenms/pull/2511), [PR2513](https://github.com/librenms/librenms/pull/2513))
    - Centralised innodb buffer check and added to validate ([PR2482](https://github.com/librenms/librenms/pull/2482))
    - Updated and improved daily.sh ([PR2487](https://github.com/librenms/librenms/pull/2487))


### October 2015

#### Bug fixes
  - Discovery / Polling:
    - Check file exists via rrdcached before creating new files on 1.5 ([PR2041](https://github.com/librenms/librenms/pull/2041))
    - Fix Riverbed discovery ([PR2133](https://github.com/librenms/librenms/pull/2133))
    - Fixes issue where snmp_get would not return the value 0 ([PR2134](https://github.com/librenms/librenms/pull/2134))
    - Fixed powerdns snmp checks ([PR2176](https://github.com/librenms/librenms/pull/2176))
    - De-dupe checks for hostname when adding hosts ([PR2189](https://github.com/librenms/librenms/pull/2189))
  - WebUI:
    - Soft fail if PHP Pear not installed ([PR2036](https://github.com/librenms/librenms/pull/2036))
    - Escape quotes for ifAlias in overlib calls ([PR2072](https://github.com/librenms/librenms/pull/2072))
    - Fix table name for access points ([PR2075](https://github.com/librenms/librenms/pull/2075))
    - Removed STACK text in graphs ([PR2097](https://github.com/librenms/librenms/pull/2097))
    - Enable multiple ifDescr overrides to be done per device ([PR2099](https://github.com/librenms/librenms/pull/2099))
    - Removed ping + performance graphs and tab if skip ping check ([PR2175](https://github.com/librenms/librenms/pull/2175))
    - Fixed services -> Alerts menu link + page ([PR2173](https://github.com/librenms/librenms/pull/2173))
    - Fix percent bar also for quota bills ([PR2198](https://github.com/librenms/librenms/pull/2198))
    - Fix new Bill ([PR2199](https://github.com/librenms/librenms/pull/2199))
    - Change default solver to hierarchicalRepulsion in vis.js ([PR2202](https://github.com/librenms/librenms/pull/2202))
    - Fix: setting user port permissions fails ([PR2203](https://github.com/librenms/librenms/pull/2203))
    - Updated devices Graphs links to use non-static time references ([PR2211](https://github.com/librenms/librenms/pull/2211))
    - Removed ignored,deleted and disabled ports from query ([PR2213](https://github.com/librenms/librenms/pull/2213))
  - API:
    - Fixed API call for alert states ([PR2076](https://github.com/librenms/librenms/pull/2076))
    - Fixed nginx rewrite for api ([PR2112](https://github.com/librenms/librenms/pull/2112))
    - Change on the add_edit_rule to modify a rule without modify the name ([PR2159](https://github.com/librenms/librenms/pull/2159))
    - Fixed list_bills function when using :bill_id ([PR2212](https://github.com/librenms/librenms/pull/2212))

#### Improvements
  - WebUI:
    - Updated Bootstrap to 3.3.5 ([PR2015](https://github.com/librenms/librenms/pull/2015))
    - Added billing graphs to graphs widget ([PR2027](https://github.com/librenms/librenms/pull/2027))
    - Lock widgets by default so they can't be moved ([PR2042](https://github.com/librenms/librenms/pull/2042))
    - Moved Device Groups menu ([PR2049](https://github.com/librenms/librenms/pull/2049))
    - Show Config tab only if device isn't excluded from oxidized ([PR2118](https://github.com/librenms/librenms/pull/2118))
    - Simplify adding config options to WebUI ([PR2120](https://github.com/librenms/librenms/pull/2120))
    - Move red map markers to foreground ([PR2127](https://github.com/librenms/librenms/pull/2127))
    - Styled the two factor auth token prompt ([PR2151](https://github.com/librenms/librenms/pull/2151))
    - Update Font Awesome ([PR2167](https://github.com/librenms/librenms/pull/2167))
    - Allow user to influence when devices are grouped on world map ([PR2170](https://github.com/librenms/librenms/pull/2170))
    - Centralised the date selector for graphs for re-use ([PR2183](https://github.com/librenms/librenms/pull/2183))
    - Don't show dashboard settings if `/bare=yes/` ([PR2364](https://github.com/librenms/librenms/pull/2364))
  - API:
    - Added unmute alert function to API ([PR2082](https://github.com/librenms/librenms/pull/2082))
  - Discovery / Polling:
    - Added additional support for some UPS' based on Multimatic cards ([PR2046](https://github.com/librenms/librenms/pull/2046))
    - Improved WatchGuard OS detection ([PR2048](https://github.com/librenms/librenms/pull/2048))
    - Treat Dell branded Wifi controllers as ArubaOS ([PR2065](https://github.com/librenms/librenms/pull/2065))
    - Added discovery option for OS or Device type ([PR2088](https://github.com/librenms/librenms/pull/2088))
    - Updated pfSense to firewall type ([PR2096](https://github.com/librenms/librenms/pull/2096))
    - Added ability to turn off icmp checks globally or per device ([PR2131](https://github.com/librenms/librenms/pull/2131))
    - Reformat check a bit to make it easier for adding additional oids in ([PR2135](https://github.com/librenms/librenms/pull/2135))
    - Updated to disable auto-discovery by ip ([PR2182](https://github.com/librenms/librenms/pull/2182))
    - Updated to use env in distro script ([PR2204](https://github.com/librenms/librenms/pull/2204))
  - Added detection for:
    - Pulse Secure OS ([PR2053](https://github.com/librenms/librenms/pull/2053))
    - Riverbed Steelhead support ([PR2107](https://github.com/librenms/librenms/pull/2107))
    - OpenBSD sensors ([PR2113](https://github.com/librenms/librenms/pull/2113))
    - Additional comware detection ([PR2162](https://github.com/librenms/librenms/pull/2162))
    - Version from Synology MIB ([PR2163](https://github.com/librenms/librenms/pull/2163))
    - VCSA as VMWare ([PR2185](https://github.com/librenms/librenms/pull/2185))
    - SAF Lumina radios ([PR2361](https://github.com/librenms/librenms/pull/2361))
    - TP-Link detection ([PR2362](https://github.com/librenms/librenms/pull/2362))
  - Documentation:
    - Improved RHEL/CentOS install docs ([PR2043](https://github.com/librenms/librenms/pull/2043))
    - Update Varnish Docs ([PR2116](https://github.com/librenms/librenms/pull/2116), [PR2126](https://github.com/librenms/librenms/pull/2126))
    - Added passworded channels for the IRC-Bot ([PR2122](https://github.com/librenms/librenms/pull/2122))
    - Updated Two-Factor-Auth.md RE: Google Authenticator ([PR2146](https://github.com/librenms/librenms/pull/2146))
  - General:
    - Added colour support to IRC bot ([PR2059](https://github.com/librenms/librenms/pull/2059))
    - Fixed IRC bot reconnect if socket dies ([PR2061](https://github.com/librenms/librenms/pull/2061))
    - Updated default crons ([PR2177](https://github.com/librenms/librenms/pull/2177))
  - Reverts:
    - "Removed what appears to be unnecessary STACK text" ([PR2128](https://github.com/librenms/librenms/pull/2128))

### September 2015

#### Bug fixes
  - Alerting:
    - Process followups if there are changes ([PR1817](https://github.com/librenms/librenms/pull/1817))
    - Typo in alert_window setting ([PR1841](https://github.com/librenms/librenms/pull/1841))
    - Issue alert-trigger as test object ([PR1850](https://github.com/librenms/librenms/pull/1850))
  - WebUI:
    - Fix permissions for World-map widget ([PR1866](https://github.com/librenms/librenms/pull/1866))
    - Clean up Global / World Map name mixup ([PR1874](https://github.com/librenms/librenms/pull/1874))
    - Removed required flag for community when adding new hosts ([PR1961](https://github.com/librenms/librenms/pull/1961))
    - Stop duplicate devices showing in map ([PR1963](https://github.com/librenms/librenms/pull/1963))
    - Fix adduser bug storing users real name ([PR1990](https://github.com/librenms/librenms/pull/1990))
    - Stop alerts top-menu being clickable ([PR1995](https://github.com/librenms/librenms/pull/1995))
  - Services:
    - Honour IP field for DNS checks ([PR1933](https://github.com/librenms/librenms/pull/1933))
  - Discovery / Poller:
    - Fix Huawei VRP os detection ([PR1931](https://github.com/librenms/librenms/pull/1931))
    - Set empty processor descr for *nix processors ([PR1951](https://github.com/librenms/librenms/pull/1951))
    - Ensure udp6/tcp6 snmp devices use fping6 ([PR1959](https://github.com/librenms/librenms/pull/1959))
    - Fix RRD creation parameters ([PR2010](https://github.com/librenms/librenms/pull/2010))
  - General:
    - Remove 'sh' from cronjob ([PR1818](https://github.com/librenms/librenms/pull/1818))
    - Remove MySQL Locks ([PR1822](https://github.com/librenms/librenms/pull/1822),[PR1826](https://github.com/librenms/librenms/pull/1826),[PR1829](https://github.com/librenms/librenms/pull/1829),[PR1836](https://github.com/librenms/librenms/pull/1836))
    - Change DB config options to use single quotes to allow $ ([PR1948](https://github.com/librenms/librenms/pull/1948))

#### Improvements
  - WebUI:
    - Ability to edit ifAlias ([PR1811](https://github.com/librenms/librenms/pull/1811))
    - Honour Mouseout/Mouseleave on map widget ([PR1814](https://github.com/librenms/librenms/pull/1814))
    - Make syslog/eventlog responsive ([PR1816](https://github.com/librenms/librenms/pull/1816))
    - Reformat Proxmox UI ([PR1825](https://github.com/librenms/librenms/pull/1825),[PR1827](https://github.com/librenms/librenms/pull/1827))
    - Misc Changes ([PR1828](https://github.com/librenms/librenms/pull/1828),[PR1830](https://github.com/librenms/librenms/pull/1830),[PR1875](https://github.com/librenms/librenms/pull/1875),[PR1885](https://github.com/librenms/librenms/pull/1885),[PR1886](https://github.com/librenms/librenms/pull/1886),[PR1887](https://github.com/librenms/librenms/pull/1887),[PR1891](https://github.com/librenms/librenms/pull/1891),[PR1896](https://github.com/librenms/librenms/pull/1896),[PR1901](https://github.com/librenms/librenms/pull/1901),[PR1913](https://github.com/librenms/librenms/pull/1913),[PR1944](https://github.com/librenms/librenms/pull/1944))
    - Added support for Oxidized versioning ([PR1842](https://github.com/librenms/librenms/pull/1842))
    - Added graph widget + settings for widgets ([PR1835](https://github.com/librenms/librenms/pull/1835),[PR1861](https://github.com/librenms/librenms/pull/1861),[PR1968](https://github.com/librenms/librenms/pull/1968))
    - Added Support for multiple dashboards ([PR1869](https://github.com/librenms/librenms/pull/1869))
    - Added settings page for Worldmap widget ([PR1872](https://github.com/librenms/librenms/pull/1872))
    - Added uptime to availability widget ([PR1881](https://github.com/librenms/librenms/pull/1881))
    - Added top devices and ports widgets ([PR1903](https://github.com/librenms/librenms/pull/1903))
    - Added support for saving notes for devices ([PR1927](https://github.com/librenms/librenms/pull/1927))
    - Added fullscreen mobile support ([PR2022](https://github.com/librenms/librenms/pull/2022))
  - Added detection for:
    - FortiOS ([PR1815](https://github.com/librenms/librenms/pull/1815))
    - HP MSM ([PR1953](https://github.com/librenms/librenms/pull/1953))
  - Discovery / Poller:
    - Added Proxmox support ([PR1789](https://github.com/librenms/librenms/pull/1789))
    - Added CPU/Mem support for SonicWALL ([PR1957](https://github.com/librenms/librenms/pull/1957))
    - Updated distro script to support Arch Linux + fall back to lsb-release ([PR1978](https://github.com/librenms/librenms/pull/1978))
  - Documentation:
    - Add varnish docs ([PR1809](https://github.com/librenms/librenms/pull/1809))
    - Added CentOS 7 RRCached docs ([PR1893](https://github.com/librenms/librenms/pull/1893))
    - Improved description of fping options ([PR1952](https://github.com/librenms/librenms/pull/1952))
  - Alerting:
    - Added RegEx support for alert rules and device groups ([PR1998](https://github.com/librenms/librenms/pull/1998))
  - General:
    - Make installer more responsive ([PR1832](https://github.com/librenms/librenms/pull/1832))
    - Update fping millisec option to 200 default ([PR1833](https://github.com/librenms/librenms/pull/1833))
    - Reduced cleanup of device_perf ([PR1837](https://github.com/librenms/librenms/pull/1837))
    - Added support for negative values in munin-plugins ([PR1907](https://github.com/librenms/librenms/pull/1907))
    - Added default librenms user to config for use in validate.php ([PR1956](https://github.com/librenms/librenms/pull/1956))
    - Added working memcache support ([PR2007](https://github.com/librenms/librenms/pull/2007))

### August 2015

#### Bug fixes
  - WebUI:
    - Fix web_mouseover not honoured on All Devices page ([PR1592](https://github.com/librenms/librenms/pull/1592))
    - Fixed bug with edit/create alert template to clear out previous values ([PR1636](https://github.com/librenms/librenms/pull/1636))
    - Initialise $port_count in devices list ([PR1640](https://github.com/librenms/librenms/pull/1640))
    - Fixed Web installer due to code tidying update ([PR1644](https://github.com/librenms/librenms/pull/1644))
    - Updated gridster variable names to make unique ([PR1646](https://github.com/librenms/librenms/pull/1646))
    - Fixed issues with displaying devices with ' in location ([PR1655](https://github.com/librenms/librenms/pull/1655))
    - Fixes updating snmpv3 details in webui ([PR1727](https://github.com/librenms/librenms/pull/1727))
    - Check for user perms before listing neighbour ports ([PR1749](https://github.com/librenms/librenms/pull/1749))
    - Fixed Test-Transport button ([PR1772](https://github.com/librenms/librenms/pull/1772))
  - DB:
    - Added proper indexes on device_perf table ([PR1621](https://github.com/librenms/librenms/pull/1621))
    - Fixed multiple mysql strict issues ([PR1638](https://github.com/librenms/librenms/pull/1638), [PR1659](https://github.com/librenms/librenms/pull/1659))
    - Convert bgpPeerRemoteAs to bigint ([PR1691](https://github.com/librenms/librenms/pull/1691))
  - Discovery / Poller:
    - Fixed Synology system temps ([PR1649](https://github.com/librenms/librenms/pull/1649))
    - Fixed discovery-arp not running since code formatting update ([PR1671](https://github.com/librenms/librenms/pull/1671))
    - Correct the DSM upgrade OID ([PR1696](https://github.com/librenms/librenms/pull/1696))
    - Fix MySQL agent host variable usage ([PR1710](https://github.com/librenms/librenms/pull/1710))
    - Pass snmp-auth parameters enclosed by single-quotes ([PR1730](https://github.com/librenms/librenms/pull/1730))
    - Revert change which skips over down ports ([PR1742](https://github.com/librenms/librenms/pull/1742))
    - Stop PoE polling for each port ([PR1747](https://github.com/librenms/librenms/pull/1747))
    - Use ifHighSpeed if ifSpeed equals 0 ([PR1750](https://github.com/librenms/librenms/pull/1750))
    - Keep PHP Backwards compatibility ([PR1766](https://github.com/librenms/librenms/pull/1766))
    - False identification of Zyxel as Cisco ([PR1776](https://github.com/librenms/librenms/pull/1776))
    - Fix MySQL statement in poller-service.py ([PR1794](https://github.com/librenms/librenms/pull/1794))
    - Fix upstart script for poller-service.py ([PR1812](https://github.com/librenms/librenms/pull/1812))
  - General:
    - Fixed path to defaults.inc.php in config.php.default ([PR1673](https://github.com/librenms/librenms/pull/1673))
    - Strip '::ffff:' from syslog input ([PR1734](https://github.com/librenms/librenms/pull/1734))
    - Fix RRA ([PR1791](https://github.com/librenms/librenms/pull/1791))

#### Improvements
  - WebUI Updates:
    - Added support for Google API key in Geo coding ([PR1594](https://github.com/librenms/librenms/pull/1594))
    - Added ability to updated storage % warning ([PR1613](https://github.com/librenms/librenms/pull/1613))
    - Updated eventlog page to allow filtering by type ([PR1623](https://github.com/librenms/librenms/pull/1623))
    - Hide logo and plugins text on smaller windows ([PR1624](https://github.com/librenms/librenms/pull/1624))
    - Added poller group name to poller groups table ([PR1634](https://github.com/librenms/librenms/pull/1634))
    - Updated Customers page to use Bootgrid ([PR1658](https://github.com/librenms/librenms/pull/1658))
    - Added basic Graylog integration support ([PR1665](https://github.com/librenms/librenms/pull/1665))
    - Added support for running under sub-directory ([PR1667](https://github.com/librenms/librenms/pull/1667))
    - Updated vis.js to latest version ([PR1708](https://github.com/librenms/librenms/pull/1708))
    - Added border on availability map ([PR1713](https://github.com/librenms/librenms/pull/1713))
    - Make new dashboard the default ([PR1719](https://github.com/librenms/librenms/pull/1719))
    - Rearrange about page ([PR1735](https://github.com/librenms/librenms/pull/1735),[PR1743](https://github.com/librenms/librenms/pull/1743))
    - Center/Cleanup graphs ([PR1736](https://github.com/librenms/librenms/pull/1736))
    - Added Hover-Effect on devices table ([PR1738](https://github.com/librenms/librenms/pull/1738))
    - Show Test-Transport result ([PR1777](https://github.com/librenms/librenms/pull/1777))
    - Add arrows to the network map ([PR1787](https://github.com/librenms/librenms/pull/1787))
    - Add errored ports to summary widget ([PR1788](https://github.com/librenms/librenms/pull/1788))
    - Show message if no Device-Groups exist ([PR1796](https://github.com/librenms/librenms/pull/1796))
    - Misc UI fixes (Titles, Headers, ...) ([PR1797](https://github.com/librenms/librenms/pull/1797),[PR1798](https://github.com/librenms/librenms/pull/1798),[PR1800](https://github.com/librenms/librenms/pull/1800),[PR1801](https://github.com/librenms/librenms/pull/1801),[PR1802](https://github.com/librenms/librenms/pull/1802),[PR1803](https://github.com/librenms/librenms/pull/1803),[PR1804](https://github.com/librenms/librenms/pull/1804),[PR1805](https://github.com/librenms/librenms/pull/1805))
    - Move packages to overview dropdown ([PR1810](https://github.com/librenms/librenms/pull/1810))
  - API Updates:
    - Improved billing support in API ([PR1599](https://github.com/librenms/librenms/pull/1599))
    - Extended support for list devices to support mac/ipv4 and ipv6 filtering ([PR1744](https://github.com/librenms/librenms/pull/1744))
  - Added detection for:
    - Perle Media convertors ([PR1607](https://github.com/librenms/librenms/pull/1607))
    - Mac OSX 10 ([PR1774](https://github.com/librenms/librenms/pull/1774))
  - Improved detection for:
    - Windows devices ([PR1639](https://github.com/librenms/librenms/pull/1639))
    - Zywall CPU, Version and Memory ([PR1660](https://github.com/librenms/librenms/pull/1660),[PR1784](https://github.com/librenms/librenms/pull/1784))
    - Added LLDP support for PBN devices ([PR1705](https://github.com/librenms/librenms/pull/1705))
    - Netgear GS110TP ([PR1751](https://github.com/librenms/librenms/pull/1751))
  - Additional Sensors:
    - Added Compressor state for PCOWEB ([PR1600](https://github.com/librenms/librenms/pull/1600))
    - Added dbm support for IOS-XR ([PR1661](https://github.com/librenms/librenms/pull/1661))
    - Added temperature support for DNOS ([PR1782](https://github.com/librenms/librenms/pull/1782))
  - Discovery / Poller:
    - Updated autodiscovery function to log new type ([PR1623](https://github.com/librenms/librenms/pull/1623))
    - Improve application polling ([PR1724](https://github.com/librenms/librenms/pull/1724))
    - Improve debug output ([PR1756](https://github.com/librenms/librenms/pull/1756))
  - DB:
    - Added MySQLi support ([PR1647](https://github.com/librenms/librenms/pull/1647))
  - Documentation:
    - Added docs on MySQL strict mode ([PR1635](https://github.com/librenms/librenms/pull/1635))
    - Updated billing docs to use librenms user in cron ([PR1676](https://github.com/librenms/librenms/pull/1676))
    - Updated LDAP docs to indicate php-ldap module needs installing ([PR1716](https://github.com/librenms/librenms/pull/1716))
    - Typo/Spellchecks ([PR1731](https://github.com/librenms/librenms/pull/1731),[PR1806](https://github.com/librenms/librenms/pull/1806))
    - Improved Alerting and Device-Groups ([PR1781](https://github.com/librenms/librenms/pull/1781))
  - Alerting:
    - Reformatted eventlog message to show state for alerts ([PR1685](https://github.com/librenms/librenms/pull/1685))
    - Add basic Pushbullet transport ([PR1721](https://github.com/librenms/librenms/pull/1721))
    - Allow custom titles ([PR1807](https://github.com/librenms/librenms/pull/1807))
  - General:
    - Added more debugging and checks to discovery-protocols ([PR1590](https://github.com/librenms/librenms/pull/1590))
    - Cleanup debug statements ([PR1725](https://github.com/librenms/librenms/pull/1725),[PR1737](https://github.com/librenms/librenms/pull/1737))

### July 2015

#### Bug fixes
  - WebUI:
    - Fixed API not functioning. ([PR1367](https://github.com/librenms/librenms/pull/1367))
    - Fixed API not storing alert rule names ([PR1372](https://github.com/librenms/librenms/pull/1372))
    - Fixed datetimepicker use ([PR1376](https://github.com/librenms/librenms/pull/1376))
    - Added 'running' status for BGP peers as up ([PR1412](https://github.com/librenms/librenms/pull/1412))
    - Fixed the remove search link in devices ([PR1413](https://github.com/librenms/librenms/pull/1413))
    - Fixed clicking anywhere in a search result will now take you to where you want ([PR1472](https://github.com/librenms/librenms/pull/1472))
    - Fixed inventory page not displaying results ([PR1488](https://github.com/librenms/librenms/pull/1488))
    - Fixed buggy alert templating in WebUI ([PR1527](https://github.com/librenms/librenms/pull/1527))
    - Fixed bug in creating api tokens in Firefox ([PR1530](https://github.com/librenms/librenms/pull/1530))
  - Discovery / Poller:
    - Do not allow master to rejoin itself. ([PR1377](https://github.com/librenms/librenms/pull/1377))
    - Fixed poller group query in discovery ([PR1433](https://github.com/librenms/librenms/pull/1433))
    - Fixed ARMv5 detection ([PR1522](https://github.com/librenms/librenms/pull/1522))
    - Fixed pfSense detection ([PR1567](https://github.com/librenms/librenms/pull/1567))
  - Sensors:
    - Fixed bug in EqualLogic sensors ([PR1513](https://github.com/librenms/librenms/pull/1513))
    - Fixed bug in DRAC voltage sensor ([PR1521](https://github.com/librenms/librenms/pull/1521))
    - Fixed bug in APC bank detection ([PR1560](https://github.com/librenms/librenms/pull/1560))
  - Documentation:
    - Fixed Nginx config file ([PR1389](https://github.com/librenms/librenms/pull/1389))
  - General:
    - Fixed a number of permission issues ([PR1411](https://github.com/librenms/librenms/pull/1411))

#### Improvements
  - Added detection for:
    - Meraki ([PR1402](https://github.com/librenms/librenms/pull/1402))
    - Brocade ([PR1404](https://github.com/librenms/librenms/pull/1404))
    - Dell iDrac ([PR1419](https://github.com/librenms/librenms/pull/1419),[PR1420](https://github.com/librenms/librenms/pull/1420),[PR1423](https://github.com/librenms/librenms/pull/1423),[PR1427](https://github.com/librenms/librenms/pull/1427))
    - Dell Networking OS ([PR1474](https://github.com/librenms/librenms/pull/1474))
    - Netonix ([PR1476](https://github.com/librenms/librenms/pull/1476))
    - IBM Tape Library ([PR1519](https://github.com/librenms/librenms/pull/1519),[PR1550](https://github.com/librenms/librenms/pull/1550))
    - Aerohive ([PR1546](https://github.com/librenms/librenms/pull/1546))
    - Cisco Voice Gateways ([PR1565](https://github.com/librenms/librenms/pull/1565))
  - Improved detection for:
    - RouterOS RB260GS ([PR1545](https://github.com/librenms/librenms/pull/1545))
    - Dell PowerConnect ([PR1452](https://github.com/librenms/librenms/pull/1452),[PR1517](https://github.com/librenms/librenms/pull/1517))
    - Brocade ([PR1548](https://github.com/librenms/librenms/pull/1548))
    - Rielo UPS ([PR1381](https://github.com/librenms/librenms/pull/1381))
    - Cisco IPSLAs ([PR1586](https://github.com/librenms/librenms/pull/1586))
  - Additional Sensors:
    - Added power, temperature and fan speed support for XOS ([PR1493](https://github.com/librenms/librenms/pull/1493),[PR1494](https://github.com/librenms/librenms/pull/1494),[PR1496](https://github.com/librenms/librenms/pull/1496))
  - WebUI Updates:
    - Added missing load and state icons ([PR1392](https://github.com/librenms/librenms/pull/1392))
    - Added ability to update users passwords in WebUI ([PR1440](https://github.com/librenms/librenms/pull/1440))
    - Default to two days performance data being shown ([PR1442](https://github.com/librenms/librenms/pull/1442))
    - Improved sensors page for mobile view ([PR1454](https://github.com/librenms/librenms/pull/1454))
    - Improvements to network map ([PR1455](https://github.com/librenms/librenms/pull/1455),[PR1470](https://github.com/librenms/librenms/pull/1470),[PR1486](https://github.com/librenms/librenms/pull/1486),[PR1528](https://github.com/librenms/librenms/pull/1528),[PR1557](https://github.com/librenms/librenms/pull/1557))
    - Added availability map ([PR1464](https://github.com/librenms/librenms/pull/1464))
    - Updated edit ports page to use Bootstrap ([PR1498](https://github.com/librenms/librenms/pull/1498))
    - Added new World Map and support for lat/lng lookup ([PR1501](https://github.com/librenms/librenms/pull/1501),[PR1552](https://github.com/librenms/librenms/pull/1552))
    - Added sysName to overview page for device ([PR1520](https://github.com/librenms/librenms/pull/1520))
    - Added New Overview dashboard uilising Widgets ([PR1523](https://github.com/librenms/librenms/pull/1523),[PR1580](https://github.com/librenms/librenms/pull/1580))
    - Added new config option to disable Device groups ([PR1569](https://github.com/librenms/librenms/pull/1569))
  - Discovery / Poller Updates:
    - Updated discovery of IP based devices ([PR1406](https://github.com/librenms/librenms/pull/1406))
    - Added using cronic for poller-wrapper.py to allow cron to send emails ([PR1408](https://github.com/librenms/librenms/pull/1408),[PR1531](https://github.com/librenms/librenms/pull/1531))
    - Updated Cisco MIBs to latest versions ([PR1436](https://github.com/librenms/librenms/pull/1436))
    - Improve performance of unix-agent processes DB code ([PR1447](https://github.com/librenms/librenms/pull/1447),[PR1460](https://github.com/librenms/librenms/pull/1460))
    - Added BGP discovery code ([PR1414](https://github.com/librenms/librenms/pull/1414))
    - Use snmpEngineTime as a fallback to uptime ([PR1477](https://github.com/librenms/librenms/pull/1477))
    - Added fallback support for devices not reporting ifAlias ([PR1479](https://github.com/librenms/librenms/pull/1479))
    - Git pull and schema updates will now pause if InnoDB buffers overused ([PR1563](https://github.com/librenms/librenms/pull/1563))
  - Documentation:
    - Updated Unix-Agent docs to use LibreNMS repo for scripts ([PR1568](https://github.com/librenms/librenms/pull/1568),[PR1570](https://github.com/librenms/librenms/pull/1570),[PR1573](https://github.com/librenms/librenms/pull/1573))
    - Added info on using MariaDB ([PR1585](https://github.com/librenms/librenms/pull/1585))
  - Alerting:
    - Added Boxcar (www.boxcar.io) transport for alerting ([PR1481](https://github.com/librenms/librenms/pull/1481))
    - Removed old alerting code ([PR1581](https://github.com/librenms/librenms/pull/1581))
  - General:
    - Code cleanup and formatting ([PR1415](https://github.com/librenms/librenms/pull/1415),[PR1416](https://github.com/librenms/librenms/pull/1416),[PR1431](https://github.com/librenms/librenms/pull/1431),[PR1434](https://github.com/librenms/librenms/pull/1434),[PR1439](https://github.com/librenms/librenms/pull/1439),[PR1444](https://github.com/librenms/librenms/pull/1444),[PR1450](https://github.com/librenms/librenms/pull/1450))
    - Added support for CollectD flush ([PR1463](https://github.com/librenms/librenms/pull/1463))
    - Added support for LDAP pure DN member groups ([PR1516](https://github.com/librenms/librenms/pull/1516))
    - Updated validate.php to check for distributed poller setup issues ([PR1526](https://github.com/librenms/librenms/pull/1526))
    - Improved service check support ([PR1385](https://github.com/librenms/librenms/pull/1385),[PR1386](https://github.com/librenms/librenms/pull/1386),[PR1387](https://github.com/librenms/librenms/pull/1387),[PR1388](https://github.com/librenms/librenms/pull/1388))
    - Added SNMP Scanner to discover devices within subnets and docs ([PR1577](https://github.com/librenms/librenms/pull/1577))

### June 2015

#### Bug fixes
  - Fixed services list SQL issue ([PR1181](https://github.com/librenms/librenms/pull/1181))
  - Fixed negative values for storage when volume is > 2TB ([PR1185](https://github.com/librenms/librenms/pull/1185))
  - Fixed visual display for input fields on /syslog/ ([PR1193](https://github.com/librenms/librenms/pull/1193))
  - Fixed fatal php issue in shoutcast.php ([PR1203](https://github.com/librenms/librenms/pull/1203))
  - Fixed percent bars in /bills/ ([PR1208](https://github.com/librenms/librenms/pull/1208))
  - Fixed item count in memory and storage pages ([PR1210](https://github.com/librenms/librenms/pull/1210))
  - Fixed syslog not loading ([PR1219](https://github.com/librenms/librenms/pull/1219))
  - Fixed fatal on reload in IRC bot ([PR1218](https://github.com/librenms/librenms/pull/1218))
  - Alter Windows CPU description when unknown ([PR1226](https://github.com/librenms/librenms/pull/1226))
  - Fixed rfc1628 current calculation ([PR1256](https://github.com/librenms/librenms/pull/1256))
  - Fixed alert mapping not working ([PR1280](https://github.com/librenms/librenms/pull/1280))
  - Fixed legend ifLabels ([PR1296](https://github.com/librenms/librenms/pull/1296))
  - Fixed bug causing map to not load when stale link data was present ([PR1297](https://github.com/librenms/librenms/pull/1297))
  - Fixed javascript issue preventing removal of alert rules ([PR1312](https://github.com/librenms/librenms/pull/1312))
  - Fixed removal of IPs before ports are deleted ([PR1329](https://github.com/librenms/librenms/pull/1329))
  - Fixed JS issue when removing ports from bills ([PR1330](https://github.com/librenms/librenms/pull/1330))
  - Fixed adding --daemon a second time to collectd Graphs ([PR1342](https://github.com/librenms/librenms/pull/1342))
  - Fixed CollectD DS names ([PR1347](https://github.com/librenms/librenms/pull/1347),[PR1349](https://github.com/librenms/librenms/pull/1349),[PR1368](https://github.com/librenms/librenms/pull/1368))
  - Fixed graphing issues when rrd contains special chars ([PR1350](https://github.com/librenms/librenms/pull/1350))
  - Fixed regex for device groups ([PR1359](https://github.com/librenms/librenms/pull/1359))
  - Added HOST-RESOURCES-MIB into Synology detection (RP1360)
  - Fix health page graphs showing the first graph for all ([PR1363](https://github.com/librenms/librenms/pull/1363))

#### Improvements
  - Updated Syslog docs to include syslog-ng 3.5.1 updates ([PR1171](https://github.com/librenms/librenms/pull/1171))
  - Added Pushover Transport ([PR1180](https://github.com/librenms/librenms/pull/1180), [PR1191](https://github.com/librenms/librenms/pull/1191))
  - Converted processors and memory table to bootgrid ([PR1188](https://github.com/librenms/librenms/pull/1188), [PR1192](https://github.com/librenms/librenms/pull/1192))
  - Issued alerts and transport now logged to eventlog ([PR1194](https://github.com/librenms/librenms/pull/1194))
  - Added basic support for Enterasys devices ([PR1211](https://github.com/librenms/librenms/pull/1211))
  - Added dynamic config to configure alerting ([PR1153](https://github.com/librenms/librenms/pull/1153))
  - Added basic support for Multimatic USV ([PR1215](https://github.com/librenms/librenms/pull/1215))
  - Disabled and ignored ports no longer show by default on /ports/ ([PR1228](https://github.com/librenms/librenms/pull/1228),[PR1301](https://github.com/librenms/librenms/pull/1301))
  - Added additional graphs to menu on devices page ([PR1229](https://github.com/librenms/librenms/pull/1229))
  - Added Docs on configuring Globe front page ([PR1231](https://github.com/librenms/librenms/pull/1231))
  - Added robots.txt to html folder to disallow indexing ([PR1234](https://github.com/librenms/librenms/pull/1234))
  - Added additional support for Synology units ([PR1235](https://github.com/librenms/librenms/pull/1235),[PR1244](https://github.com/librenms/librenms/pull/1244),[PR1269](https://github.com/librenms/librenms/pull/1269))
  - Added IP check to autodiscovery code ([PR1248](https://github.com/librenms/librenms/pull/1248))
  - Updated HP ProCurve detection ([PR1249](https://github.com/librenms/librenms/pull/1249))
  - Added basic detection for Alcatel-Lucent OmniSwitch ([PR1253](https://github.com/librenms/librenms/pull/1253), [PR1282](https://github.com/librenms/librenms/pull/1282))
  - Added additional metrics for rfc1628 UPS ([PR1258](https://github.com/librenms/librenms/pull/1258), [PR1268](https://github.com/librenms/librenms/pull/1268))
  - Allow multiple discovery modules to be specified on command line ([PR1263](https://github.com/librenms/librenms/pull/1263))
  - Updated docs on using libvirt ([PR1264](https://github.com/librenms/librenms/pull/1264))
  - Updated Ruckus detection ([PR1267](https://github.com/librenms/librenms/pull/1267))
  - Initial release of MIB based polling ([PR1273](https://github.com/librenms/librenms/pull/1273))
  - Added support for CISCO-BGP4-MIB ([PR1184](https://github.com/librenms/librenms/pull/1184))
  - Added support for Dell EqualLogic units ([PR1283](https://github.com/librenms/librenms/pull/1283),[PR1309](https://github.com/librenms/librenms/pull/1309))
  - Added logging of success/ failure for alert transports ([PR1286](https://github.com/librenms/librenms/pull/1286))
  - Updated VyOS detection ([PR1299](https://github.com/librenms/librenms/pull/1299))
  - Added primary serial number detection for Cisco units ([PR1300](https://github.com/librenms/librenms/pull/1300))
  - Added support for specifying MySQL port number in config.php ([PR1302](https://github.com/librenms/librenms/pull/1302))
  - Updated alert subject to use rule name not ID ([PR1310](https://github.com/librenms/librenms/pull/1310))
  - Added macro %macros.sensor ([PR1311](https://github.com/librenms/librenms/pull/1311))
  - Added WebUI support for Pushover ([PR1313](https://github.com/librenms/librenms/pull/1313))
  - Updated path check for Oxidized config ([PR1316](https://github.com/librenms/librenms/pull/1316))
  - Added Multimatic UPS to rfc1628 detection ([PR1317](https://github.com/librenms/librenms/pull/1317))
  - Added timeout for Unix agent ([PR1319](https://github.com/librenms/librenms/pull/1319))
  - Added support for a poller to use more than one poller group ([PR1323](https://github.com/librenms/librenms/pull/1323))
  - Added ability to use Plugins on device overview page ([PR1325](https://github.com/librenms/librenms/pull/1325))
  - Added latency loss/avg/max/min results to DB and Graph ([PR1326](https://github.com/librenms/librenms/pull/1326))
  - Added recording of device down (snmp/icmp) ([PR1326](https://github.com/librenms/librenms/pull/1326))
  - Added debugging output for when invalid SNMPv3 options used ([PR1331](https://github.com/librenms/librenms/pull/1331))
  - Added load and state output to device overview page ([PR1333](https://github.com/librenms/librenms/pull/1333))
  - Added load sensors to RFC1628 Devices ([PR1336](https://github.com/librenms/librenms/pull/1336))
  - Added support for WebPower Pro II UPS Cards ([PR1338](https://github.com/librenms/librenms/pull/1338))
  - No longer rewrite server-status in .htaccess ([PR1339](https://github.com/librenms/librenms/pull/1339))
  - Added docs for setting up Service extensions ([PR1354](https://github.com/librenms/librenms/pull/1354))
  - Added additional info from pfsense devices ([PR1356](https://github.com/librenms/librenms/pull/1356))

### May 2015

#### Bug fixes
  - Updated nested addHosts to use variables passed ([PR889](https://github.com/librenms/librenms/pull/889))
  - Fixed map drawing issue ([PR907](https://github.com/librenms/librenms/pull/907))
  - Fixed sensors issue where APC load sensors overwrote current ([PR912](https://github.com/librenms/librenms/pull/912))
  - Fixed devices location filtering ([PR917](https://github.com/librenms/librenms/pull/917), [PR921](https://github.com/librenms/librenms/pull/921))
  - Minor fix to rrdcached_dir handling ([PR940](https://github.com/librenms/librenms/pull/940))
  - Now set defaults for AddHost on XDP discovery ([PR941](https://github.com/librenms/librenms/pull/941))
  - Fix web installer to generate config correctly if possible ([PR954](https://github.com/librenms/librenms/pull/954))
  - Fix inverse option for graphs ([PR955](https://github.com/librenms/librenms/pull/955))
  - Fix ifAlias parsing ([PR960](https://github.com/librenms/librenms/pull/960))
  - Rewrote rrdtool_escape to fix graph formatting issues ([PR961](https://github.com/librenms/librenms/pull/961), [PR965](https://github.com/librenms/librenms/pull/965))
  - Updated ports check to include ifAdminStatus ([PR962](https://github.com/librenms/librenms/pull/962))
  - Fixed custom sensors high / low being overwritten on discovery ([PR977](https://github.com/librenms/librenms/pull/977))
  - Fixed APC powerbar phase limit discovery ([PR981](https://github.com/librenms/librenms/pull/981))
  - Fix for 4 digit cpu% for Datacom ([PR984](https://github.com/librenms/librenms/pull/984))
  - Fix SQL query for restricted users in /devices/ ([PR990](https://github.com/librenms/librenms/pull/990))
  - Fix for post-formatting time-macros ([PR1006](https://github.com/librenms/librenms/pull/1006))
  - Honour disabling alerts for hosts ([PR1051](https://github.com/librenms/librenms/pull/1051))
  - Make OSPF and ARP discovery independent xDP ([PR1053](https://github.com/librenms/librenms/pull/1053))
  - Fixed ospf_nbrs lookup to use device_id ([PR1088](https://github.com/librenms/librenms/pull/1088))
  - Removed trailing / from some urls ([PR1089](https://github.com/librenms/librenms/pull/1089) / [PR1100](https://github.com/librenms/librenms/pull/1100))
  - Fix to device search for Device type and location ([PR1101](https://github.com/librenms/librenms/pull/1101))
  - Stop non-device boxes on overview appearing when device is down ([PR1106](https://github.com/librenms/librenms/pull/1106))
  - Fixed nfsen directory checks ([PR1123](https://github.com/librenms/librenms/pull/1123))
  - Removed lower limit for sensor graphs so negative values show ([PR1124](https://github.com/librenms/librenms/pull/1124))
  - Added fallback for poller_group if empty when adding devices ([PR1126](https://github.com/librenms/librenms/pull/1126))
  - Fixed processor graphs tooltips ([PR1127](https://github.com/librenms/librenms/pull/1127))
  - Fixed /poll-log/ count ([PR1130](https://github.com/librenms/librenms/pull/1130))
  - Fixed ARP search graph type reference ([PR1131](https://github.com/librenms/librenms/pull/1131))
  - Fixed showing state=X in device list ([PR1144](https://github.com/librenms/librenms/pull/1144))
  - Removed ability for demo user to delete users ([PR1151](https://github.com/librenms/librenms/pull/1151))
  - Fixed user / port perms for top X front page boxes ([PR1156](https://github.com/librenms/librenms/pull/1156))
  - Fixed truncating UTF-8 strings ([PR1166](https://github.com/librenms/librenms/pull/1166))
  - Fixed attaching templates due to JS issue ([PR1167](https://github.com/librenms/librenms/pull/1167))

#### Improvements
  - Added loading bar to top nav ([PR893](https://github.com/librenms/librenms/pull/893))
  - Added load and current for APC units ([PR888](https://github.com/librenms/librenms/pull/888))
  - Improved web installer ([PR887](https://github.com/librenms/librenms/pull/887))
  - Updated alerts status box ([PR875](https://github.com/librenms/librenms/pull/875))
  - Updated syslog page ([PR862](https://github.com/librenms/librenms/pull/862))
  - Added temperature polling for IBM Flexsystem ([PR894](https://github.com/librenms/librenms/pull/894))
  - Updated typeahead libraries and relevant forms ([PR882](https://github.com/librenms/librenms/pull/882))
  - Added docs showing configuration options and how to use them ([PR910](https://github.com/librenms/librenms/pull/910))
  - Added docs on discovery / poller and how to debug ([PR911](https://github.com/librenms/librenms/pull/911))
  - Updated docs for MySQL / Nginx / Bind use in Unix agent ([PR916](https://github.com/librenms/librenms/pull/916))
  - Update development docs ([PR919](https://github.com/librenms/librenms/pull/919))
  - Updated install docs to advise about whitespace in config.php ([PR920](https://github.com/librenms/librenms/pull/920))
  - Added docs on authentication modules ([PR922](https://github.com/librenms/librenms/pull/922))
  - Added support for Oxidized config archival ([PR927](https://github.com/librenms/librenms/pull/927))
  - Added API to feed devices to Oxidized ([PR928](https://github.com/librenms/librenms/pull/928))
  - Added support for per OS bad_iftype, bad_if and bad_if_regexp ([PR930](https://github.com/librenms/librenms/pull/930))
  - Enable alerting on tables with relative / indirect glues ([PR932](https://github.com/librenms/librenms/pull/932))
  - Added bills support in rulesuggest and alert system ([PR934](https://github.com/librenms/librenms/pull/934))
  - Added detection for Sentry Smart CDU ([PR938](https://github.com/librenms/librenms/pull/938))
  - Added basic detection for Netgear devices ([PR942](https://github.com/librenms/librenms/pull/942))
  - addhost.php now uses distributed_poller_group config if set ([PR944](https://github.com/librenms/librenms/pull/944))
  - Added port rewrite function ([PR946](https://github.com/librenms/librenms/pull/946))
  - Added basic detection for Ubiquiti Edgeswitch ([PR947](https://github.com/librenms/librenms/pull/947))
  - Added support for retrieving email address from LDAP ([PR949](https://github.com/librenms/librenms/pull/949))
  - Updated JunOS logo ([PR952](https://github.com/librenms/librenms/pull/952))
  - Add aggregates on multi_bits_separate graphs ([PR956](https://github.com/librenms/librenms/pull/956))
  - Fix port name issue for recent snmp versions on Linux ([PR957](https://github.com/librenms/librenms/pull/957))
  - Added support for quick access to devices via url ([PR958](https://github.com/librenms/librenms/pull/958))
  - Added work around for PHP creating zombie processes on certain distros ([PR959](https://github.com/librenms/librenms/pull/959))
  - Added detection support for NetApp + disks + temperature ([PR967](https://github.com/librenms/librenms/pull/967), [PR971](https://github.com/librenms/librenms/pull/971))
  - Define defaults for graphs ([PR968](https://github.com/librenms/librenms/pull/968))
  - Added docs for migrating from Observium ([PR974](https://github.com/librenms/librenms/pull/974))
  - Added iLo temperature support ([PR982](https://github.com/librenms/librenms/pull/982))
  - Added disk temperature for Synology DSM ([PR986](https://github.com/librenms/librenms/pull/986))
  - Added ICMP, TLS/SSL and Domain expiry service checks ([PR987](https://github.com/librenms/librenms/pull/987), [PR1040](https://github.com/librenms/librenms/pull/1040), [PR1041](https://github.com/librenms/librenms/pull/1041))
  - Added IPMI detection ([PR988](https://github.com/librenms/librenms/pull/988))
  - Mikrotik MIB update ([PR991](https://github.com/librenms/librenms/pull/991))
  - Set better timeperiod for caching graphs ([PR992](https://github.com/librenms/librenms/pull/992))
  - Added config option to disable port relationship in ports list ([PR996](https://github.com/librenms/librenms/pull/996))
  - Added support for custom customer description parse ([PR998](https://github.com/librenms/librenms/pull/998))
  - Added hardware and MySQL version stats to callback ([PR999](https://github.com/librenms/librenms/pull/999))
  - Added support for alerting to PagerDuty ([PR1004](https://github.com/librenms/librenms/pull/1004))
  - Now send ack notifications for alerts that are acked ([PR1008](https://github.com/librenms/librenms/pull/1008))
  - Updated contributing docs and added placeholder ([PR1024](https://github.com/librenms/librenms/pull/1024), [PR1025](https://github.com/librenms/librenms/pull/1025))
  - Updated globe.php overview page with updated map support ([PR1029](https://github.com/librenms/librenms/pull/1029))
  - Converted storage page to use Bootgrid ([PR1030](https://github.com/librenms/librenms/pull/1030))
  - Added basic FibreHome detection ([PR1031](https://github.com/librenms/librenms/pull/1031))
  - Show details of alerts in alert log ([PR1043](https://github.com/librenms/librenms/pull/1043))
  - Allow a user-defined windows to add tolerance for alerting ([PR1044](https://github.com/librenms/librenms/pull/1044))
  - Added inlet support for Raritan PX iPDU ([PR1045](https://github.com/librenms/librenms/pull/1045))
  - Updated MIBS for Cisco SB ([PR1058](https://github.com/librenms/librenms/pull/1058))
  - Added error checking for build-base on install ([PR1059](https://github.com/librenms/librenms/pull/1059))
  - Added fan and raid state for Dell OpenManage ([PR1062](https://github.com/librenms/librenms/pull/1062))
  - Updated MIBS for Ruckus ZoneDirectors ([PR1067](https://github.com/librenms/librenms/pull/1067))
  - Added check for ./rename.php ([PR1069](https://github.com/librenms/librenms/pull/1069))
  - Added install instructions to use librenms user ([PR1071](https://github.com/librenms/librenms/pull/1071))
  - Honour sysContact over riding for alerts ([PR1073](https://github.com/librenms/librenms/pull/1073))
  - Added services page for adding/deleting and editing services ([PR1076](https://github.com/librenms/librenms/pull/1076))
  - Added more support for Mikrotik devices ([PR1080](https://github.com/librenms/librenms/pull/1080))
  - Added better detection for Cisco ASA 5585-SSP40 ([PR1082](https://github.com/librenms/librenms/pull/1082))
  - Added CPU dataplane support for JunOS ([PR1086](https://github.com/librenms/librenms/pull/1086))
  - Removed requirement for hostnames on add device ([PR1087](https://github.com/librenms/librenms/pull/1087))
  - Added config option to exclude sysContact from alerts ([PR1093](https://github.com/librenms/librenms/pull/1093))
  - Added config option to regenerate contacts on alerts ([PR1109](https://github.com/librenms/librenms/pull/1109))
  - Added validation tool to help fault find issues with installs ([PR1112](https://github.com/librenms/librenms/pull/1112))
  - Added CPU support for EdgeOS ([PR1114](https://github.com/librenms/librenms/pull/1114))
  - Added ability to customise transit/peering/core descriptions ([PR1125](https://github.com/librenms/librenms/pull/1125))
  - Show ifName in ARP search if devices are set to use this ([PR1133](https://github.com/librenms/librenms/pull/1133))
  - Added FibreHome CPU and Mempool support ([PR1134](https://github.com/librenms/librenms/pull/1134))
  - Added config options for region and resolution on globe map ([PR1137](https://github.com/librenms/librenms/pull/1137))
  - Added RRDCached example docs ([PR1148](https://github.com/librenms/librenms/pull/1148))
  - Updated support for additional NetBotz models ([PR1152](https://github.com/librenms/librenms/pull/1152))
  - Updated /iftype/ page to include speed/circuit/notes ([PR1155](https://github.com/librenms/librenms/pull/1155))
  - Added detection for PowerConnect 55XX devices ([PR1165](https://github.com/librenms/librenms/pull/1165))

### Apr 2015

####Bug fixes
  - Fixed ack of worse/better alerts ([PR720](https://github.com/librenms/librenms/pull/720))
  - Fixed ORIG_PATH_INFO warnings ([PR727](https://github.com/librenms/librenms/pull/727))
  - Added missing CPU id for Cisco SB ([PR744](https://github.com/librenms/librenms/pull/744))
  - Changed Processors table name to lower case in processors discovery ([PR751](https://github.com/librenms/librenms/pull/751))
  - Fixed alerts path issue ([PR756](https://github.com/librenms/librenms/pull/756), [PR760](https://github.com/librenms/librenms/pull/760))
  - Suppress further port alerts when interface goes down ([PR745](https://github.com/librenms/librenms/pull/745))
  - Fixed login so redirects via 303 when POST data sent ([PR775](https://github.com/librenms/librenms/pull/775))
  - Fixed missing link to errored or ignored ports ([PR787](https://github.com/librenms/librenms/pull/787))
  - Updated alert log query for performance improvements ([PR783](https://github.com/librenms/librenms/pull/783))
  - Honour alert_rules.disabled field ([PR784](https://github.com/librenms/librenms/pull/784))
  - Stop page debug if user not logged in ([PR785](https://github.com/librenms/librenms/pull/785))
  - Added text filtering for new tables ([PR797](https://github.com/librenms/librenms/pull/797))
  - Fixed VMWare VM detection + hardware / serial support ([PR799](https://github.com/librenms/librenms/pull/799))
  - Fix links from /health/processor ([PR810](https://github.com/librenms/librenms/pull/810))
  - Hide divider if no plugins installed ([PR811](https://github.com/librenms/librenms/pull/811))
  - Added Nginx fix for using debug option ([PR823](https://github.com/librenms/librenms/pull/823))
  - Bug fixes for device groups SQL ([PR840](https://github.com/librenms/librenms/pull/840))
  - Fixed path issue when using rrdcached ([PR839](https://github.com/librenms/librenms/pull/839))
  - Fixed JS issues when deleting alert maps / poller groups / device groups ([PR846](https://github.com/librenms/librenms/pull/846),[PR848](https://github.com/librenms/librenms/pull/848),[PR877](https://github.com/librenms/librenms/pull/877))
  - Fixed links and popover for /health/metric=storage/ ([PR847](https://github.com/librenms/librenms/pull/847))
  - Fixed lots of user permission issues ([PR855](https://github.com/librenms/librenms/pull/855))
  - Fixed search ip / arp / mac pages ([PR845](https://github.com/librenms/librenms/pull/845))
  - Added missing charge icon ([PR878](https://github.com/librenms/librenms/pull/878))

####Improvements
  - New theme support added (light,dark and mono) ([PR682](https://github.com/librenms/librenms/pull/682),[PR683](https://github.com/librenms/librenms/pull/683),[PR701](https://github.com/librenms/librenms/pull/701))
  - Tables being converted to Jquery Bootgrid ([PR693](https://github.com/librenms/librenms/pull/693),[PR706](https://github.com/librenms/librenms/pull/706),[PR716](https://github.com/librenms/librenms/pull/716))
  - Detect Cisco ASA Hardware and OS Version ([PR708](https://github.com/librenms/librenms/pull/708))
  - Update LDAP support ([PR707](https://github.com/librenms/librenms/pull/707))
  - Updated APC powernet MIB ([PR713](https://github.com/librenms/librenms/pull/713))
  - Update to Foritgate support ([PR709](https://github.com/librenms/librenms/pull/709))
  - Added support for UBNT AirOS and AirFibre ([PR721](https://github.com/librenms/librenms/pull/721),[PR730](https://github.com/librenms/librenms/pull/730),[PR731](https://github.com/librenms/librenms/pull/731))
  - Added support device groups + alerts to be mapped to devices or groups ([PR722](https://github.com/librenms/librenms/pull/722))
  - Added basic Cambium support ([PR738](https://github.com/librenms/librenms/pull/738))
  - Added basic F5 support ([PR670](https://github.com/librenms/librenms/pull/670))
  - Shorten interface names on map ([PR752](https://github.com/librenms/librenms/pull/752))
  - Added PowerCode support ([PR762](https://github.com/librenms/librenms/pull/762))
  - Added Autodiscovery via OSPF ([PR772](https://github.com/librenms/librenms/pull/772))
  - Added visual graph of alert log ([PR777](https://github.com/librenms/librenms/pull/777), [PR809](https://github.com/librenms/librenms/pull/809))
  - Added Callback system to send anonymous stats ([PR768](https://github.com/librenms/librenms/pull/768))
  - More tables converted to use bootgrid ([PR729](https://github.com/librenms/librenms/pull/729), [PR761](https://github.com/librenms/librenms/pull/761))
  - New Global Cache to store common queries added ([PR780](https://github.com/librenms/librenms/pull/780))
  - Added proxy support for submitting stats ([PR791](https://github.com/librenms/librenms/pull/791))
  - Minor APC Polling change ([PR800](https://github.com/librenms/librenms/pull/800))
  - Updated to HP switch detection ([PR802](https://github.com/librenms/librenms/pull/802))
  - Added Datacom basic detection ([PR816](https://github.com/librenms/librenms/pull/816))
  - Updated Cisco detection ([PR815](https://github.com/librenms/librenms/pull/815))
  - Added CSV export system + ability to export ports ([PR818](https://github.com/librenms/librenms/pull/818))
  - Added basic detection for PacketLogic devices ([PR773](https://github.com/librenms/librenms/pull/773))
  - Added fallback support for IBM switches for Serial / Version ([PR822](https://github.com/librenms/librenms/pull/822))
  - Added Juniper Inventory support ([PR825](https://github.com/librenms/librenms/pull/825))
  - Sharpen graphs produced ([PR826](https://github.com/librenms/librenms/pull/826))
  - Updated map to show device overview graphs and port graphs ([PR826](https://github.com/librenms/librenms/pull/826))
  - Added hostname to API call for list_alerts ([PR834](https://github.com/librenms/librenms/pull/834))
  - Added ability to schedule maintenance ([PR835](https://github.com/librenms/librenms/pull/835),[PR841](https://github.com/librenms/librenms/pull/841))
  - Added ability to expand alert triggers for more details ([PR857](https://github.com/librenms/librenms/pull/857))
  - Added support for XTM/FBX Watchguard devices ([PR849](https://github.com/librenms/librenms/pull/849))
  - Updated Juniper MIBS and hardware rewrite ([PR838](https://github.com/librenms/librenms/pull/838))
  - Updated OpenBSD detection ([PR860](https://github.com/librenms/librenms/pull/860))
  - Added Macro support for alerting system ([PR863](https://github.com/librenms/librenms/pull/863))
  - Added support for tcp connections on rrdcached ([PR866](https://github.com/librenms/librenms/pull/866))
  - Added config option to enable / disable mouseover graphs ([PR873](https://github.com/librenms/librenms/pull/873))
  - General cleanup of files / folders permissions ([PR874](https://github.com/librenms/librenms/pull/874))
  - Added window size detection for map ([PR884](https://github.com/librenms/librenms/pull/884))
  - Added text to let users know refresh is disabled ([PR883](https://github.com/librenms/librenms/pull/883))

### Mar 2015

####Bug fixes
  - Updates to alert rules split ([PR550](https://github.com/librenms/librenms/pull/550))
  - Updated get_graphs() for API to resolve graph names ([PR613](https://github.com/librenms/librenms/pull/613))
  - Fixed use of REMOTE_ADDR to use X_FORWARDED_FOR if available ([PR620](https://github.com/librenms/librenms/pull/620))
  - Added yocto support from entPhySensorScale ([PR632](https://github.com/librenms/librenms/pull/632))
  - Eventlog search fixed ([PR644](https://github.com/librenms/librenms/pull/644))
  - Added missing OS discovery to default list ([PR660](https://github.com/librenms/librenms/pull/660))
  - Fixed logging issue when description of a port was removed ([PR673](https://github.com/librenms/librenms/pull/673))
  - Fixed logging issue when ports changed status ([PR675](https://github.com/librenms/librenms/pull/675))
  - Shortened interface names for graph display ([PR676](https://github.com/librenms/librenms/pull/676))

####Improvements
  - Visual updates to alert logs ([PR541](https://github.com/librenms/librenms/pull/541))
  - Added temperature support for APC AC units ([PR545](https://github.com/librenms/librenms/pull/545))
  - Added ability to pause and resume page refresh ([PR557](https://github.com/librenms/librenms/pull/557))
  - Added polling support for NXOS ([PR562](https://github.com/librenms/librenms/pull/562))
  - Added discovery support for 3Com switches ([PR568](https://github.com/librenms/librenms/pull/568))
  - Updated Comware support ([PR583](https://github.com/librenms/librenms/pull/583))
  - Added new logo ([PR584](https://github.com/librenms/librenms/pull/584))
  - Added dynamic removal of device data when removing device ([PR592](https://github.com/librenms/librenms/pull/592))
  - Updated alerting to use fifo ([PR607](https://github.com/librenms/librenms/pull/607))
  - Added distributed poller support ([PR609](https://github.com/librenms/librenms/pull/609) and [PR610](https://github.com/librenms/librenms/pull/610))
  - Added PowerConnect 55xx ([PR635](https://github.com/librenms/librenms/pull/635))
  - Added inventory API endpoint ([PR640](https://github.com/librenms/librenms/pull/640))
  - Added serial number detection for ASA firewalls ([PR642](https://github.com/librenms/librenms/pull/642))
  - Added missing MKTree library for inventory support ([PR646](https://github.com/librenms/librenms/pull/646))
  - Added support for exporting Alert logs to PDF ([PR653](https://github.com/librenms/librenms/pull/653))
  - Added basic Ubiquiti support ([PR659](https://github.com/librenms/librenms/pull/659))
  - Numerous docs update ([PR662](https://github.com/librenms/librenms/pull/662), [PR663](https://github.com/librenms/librenms/pull/663), [PR677](https://github.com/librenms/librenms/pull/677), [PR694](https://github.com/librenms/librenms/pull/694))
  - Added Polling information page ([PR664](https://github.com/librenms/librenms/pull/664))
  - Added HipChat notification support ([PR669](https://github.com/librenms/librenms/pull/669))
  - Implemented Jquery Bootgrid support ([PR671](https://github.com/librenms/librenms/pull/671))
  - Added new map to show xDP discovered links and devices ([PR679](https://github.com/librenms/librenms/pull/679) + [PR680](https://github.com/librenms/librenms/pull/680))

###Feb 2015

####Bug fixes
 - Removed header redirect causing page load delays ([PR436](https://github.com/librenms/librenms/pull/436))
 - Fixed stale alerting data ([PR475](https://github.com/librenms/librenms/pull/475))
 - Fixed api call for port stats to use device_id / hostname ([PR478](https://github.com/librenms/librenms/pull/478))
 - Work started on ensuring MySQL strict mode is supported ([PR521](https://github.com/librenms/librenms/pull/521))

####Improvements
 - Added support for Cisco Wireless Controllers ([PR422](https://github.com/librenms/librenms/pull/422))
 - Updated IRC Bot to support alerting system ([PR434](https://github.com/librenms/librenms/pull/434))
 - Added new message box to alert when a device hasn't polled for 15 minutes or more ([PR435](https://github.com/librenms/librenms/pull/435))
 - Added quick links on device list page to quickly access common pages ([PR440](https://github.com/librenms/librenms/pull/440))
 - Alerting docs updated to cover new features ([PR446](https://github.com/librenms/librenms/pull/446))
 - IBM NOS Support added ([PR454](https://github.com/librenms/librenms/pull/454))
 - Added basic Barracuda Loadbalancer support ([PR456](https://github.com/librenms/librenms/pull/456))
 - Small change to the search results to add port desc / alias ([PR457](https://github.com/librenms/librenms/pull/457))
 - Added Device sub menu to access devices category directly ([PR465](https://github.com/librenms/librenms/pull/465))
 - Added basic Ruckus Wireless support ([PR466](https://github.com/librenms/librenms/pull/466))
 - Added support for a demo user ([PR471](https://github.com/librenms/librenms/pull/471))
 - Many small visual updates
 - Added additional support for Cisco SB devices ([PR487](https://github.com/librenms/librenms/pull/487))
 - Added support to default home page for printing alerts ([PR488](https://github.com/librenms/librenms/pull/488))
 - Tidied up Alert menubar into sub menu ([PR489](https://github.com/librenms/librenms/pull/489))
 - Added historical alerts page ([PR495](https://github.com/librenms/librenms/pull/495))
 - Added battery charge monitoring for ([PR519](https://github.com/librenms/librenms/pull/519))
 - Added Slack support for alert system ([PR525](https://github.com/librenms/librenms/pull/525))
 - Added new debug for php / sql option to page footer ([PR484](https://github.com/librenms/librenms/pull/484))

###Jan 2015

####Bug fixes
 - Reverted chmod to make poller.php executable again ([PR394](https://github.com/librenms/librenms/pull/394))
 - Fixed duplicate port listing ([PR396](https://github.com/librenms/librenms/pull/396))
 - Fixed create bill from port page ([PR404](https://github.com/librenms/librenms/pull/404))
 - Fixed autodiscovery to use $config['mydomain'] correctly ([PR423](https://github.com/librenms/librenms/pull/423))
 - Fixed mute bug for alerts ([PR428](https://github.com/librenms/librenms/pull/428))

####Improvements
 - Updated login page visually ([PR391](https://github.com/librenms/librenms/pull/391))
 - Added Hikvision support ([PR393](https://github.com/librenms/librenms/pull/393))
 - Added ability to search for packages using unix agent ([PR395](https://github.com/librenms/librenms/pull/395))
 - Updated ifAlias support for varying distributions ([PR398](https://github.com/librenms/librenms/pull/398))
 - Updated visually Global Settings page ([PR401](https://github.com/librenms/librenms/pull/401))
 - Added missing default nginx graphs ([PR403](https://github.com/librenms/librenms/pull/403))
 - Updated check_mk_agent to latest git version ([PR409](https://github.com/librenms/librenms/pull/409))
 - Added support for recording process list with unix agent ([PR410](https://github.com/librenms/librenms/pull/410))
 - Added support for named/bind9/TinyDNS application using unix agent ([PR413](https://github.com/librenms/librenms/pull/413), [PR416](https://github.com/librenms/librenms/pull/416))
 - About page tidied up ([PR414](https://github.com/librenms/librenms/pull/414), [PR425](https://github.com/librenms/librenms/pull/425))
 - Updated progress bars to use bootstrap ([PR42](https://github.com/librenms/librenms/pull/42))
 - Updated install docs to cover CentOS7 ([PR424](https://github.com/librenms/librenms/pull/424))
 - Alerting system updated with more features ([PR429](https://github.com/librenms/librenms/pull/429), [PR430](https://github.com/librenms/librenms/pull/430))
