/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.java.hints.jdk.CheckRegexTopComponent;
import org.netbeans.modules.java.hints.regex.parser.ExampleGenerator;
import org.netbeans.modules.java.hints.regex.parser.RegExParser;
import org.netbeans.modules.java.hints.regex.parser.RegexConstructs;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class RegexExampleGeneratorPanel
extends JPanel {
    private final String expression;
    private JTextArea exampleTextArea;
    private JLabel expressionLabel;
    private JTextField numberField;
    private JButton regenerateButton;

    public RegexExampleGeneratorPanel() {
        this.initComponents();
        this.expression = CheckRegexTopComponent.findInstance().getExpression();
        this.expressionLabel.setText(this.expression);
        this.exampleTextArea.setText(this.getExamples());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.REGEX_EXAMPLES");
    }

    private void initComponents() {
        JLabel regExLabel = new JLabel();
        JScrollPane exampleScrollPane = new JScrollPane();
        this.exampleTextArea = new JTextArea();
        this.expressionLabel = new JLabel();
        this.numberField = new JTextField();
        JLabel NoLabel = new JLabel();
        this.regenerateButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)regExLabel, (String)NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.regExLabel.text"));
        this.exampleTextArea.setColumns(20);
        this.exampleTextArea.setRows(5);
        exampleScrollPane.setViewportView(this.exampleTextArea);
        this.numberField.setText(NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.numberField.text"));
        Mnemonics.setLocalizedText((JLabel)NoLabel, (String)NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.NoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.regenerateButton, (String)NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.regenerateButton.text"));
        this.regenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexExampleGeneratorPanel.this.regenerateButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(exampleScrollPane, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(regExLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expressionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(NoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberField, -2, 42, -2)).addGroup(layout.createSequentialGroup().addComponent(this.regenerateButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(regExLabel).addComponent(this.expressionLabel).addComponent(this.numberField, -2, -1, -2).addComponent(NoLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(exampleScrollPane, -1, 203, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regenerateButton).addContainerGap()));
    }

    private void regenerateButtonActionPerformed(ActionEvent evt) {
        this.exampleTextArea.setText(this.getExamples());
    }

    private String getExamples() {
        int noFieldVal;
        RegExParser r = new RegExParser(this.expression);
        RegexConstructs.RegEx p = r.parse();
        ExampleGenerator eg = new ExampleGenerator(p);
        try {
            noFieldVal = Integer.parseInt(this.numberField.getText());
        }
        catch (NumberFormatException e) {
            return NbBundle.getMessage(RegexExampleGeneratorPanel.class, (String)"RegexExampleGeneratorPanel.exampleTextArea.invalidText");
        }
        ArrayList<String> generate = eg.generate(noFieldVal);
        StringBuilder sb = new StringBuilder();
        generate.forEach(example -> sb.append((String)example).append("\n"));
        return sb.toString();
    }
}

