/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.expression;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.expression.Bundle;
import org.netbeans.modules.micronaut.expression.EvaluationContext;
import org.netbeans.modules.micronaut.expression.ExpressionTree;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageParser;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautExpressionLanguageUtilities {
    private static final Pattern LINK_PATTERN = Pattern.compile("<a href='(\\*\\d+)'>(.*?)<\\/a>", 10);

    public static <T> T resolve(Document doc, final int offset, final BiFunction<CompilationInfo, Element, T> withElement, final BiFunction<ConfigurationMetadataProperty, ConfigurationMetadataSource, T> withProperty) {
        final AtomicReference ret = new AtomicReference();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                    if (cc != null) {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = cc.getTreeUtilities().pathFor(offset);
                        if (treePath.getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
                            int off = offset - (int)cc.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), treePath.getLeaf()) - 1;
                            Matcher matcher = MicronautExpressionLanguageParser.MEXP_PATTERN.matcher((String)((LiteralTree)treePath.getLeaf()).getValue());
                            while (matcher.find() && matcher.groupCount() == 1) {
                                Project project;
                                MicronautExpressionLanguageParser parser;
                                ExpressionTree tree;
                                ExpressionTree.Path path;
                                if (off < matcher.start(1) || off > matcher.end(1) || (path = ExpressionTree.Path.get(tree = (parser = new MicronautExpressionLanguageParser(matcher.group(1))).parse(), off - matcher.start(1))) == null) continue;
                                Element el = path.getLeaf().getElement(EvaluationContext.get((CompilationInfo)cc, treePath));
                                if (el != null) {
                                    ret.set(withElement.apply(cc, el));
                                    continue;
                                }
                                if (path.getLeaf().getKind() != ExpressionTree.Kind.STRING_LITERAL || path.getParentPath() == null || path.getParentPath().getLeaf().getKind() != ExpressionTree.Kind.ENVIRONMENT_ACCESS || (project = FileOwnerQuery.getOwner((FileObject)cc.getFileObject())) == null) continue;
                                String propertyName = (String)((ExpressionTree.Literal)path.getLeaf()).getValue();
                                ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
                                ConfigurationMetadataProperty property = MicronautConfigUtilities.getProperty(MicronautConfigProperties.getGroups(project), propertyName, sources);
                                if (property == null) continue;
                                Optional<ConfigurationMetadataSource> source = sources.stream().filter(s -> s.getProperties().get(property.getId()) == property).findFirst();
                                ret.set(withProperty.apply(property, source.orElse(null)));
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException pe) {
            Exceptions.printStackTrace((Throwable)pe);
        }
        return (T)ret.get();
    }

    public static String getJavadocText(CompilationInfo info, Element e, boolean shorten, int timeoutInSeconds) {
        String text = null;
        try {
            AtomicBoolean cancel = new AtomicBoolean();
            ElementJavadoc javadoc = ElementJavadoc.create((CompilationInfo)info, (Element)e, () -> cancel.get());
            javadoc.getTextAsync();
            String string = text = javadoc.getTextAsync() != null ? (String)javadoc.getTextAsync().get(timeoutInSeconds, TimeUnit.SECONDS) : null;
            if (text != null) {
                int idx;
                text = MicronautExpressionLanguageUtilities.resolveLinks(text, javadoc);
                if (shorten) {
                    idx = 0;
                    for (int i = 0; i < 3 && idx >= 0; ++i) {
                        idx = text.indexOf("<p>", idx + 1);
                    }
                    if (idx >= 0) {
                        text = text.substring(0, idx + 3);
                        text = text + Bundle.LBL_More();
                    }
                }
                if ((idx = text.indexOf("<p id=\"not-found\">")) >= 0) {
                    text = text.substring(0, idx);
                }
            }
            cancel.set(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    private static String resolveLinks(String content, ElementJavadoc doc) {
        Matcher matcher = LINK_PATTERN.matcher(content);
        String updatedContent = matcher.replaceAll(result -> {
            if (result.groupCount() == 2) {
                try {
                    URL url;
                    ElementJavadoc link = doc.resolveLink(result.group(1));
                    URL uRL = url = link != null ? link.getURL() : null;
                    if (url != null) {
                        return "<a href='" + url.toString() + "'>" + result.group(2) + "</a>";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result.group(2);
            }
            return result.group();
        });
        return updatedContent;
    }
}

