/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.CaseElementImpl;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.EnumScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IncludeElementImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TraitScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.CaseDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassInstanceCreationInfo;
import org.netbeans.modules.php.editor.model.nodes.EnumDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.IncludeInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.NamespaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;

class ModelBuilder {
    private final FileScopeImpl fileScope;
    private final NamespaceScopeImpl defaultNamespaceScope;
    private final Object currentScopeLock = new Object();
    private final ArrayDeque<ScopeImpl> currentScope;
    private final Map<VariableNameFactory, Map<String, VariableNameImpl>> vars;
    private NamespaceScopeImpl namespaceScope;
    private Program program;

    ModelBuilder(FileScopeImpl fileScope) {
        this.fileScope = fileScope;
        this.currentScope = new ArrayDeque();
        this.vars = new HashMap<VariableNameFactory, Map<String, VariableNameImpl>>();
        this.setCurrentScope(fileScope);
        this.namespaceScope = this.defaultNamespaceScope = new NamespaceScopeImpl(fileScope);
        this.setCurrentScope(this.namespaceScope);
    }

    NamespaceScope build(NamespaceDeclaration node, OccurenceBuilder occurencesBuilder) {
        NamespaceDeclarationInfo info = NamespaceDeclarationInfo.create(node);
        NamespaceScopeImpl nScope = ModelElementFactory.create(info, this);
        if (!nScope.isDefaultNamespace()) {
            this.setCurrentScope(nScope);
        }
        return nScope;
    }

    ClassScope build(ClassDeclaration node, OccurenceBuilder occurencesBuilder) {
        ClassScopeImpl classScope = ModelElementFactory.create(ClassDeclarationInfo.create(node), this);
        this.setCurrentScope(classScope);
        occurencesBuilder.prepare(node, classScope);
        return classScope;
    }

    ClassScope build(ClassInstanceCreation node, OccurenceBuilder occurencesBuilder) {
        assert (node.isAnonymous()) : node;
        ClassScopeImpl classScope = ModelElementFactory.create(ClassInstanceCreationInfo.create(node), this);
        this.setCurrentScope(classScope);
        occurencesBuilder.prepare(node, (Scope)classScope);
        return classScope;
    }

    TraitScope build(TraitDeclaration node, OccurenceBuilder occurencesBuilder) {
        TraitScopeImpl traitScope = ModelElementFactory.create(TraitDeclarationInfo.create(node), this);
        this.setCurrentScope(traitScope);
        occurencesBuilder.prepare(node, traitScope);
        return traitScope;
    }

    EnumScope build(EnumDeclaration node, OccurenceBuilder occurencesBuilder) {
        EnumScopeImpl enumScope = ModelElementFactory.create(EnumDeclarationInfo.create(node), this);
        this.setCurrentScope(enumScope);
        occurencesBuilder.prepare(node, enumScope);
        return enumScope;
    }

    void build(CaseDeclaration node, OccurenceBuilder occurencesBuilder) {
        CaseDeclarationInfo info = CaseDeclarationInfo.create(node);
        occurencesBuilder.prepare(info, ModelElementFactory.create(info, this));
    }

    void build(FieldsDeclaration node, OccurenceBuilder occurencesBuilder) {
        List<? extends SingleFieldDeclarationInfo> infos = SingleFieldDeclarationInfo.create(node);
        for (SingleFieldDeclarationInfo singleFieldDeclarationInfo : infos) {
            FieldElementImpl fei = ModelElementFactory.create(singleFieldDeclarationInfo, this);
            occurencesBuilder.prepare(singleFieldDeclarationInfo, fei);
        }
    }

    void build(ConstantDeclaration node, OccurenceBuilder occurencesBuilder) {
        List<? extends ClassConstantDeclarationInfo> infos = ClassConstantDeclarationInfo.create(node);
        for (ClassConstantDeclarationInfo classConstantDeclarationInfo : infos) {
            occurencesBuilder.prepare(classConstantDeclarationInfo, ModelElementFactory.create(classConstantDeclarationInfo, this));
        }
    }

    void build(Include node, OccurenceBuilder occurencesBuilder) {
        IncludeElementImpl inclImpl = ModelElementFactory.create(IncludeInfo.create(node), this);
        occurencesBuilder.prepare(node, inclImpl);
    }

    InterfaceScope build(InterfaceDeclaration node, OccurenceBuilder occurencesBuilder) {
        InterfaceScopeImpl classScope = ModelElementFactory.create(InterfaceDeclarationInfo.create(node), this);
        this.setCurrentScope(classScope);
        occurencesBuilder.prepare(node, classScope);
        return classScope;
    }

    void buildMagicMethod(PHPDocMethodTag node, OccurenceBuilder occurencesBuilder) {
        MagicMethodDeclarationInfo info = MagicMethodDeclarationInfo.create(node);
        if (info != null) {
            MethodScopeImpl methodScope = ModelElementFactory.create(info, this);
            occurencesBuilder.prepare(info, (MethodScope)methodScope);
        }
    }

    MethodScope build(MethodDeclaration node, OccurenceBuilder occurencesBuilder, ModelVisitor visitor) {
        ScopeImpl scope = this.getCurrentScope();
        MethodScopeImpl methodScope = ModelElementFactory.create(MethodDeclarationInfo.create(this.getProgram(), node, (TypeScope)((Object)scope)), this, visitor);
        this.setCurrentScope(methodScope);
        occurencesBuilder.prepare(node, (MethodScope)methodScope);
        return methodScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.currentScopeLock;
        synchronized (object) {
            if (!this.currentScope.isEmpty()) {
                ScopeImpl createdScope = this.currentScope.peek();
                if (createdScope instanceof NamespaceScopeImpl) {
                    this.namespaceScope = this.defaultNamespaceScope;
                    if (!((NamespaceScopeImpl)createdScope).isDefaultNamespace()) {
                        this.currentScope.pop();
                    }
                } else {
                    this.currentScope.pop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForScope(Scope scope) {
        Object object = this.currentScopeLock;
        synchronized (object) {
            this.currentScope.clear();
        }
        while (scope != null) {
            if (scope instanceof NamespaceScopeImpl) {
                this.namespaceScope = (NamespaceScopeImpl)scope;
            }
            object = this.currentScopeLock;
            synchronized (object) {
                this.currentScope.addLast((ScopeImpl)scope);
            }
            scope = scope.getInScope();
        }
    }

    FileScopeImpl getFileScope() {
        return this.fileScope;
    }

    NamespaceScopeImpl getCurrentNameSpace() {
        return this.namespaceScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScopeImpl getCurrentScope() {
        Object object = this.currentScopeLock;
        synchronized (object) {
            return this.currentScope.isEmpty() ? null : this.currentScope.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCurrentScope(ScopeImpl scope) {
        if (scope instanceof NamespaceScopeImpl) {
            this.namespaceScope = (NamespaceScopeImpl)scope;
        }
        Object object = this.currentScopeLock;
        synchronized (object) {
            this.currentScope.push(scope);
        }
    }

    Program getProgram() {
        assert (this.program != null);
        return this.program;
    }

    void setProgram(Program program) {
        this.program = program;
        this.defaultNamespaceScope.setBlockRange(program);
    }

    Map<VariableNameFactory, Map<String, VariableNameImpl>> getVars() {
        return this.vars;
    }

    private static final class ModelElementFactory {
        private ModelElementFactory() {
        }

        static NamespaceScopeImpl create(NamespaceDeclarationInfo nodeInfo, ModelBuilder context) {
            NamespaceScopeImpl namespaceScope = new NamespaceScopeImpl(context.getFileScope(), nodeInfo);
            return namespaceScope;
        }

        static IncludeElementImpl create(IncludeInfo info, ModelBuilder context) {
            return new IncludeElementImpl(context.getCurrentScope(), info);
        }

        static ClassScopeImpl create(ClassDeclarationInfo nodeInfo, ModelBuilder context) {
            Scope currentScope = context.getCurrentScope();
            if (currentScope == null) {
                currentScope = context.getCurrentNameSpace();
            }
            if (currentScope instanceof FunctionScope) {
                currentScope = currentScope.getInScope();
            }
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            ClassScopeImpl clz = new ClassScopeImpl(currentScope, nodeInfo, isDeprecated);
            return clz;
        }

        static ClassScopeImpl create(ClassInstanceCreationInfo nodeInfo, ModelBuilder context) {
            Scope currentScope = context.getCurrentScope();
            if (currentScope == null) {
                currentScope = context.getCurrentNameSpace();
            }
            if (currentScope instanceof FunctionScope) {
                currentScope = currentScope.getInScope();
            }
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            ClassScopeImpl clz = new ClassScopeImpl(currentScope, nodeInfo, isDeprecated);
            return clz;
        }

        static InterfaceScopeImpl create(InterfaceDeclarationInfo nodeInfo, ModelBuilder context) {
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            return new InterfaceScopeImpl((Scope)context.getCurrentScope(), nodeInfo, isDeprecated);
        }

        static TraitScopeImpl create(TraitDeclarationInfo nodeInfo, ModelBuilder context) {
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            return new TraitScopeImpl((Scope)context.getCurrentScope(), nodeInfo, isDeprecated);
        }

        static EnumScopeImpl create(EnumDeclarationInfo nodeInfo, ModelBuilder context) {
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            return new EnumScopeImpl((Scope)context.getCurrentScope(), nodeInfo, isDeprecated);
        }

        static MethodScopeImpl create(MethodDeclarationInfo nodeInfo, ModelBuilder context, ModelVisitor visitor) {
            String returnType = VariousUtils.getReturnType(context.getProgram(), ((MethodDeclaration)nodeInfo.getOriginalNode()).getFunction());
            boolean isDeprecated = VariousUtils.isDeprecated(context.getFileScope(), context.getProgram(), nodeInfo.getOriginalNode());
            String qualifiedReturnType = VariousUtils.qualifyTypeNames(returnType, ((MethodDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), context.getCurrentScope());
            MethodScopeImpl method = new MethodScopeImpl((Scope)context.getCurrentScope(), qualifiedReturnType, nodeInfo, visitor, isDeprecated);
            return method;
        }

        static MethodScopeImpl create(MagicMethodDeclarationInfo nodeInfo, ModelBuilder context) {
            String returnType = nodeInfo.getReturnType();
            String qualifiedReturnType = VariousUtils.qualifyTypeNames(returnType, ((PHPDocMethodTag)nodeInfo.getOriginalNode()).getStartOffset(), context.getCurrentScope());
            MethodScopeImpl method = new MethodScopeImpl((Scope)context.getCurrentScope(), qualifiedReturnType, nodeInfo);
            return method;
        }

        static FieldElementImpl create(SingleFieldDeclarationInfo nodeInfo, ModelBuilder context) {
            String fieldType = nodeInfo.getFieldType();
            if (fieldType == null) {
                fieldType = VariousUtils.getFieldTypeFromPHPDoc(context.getProgram(), (SingleFieldDeclaration)nodeInfo.getOriginalNode());
            }
            boolean isDeprecated = VariousUtils.isDeprecatedFromPHPDoc(context.getProgram(), nodeInfo.getOriginalNode());
            String fieldFQType = VariousUtils.qualifyTypeNames(fieldType, nodeInfo.getRange().getStart(), context.getCurrentScope());
            FieldElementImpl fei = new FieldElementImpl((Scope)context.getCurrentScope(), fieldType, fieldFQType, nodeInfo, isDeprecated, false);
            return fei;
        }

        static ClassConstantElementImpl create(ClassConstantDeclarationInfo clsConst, ModelBuilder context) {
            boolean isDeprecated = VariousUtils.isDeprecated(context.getFileScope(), context.getProgram(), clsConst.getConstantDeclaration());
            return new ClassConstantElementImpl((Scope)context.getCurrentScope(), clsConst, isDeprecated);
        }

        static CaseElementImpl create(CaseDeclarationInfo enumCase, ModelBuilder context) {
            boolean isDeprecated = VariousUtils.isDeprecated(context.getFileScope(), context.getProgram(), enumCase.getCaseDeclaration());
            return new CaseElementImpl((Scope)context.getCurrentScope(), enumCase, isDeprecated);
        }
    }
}

