/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;

public class NamespaceIndexFilter<T extends ElementHandle> {
    private final String requestPrefix;
    private final QualifiedName prefix;
    private QualifiedNameKind kind;
    private String namespaceName;
    private String name;
    private int segmentSize;

    public NamespaceIndexFilter(String requestPrefix) {
        this.requestPrefix = requestPrefix;
        this.prefix = QualifiedName.create(requestPrefix);
    }

    public NamespaceIndexFilter(QualifiedName qname) {
        this.requestPrefix = qname.toString();
        this.prefix = qname;
    }

    public String getRequestPrefix() {
        return this.requestPrefix;
    }

    public String getNamespaceName() {
        if (this.namespaceName == null) {
            this.namespaceName = this.prefix.toNamespaceName(true).toString();
        }
        return this.namespaceName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.prefix.toString();
        }
        return this.name;
    }

    public QualifiedNameKind getKind() {
        if (this.kind == null) {
            this.kind = this.prefix.getKind();
        }
        return this.kind;
    }

    public int getSegmentSize() {
        if (this.segmentSize != -1) {
            this.segmentSize = this.prefix.getSegments().size();
        }
        return this.segmentSize;
    }

    public Collection<T> filter(Collection<T> originalElems) {
        return this.filter(originalElems, this.getName().trim().length() == 0);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<? extends ModelElement> filterModelElements(Collection<? extends ModelElement> originalElems, boolean strictCCOption) {
        if (this.getKind().isUnqualified()) {
            return originalElems;
        }
        ArrayList<ModelElement> retval = new ArrayList<ModelElement>();
        String namespaneNameLCase = this.getNamespaceName().toLowerCase();
        Object namespaneNameLCaseSlashed = namespaneNameLCase;
        if (!((String)namespaneNameLCaseSlashed).endsWith("\\")) {
            namespaneNameLCaseSlashed = (String)namespaneNameLCaseSlashed + "\\";
        }
        for (ModelElement modelElement : originalElems) {
            String elemName;
            QualifiedName nsFqn;
            void var7_7;
            Scope inScope = modelElement.getInScope();
            ModelElement originalElem = null;
            if (inScope instanceof TypeScope) {
                originalElem = modelElement;
                Scope scope = inScope;
            }
            String fqn = var7_7.getNamespaceName().append(var7_7.getName()).toFullyQualified().toString();
            int indexOf = fqn.toLowerCase().indexOf((String)namespaneNameLCaseSlashed);
            boolean fullyQualified = this.getKind().isFullyQualified();
            if (!(fullyQualified ? indexOf == 0 : indexOf != -1) || strictCCOption && (fullyQualified || this.getSegmentSize() > 1) && ((nsFqn = QualifiedName.create(fqn).toNamespaceName(true)).toString().toLowerCase().indexOf(namespaneNameLCase) == -1 || (elemName = fqn.substring(indexOf + ((String)namespaneNameLCaseSlashed).length())).indexOf("\\") != -1)) continue;
            retval.add((ModelElement)(originalElem != null ? originalElem : var7_7));
        }
        return retval;
    }

    public Collection<T> filter(Collection<T> originalElems, boolean strictCCOption) {
        if (this.getKind().isUnqualified()) {
            return originalElems;
        }
        ArrayList<ElementHandle> retval = new ArrayList<ElementHandle>();
        String namespaneNameLCase = this.getNamespaceName().toLowerCase();
        Object namespaneNameLCaseSlashed = namespaneNameLCase;
        if (!((String)namespaneNameLCaseSlashed).endsWith("\\")) {
            namespaneNameLCaseSlashed = (String)namespaneNameLCaseSlashed + "\\";
        }
        for (ElementHandle elem : originalElems) {
            if (elem instanceof FullyQualifiedElement || elem instanceof TypeMemberElement) {
                String elemName;
                QualifiedName nsFqn;
                int idx;
                if (elem instanceof TypeMemberElement && (idx = ((TypeMemberElement)elem).getType().getName().toLowerCase().indexOf(this.getName().toLowerCase())) == -1) {
                    retval.add(elem);
                    continue;
                }
                String fqn = elem instanceof FullyQualifiedElement ? ((FullyQualifiedElement)elem).getFullyQualifiedName().toString() : ((TypeMemberElement)elem).getType().getFullyQualifiedName().toString();
                int indexOf = fqn.toLowerCase().indexOf((String)namespaneNameLCaseSlashed);
                boolean fullyQualified = this.getKind().isFullyQualified();
                if (!((fullyQualified ? indexOf == 0 : indexOf != -1) && (!strictCCOption || !fullyQualified && this.getSegmentSize() <= 1 || (nsFqn = QualifiedName.create(fqn).toNamespaceName(true)).toString().toLowerCase().indexOf(namespaneNameLCase) != -1 && (elemName = fqn.substring(indexOf + ((String)namespaneNameLCaseSlashed).length())).indexOf("\\") == -1))) continue;
                retval.add(elem);
                continue;
            }
            if (!namespaneNameLCase.equals("")) continue;
            retval.add(elem);
        }
        return retval;
    }
}

