/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteLogger;
import org.netbeans.modules.db.api.sql.execute.StatementExecutionInfo;
import org.openide.util.NbBundle;

public class LogFileLogger
implements SQLExecuteLogger {
    private static final Logger LOGGER = Logger.getLogger(LogFileLogger.class.getName());
    private int errorCount;

    @Override
    public void log(StatementExecutionInfo info) {
        if (info.hasExceptions()) {
            this.logException(info);
        }
    }

    @Override
    public void finish(long executionTime) {
        LOGGER.log(Level.INFO, NbBundle.getMessage(LogFileLogger.class, (String)"LBL_ExecutionFinished", (Object)((double)executionTime / 1000.0), (Object)this.errorCount));
    }

    @Override
    public void cancel() {
        LOGGER.log(Level.INFO, NbBundle.getMessage(LogFileLogger.class, (String)"LBL_ExecutionCancelled"));
    }

    private void logException(StatementExecutionInfo info) {
        ++this.errorCount;
        for (Throwable e : info.getExceptions()) {
            if (e instanceof SQLException) {
                this.logSQLException((SQLException)e, info);
                continue;
            }
            LOGGER.log(Level.INFO, NbBundle.getMessage(LogFileLogger.class, (String)"MSG_SQLExecutionException", (Object)info.getSQL()), e);
        }
    }

    private void logSQLException(SQLException e, StatementExecutionInfo info) {
        while (e != null) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(LogFileLogger.class, (String)"MSG_SQLExecutionException", (Object)info.getSQL()), e);
            e = e.getNextException();
        }
    }
}

