/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.artifacts.model.RemoveContainerVersionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveContainerVersionRequest
extends BmcRequest<RemoveContainerVersionDetails> {
    private String imageId;
    private RemoveContainerVersionDetails removeContainerVersionDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getImageId() {
        return this.imageId;
    }

    public RemoveContainerVersionDetails getRemoveContainerVersionDetails() {
        return this.removeContainerVersionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public RemoveContainerVersionDetails getBody$() {
        return this.removeContainerVersionDetails;
    }

    public Builder toBuilder() {
        return new Builder().imageId(this.imageId).removeContainerVersionDetails(this.removeContainerVersionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",removeContainerVersionDetails=").append(String.valueOf((Object)this.removeContainerVersionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveContainerVersionRequest)) {
            return false;
        }
        RemoveContainerVersionRequest other = (RemoveContainerVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.imageId, other.imageId) && Objects.equals((Object)this.removeContainerVersionDetails, (Object)other.removeContainerVersionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.removeContainerVersionDetails == null ? 43 : this.removeContainerVersionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveContainerVersionRequest, RemoveContainerVersionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String imageId = null;
        private RemoveContainerVersionDetails removeContainerVersionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder removeContainerVersionDetails(RemoveContainerVersionDetails removeContainerVersionDetails) {
            this.removeContainerVersionDetails = removeContainerVersionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveContainerVersionRequest o) {
            this.imageId(o.getImageId());
            this.removeContainerVersionDetails(o.getRemoveContainerVersionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveContainerVersionRequest build() {
            RemoveContainerVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RemoveContainerVersionDetails body) {
            this.removeContainerVersionDetails(body);
            return this;
        }

        public RemoveContainerVersionRequest buildWithoutInvocationCallback() {
            RemoveContainerVersionRequest request = new RemoveContainerVersionRequest();
            request.imageId = this.imageId;
            request.removeContainerVersionDetails = this.removeContainerVersionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

