/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class ErrorsNotifier {
    private final Map<LspServerState, Future<Void>> servers = new WeakHashMap<LspServerState, Future<Void>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(LspServerState server, Future<Void> future) {
        Map<LspServerState, Future<Void>> map = this.servers;
        synchronized (map) {
            this.servers.put(server, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyErrors(URL root) {
        ArrayList<LspServerState> toRemove = new ArrayList<LspServerState>();
        ArrayList<LspServerState> toProcess = new ArrayList<LspServerState>();
        Map<LspServerState, Future<Void>> map = this.servers;
        synchronized (map) {
            for (Map.Entry<LspServerState, Future<Void>> entry : this.servers.entrySet()) {
                if (entry.getValue().isDone()) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                toProcess.add(entry.getKey());
            }
            this.servers.keySet().removeAll(toRemove);
        }
        try {
            Collection filesWithErrors = ErrorsCache.getAllFilesWithRecord((URL)root);
            if (!filesWithErrors.isEmpty()) {
                Project project = FileOwnerQuery.getOwner((URI)root.toURI());
                for (LspServerState server : toProcess) {
                    for (Project p : server.openedProjects().getNow(new Project[0])) {
                        if (p != project) continue;
                        Diagnostic.ReporterControl control = Diagnostic.findReporterControl((Lookup)Lookups.fixed((Object[])new Object[]{server}), null);
                        control.diagnosticChanged((Collection)filesWithErrors.stream().map(url -> URLMapper.findFileObject((URL)url)).filter(fo -> fo != null).collect(Collectors.toList()), null);
                    }
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

