/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;
import org.openide.awt.HtmlRenderer;

public class WinFlatViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private static boolean colorsReady = false;
    private static Color background;
    private static Color activeBackground;
    private static Color selectedBackground;
    private static Color hoverBackground;
    private static Color unselectedHoverBackground;
    private static Color attentionBackground;
    private static Color foreground;
    private static Color activeForeground;
    private static Color selectedForeground;
    private static Color hoverForeground;
    private static Color attentionForeground;
    private static Color underlineColor;
    private static Color inactiveUnderlineColor;
    private static Color tabSeparatorColor;
    private static Color contentBorderColor;
    private static Insets tabInsets;
    private static int underlineHeight;
    private static boolean underlineAtTop;
    private static boolean showTabSeparators;
    private static boolean showSelectedTabBorder;
    private static boolean unscaledBorders;
    private Font font;

    public WinFlatViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinFlatViewTabDisplayerUI((TabDisplayer)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        WinFlatViewTabDisplayerUI.initColors();
        this.getLayoutModel().setPadding(new Dimension(WinFlatViewTabDisplayerUI.tabInsets.left + WinFlatViewTabDisplayerUI.tabInsets.right, 0));
    }

    @Override
    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm.getHeight() + WinFlatViewTabDisplayerUI.tabInsets.top + WinFlatViewTabDisplayerUI.tabInsets.bottom;
        return new Dimension(100, height);
    }

    @Override
    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        int realTxtWidth;
        int busyWidth;
        Icon busyIcon;
        Component buttons;
        int txtLeftPad = WinFlatViewTabDisplayerUI.tabInsets.left;
        int txtRightPad = WinFlatViewTabDisplayerUI.tabInsets.right;
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int availTxtWidth = width - (txtLeftPad + txtRightPad);
        if (this.isSelected(index) && null != (buttons = this.getControlButtons())) {
            Dimension buttonsSize = buttons.getPreferredSize();
            if (width < buttonsSize.width + 4) {
                buttons.setVisible(false);
            } else {
                buttons.setVisible(true);
                availTxtWidth -= buttonsSize.width + 4;
                int yAdjustment = 2;
                buttons.setLocation(x + width - buttonsSize.width - 4, y + (height - buttonsSize.height) / 2 - 1 + yAdjustment);
            }
        }
        if (this.isTabBusy(index)) {
            busyIcon = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(index));
            busyWidth = busyIcon.getIconWidth() + WinFlatUtils.UIScale.scale(3);
            availTxtWidth -= busyWidth;
        } else {
            busyIcon = null;
            busyWidth = 0;
        }
        int n = realTxtWidth = text.startsWith("<html") || text.startsWith("<HTML") ? (int)HtmlRenderer.renderString((String)text, (Graphics)g, (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)foreground, (int)1, (boolean)false) : fm.stringWidth(text);
        if (realTxtWidth > availTxtWidth) {
            int minWidth;
            int left = Math.min(txtLeftPad - 2, realTxtWidth - availTxtWidth);
            txtLeftPad -= left;
            if (realTxtWidth > (availTxtWidth += left + txtRightPad) && text.length() > 3 && (minWidth = fm.stringWidth(text.substring(0, 3) + "\u2026")) > availTxtWidth) {
                for (int i = 2; i >= 0 && fm.stringWidth(text = text.substring(0, i) + "\u2026") >= availTxtWidth; --i) {
                }
            }
        }
        if (busyIcon != null) {
            busyIcon.paintIcon(this.displayer, g, x + txtLeftPad, y + (height - busyIcon.getIconHeight()) / 2);
            x += busyWidth;
            width -= busyWidth;
        }
        Color c = this.colorForState(index, foreground, activeForeground, selectedForeground, hoverForeground, hoverForeground, attentionForeground);
        int txtX = x + txtLeftPad;
        int availH = height - WinFlatViewTabDisplayerUI.tabInsets.top - WinFlatViewTabDisplayerUI.tabInsets.bottom;
        int style = 1;
        if (!this.isSelected(index)) {
            txtX = Math.max(x + 1, x + (width - realTxtWidth) / 2);
        }
        double txtVisualAscent = this.getTxtFont().createGlyphVector(fm.getFontRenderContext(), "H").getVisualBounds().getHeight();
        int txtY = WinFlatViewTabDisplayerUI.tabInsets.top + (int)Math.round(((double)availH + txtVisualAscent) / 2.0) + 1;
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)txtX, (int)txtY, (int)availTxtWidth, (int)height, (Font)this.getTxtFont(), (Color)c, (int)style, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        WinFlatUtils.HiDPIUtils.paintAtScale1x(g, x, y, width, height, (g1x, width1x, height1x, scale) -> this.paintTabBackgroundAtScale1x(g1x, index, width1x, height1x, scale));
    }

    private void paintTabBackgroundAtScale1x(Graphics2D g, int index, int width, int height, double scale) {
        boolean selected = this.isSelected(index);
        Color bg = this.colorForState(index, background, activeBackground, selectedBackground, hoverBackground, unselectedHoverBackground, attentionBackground);
        boolean showSeparator = showTabSeparators && index >= 0 && (!showSelectedTabBorder || !selected && index < this.getDataModel().size() - 1 && !this.isSelected(index + 1));
        int contentBorderWidth = unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(scale, 1);
        int tabSeparatorWidth = showSeparator ? contentBorderWidth : 0;
        g.setColor(bg);
        g.fillRect(0, 0, width - (bg != background ? tabSeparatorWidth : 0), height);
        if (selected) {
            if (showSelectedTabBorder) {
                g.setColor(contentBorderColor);
                g.fillRect(0, 0, width - tabSeparatorWidth, contentBorderWidth);
                g.fillRect(0, 0, contentBorderWidth, height);
                g.fillRect(width - tabSeparatorWidth - contentBorderWidth, 0, contentBorderWidth, height);
            }
            if (underlineHeight > 0) {
                int underlineHeight = (int)Math.round((double)WinFlatViewTabDisplayerUI.underlineHeight * scale);
                g.setColor(this.isActive() ? underlineColor : inactiveUnderlineColor);
                if (underlineAtTop) {
                    g.fillRect(0, 0, width - tabSeparatorWidth, underlineHeight);
                } else {
                    g.fillRect(0, height - underlineHeight, width - tabSeparatorWidth, underlineHeight);
                }
            }
        } else {
            g.setColor(contentBorderColor);
            g.fillRect(0, height - contentBorderWidth, width, contentBorderWidth);
        }
        if (showSeparator) {
            int offset = (int)(4.0 * scale);
            g.setColor(tabSeparatorColor);
            g.fillRect(width - tabSeparatorWidth, offset, tabSeparatorWidth, height - offset * 2 - 1);
        }
    }

    @Override
    protected void paintDisplayerBackground(Graphics g, JComponent c) {
        this.paintTabBackground(g, -1, 0, 0, c.getWidth(), c.getHeight());
        super.paintDisplayerBackground(g, c);
    }

    private Color colorForState(int index, Color normal, Color active, Color selected, Color selectedHover, Color unselectedHover, Color attention) {
        return this.isAttention(index) ? attention : (this.isMouseOver(index) ? (this.isSelected(index) ? selectedHover : unselectedHover) : (this.isSelected(index) ? selected : (this.isActive() ? active : normal)));
    }

    @Override
    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = UIManager.getFont("ViewTab.font");
            if (this.font == null) {
                this.font = UIManager.getFont("Label.font");
            }
        }
        return this.font;
    }

    boolean isMouseOver(int index) {
        if (index < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == index;
    }

    private static void initColors() {
        if (!colorsReady) {
            background = UIManager.getColor("ViewTab.background");
            activeBackground = WinFlatUtils.Utils.getUIColor("ViewTab.activeBackground", background);
            selectedBackground = WinFlatUtils.Utils.getUIColor("ViewTab.selectedBackground", activeBackground);
            hoverBackground = UIManager.getColor("ViewTab.hoverBackground");
            unselectedHoverBackground = WinFlatUtils.Utils.getUIColor("ViewTab.unselectedHoverBackground", hoverBackground);
            attentionBackground = UIManager.getColor("ViewTab.attentionBackground");
            foreground = WinFlatUtils.Utils.getUIColor("ViewTab.foreground", "TabbedPane.foreground");
            activeForeground = WinFlatUtils.Utils.getUIColor("ViewTab.activeForeground", foreground);
            selectedForeground = WinFlatUtils.Utils.getUIColor("ViewTab.selectedForeground", activeForeground);
            hoverForeground = WinFlatUtils.Utils.getUIColor("ViewTab.hoverForeground", foreground);
            attentionForeground = WinFlatUtils.Utils.getUIColor("ViewTab.attentionForeground", foreground);
            underlineColor = UIManager.getColor("ViewTab.underlineColor");
            inactiveUnderlineColor = UIManager.getColor("ViewTab.inactiveUnderlineColor");
            tabSeparatorColor = UIManager.getColor("ViewTab.tabSeparatorColor");
            contentBorderColor = UIManager.getColor("TabbedContainer.view.contentBorderColor");
            tabInsets = UIManager.getInsets("ViewTab.tabInsets");
            underlineHeight = UIManager.getInt("ViewTab.underlineHeight");
            underlineAtTop = UIManager.getBoolean("ViewTab.underlineAtTop");
            showTabSeparators = UIManager.getBoolean("ViewTab.showTabSeparators");
            tabInsets = WinFlatUtils.UIScale.scale(tabInsets);
            underlineHeight = WinFlatUtils.UIScale.scale(underlineHeight);
            showSelectedTabBorder = WinFlatUtils.Utils.getUIBoolean("ViewTab.showSelectedTabBorder", false);
            unscaledBorders = WinFlatUtils.Utils.getUIBoolean("ViewTab.unscaledBorders", false);
            colorsReady = true;
        }
    }

    @Override
    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon ret = WinFlatUtils.FlatTabControlIcon.get(buttonId, buttonState);
        return ret != null ? ret : super.getButtonIcon(buttonId, buttonState);
    }

    @Override
    public void postTabAction(TabActionEvent e) {
        super.postTabAction(e);
        if ("maximize".equals(e.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            this.updateHighlight(WinFlatViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (!this.inControlButtonsRect(e.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = WinFlatViewTabDisplayerUI.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex) - 1;
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex) + 2;
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinFlatViewTabDisplayerUI.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex) - 1;
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex) + 2;
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (repaintRect != null) {
                WinFlatViewTabDisplayerUI.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }
    }
}

