/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class JavadocUtilities {
    private static final String ERROR_IDENT = "<error>";

    private JavadocUtilities() {
    }

    public static boolean isDeprecated(CompilationInfo javac, Element elm) {
        return JavadocUtilities.findDeprecated(javac, elm) != null;
    }

    public static AnnotationMirror findDeprecated(CompilationInfo javac, Element elm) {
        TypeElement deprAnn = javac.getElements().getTypeElement("java.lang.Deprecated");
        if (deprAnn == null) {
            String msg = String.format("Even though the source level of %s is set to JDK5 or later, java.lang.Deprecated cannot be found on the bootclasspath: %s", javac.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE), javac.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT));
            Logger.getLogger(JavadocUtilities.class.getName()).warning(msg);
            return null;
        }
        for (AnnotationMirror annotationMirror : javac.getElements().getAllAnnotationMirrors(elm)) {
            if (!deprAnn.equals(annotationMirror.getAnnotationType().asElement())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasInheritedDoc(CompilationInfo javac, Element elm) {
        return JavadocUtilities.findInheritedDoc(javac, elm) != null;
    }

    public static DocCommentTree findInheritedDoc(CompilationInfo javac, Element elm) {
        if (elm.getKind() == ElementKind.METHOD) {
            TypeElement clazz = (TypeElement)elm.getEnclosingElement();
            return JavadocUtilities.searchInInterfaces(javac, clazz, clazz, (ExecutableElement)elm, new HashSet<TypeElement>());
        }
        return null;
    }

    private static DocCommentTree searchInInterfaces(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider, Set<TypeElement> exclude) {
        DocCommentTree jdoc;
        TypeElement ifceEl;
        for (TypeMirror typeMirror : class2query.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || exclude.contains(ifceEl = (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            jdoc = JavadocUtilities.searchInMethods(javac, ifceEl, overriderClass, overrider);
            if (jdoc != null) {
                return jdoc;
            }
            exclude.add(ifceEl);
        }
        for (TypeMirror typeMirror : class2query.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || (jdoc = JavadocUtilities.searchInInterfaces(javac, ifceEl = (TypeElement)((DeclaredType)typeMirror).asElement(), overriderClass, overrider, exclude)) == null) continue;
            return jdoc;
        }
        return JavadocUtilities.searchInSuperclass(javac, class2query, overriderClass, overrider, exclude);
    }

    private static DocCommentTree searchInSuperclass(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider, Set<TypeElement> exclude) {
        TypeMirror superclassMirror = class2query.getSuperclass();
        if (superclassMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement superclass = (TypeElement)((DeclaredType)superclassMirror).asElement();
        DocCommentTree jdoc = JavadocUtilities.searchInMethods(javac, superclass, overriderClass, overrider);
        if (jdoc != null) {
            return jdoc;
        }
        return JavadocUtilities.searchInInterfaces(javac, superclass, overriderClass, overrider, exclude);
    }

    private static DocCommentTree searchInMethods(CompilationInfo javac, TypeElement class2query, TypeElement overriderClass, ExecutableElement overrider) {
        for (Element element : class2query.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !javac.getElements().overrides(overrider, (ExecutableElement)element, overriderClass)) continue;
            DocCommentTree jdoc = javac.getDocTrees().getDocCommentTree(element);
            return jdoc != null && !jdoc.getFullBody().isEmpty() ? jdoc : null;
        }
        return null;
    }

    static boolean isValid(CompilationInfo javac, TreePath path, Severity severity, Access access, int caret) {
        Tree leaf = path.getLeaf();
        boolean onLine = severity == Severity.HINT && caret > -1;
        switch (leaf.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return access.isAccessible(javac, path, false) && (!onLine || JavadocUtilities.isInHeader(javac, (ClassTree)leaf, caret));
            }
            case METHOD: {
                return access.isAccessible(javac, path, false) && (!onLine || JavadocUtilities.isInHeader(javac, (MethodTree)leaf, caret));
            }
            case VARIABLE: {
                return access.isAccessible(javac, path, false);
            }
        }
        return false;
    }

    public static boolean isGuarded(Tree node, CompilationInfo javac, Document doc) {
        GuardedSectionManager guards = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)doc));
        if (guards != null) {
            try {
                int startOff = (int)javac.getTrees().getSourcePositions().getStartPosition(javac.getCompilationUnit(), node);
                Position startPos = doc.createPosition(startOff);
                for (GuardedSection guard : guards.getGuardedSections()) {
                    if (!guard.contains(startPos, false)) continue;
                    return true;
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                return true;
            }
        }
        return false;
    }

    public static boolean hasErrors(Tree leaf) {
        switch (leaf.getKind()) {
            case METHOD: {
                MethodTree mt = (MethodTree)leaf;
                Tree rt = mt.getReturnType();
                if (rt != null && rt.getKind() == Tree.Kind.ERRONEOUS) {
                    return true;
                }
                if (ERROR_IDENT.contentEquals(mt.getName())) {
                    return true;
                }
                for (VariableTree variableTree : mt.getParameters()) {
                    if (!ERROR_IDENT.contentEquals(variableTree.getName())) continue;
                    return true;
                }
                for (Tree tree : mt.getThrows()) {
                    if (tree.getKind() != Tree.Kind.ERRONEOUS && (tree.getKind() != Tree.Kind.IDENTIFIER || !ERROR_IDENT.contentEquals(((IdentifierTree)tree).getName()))) continue;
                    return true;
                }
                break;
            }
            case VARIABLE: {
                VariableTree vt = (VariableTree)leaf;
                return vt.getType().getKind() == Tree.Kind.ERRONEOUS || ERROR_IDENT.contentEquals(vt.getName());
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                ClassTree classTree = (ClassTree)leaf;
                if (ERROR_IDENT.contentEquals(classTree.getSimpleName())) {
                    return true;
                }
                for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                    if (!ERROR_IDENT.contentEquals(typeParameterTree.getName())) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static boolean isInHeader(CompilationInfo info, ClassTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        List<? extends Tree> impls = tree.getImplementsClause();
        if (impls != null && !impls.isEmpty()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, impls.get(impls.size() - 1));
        } else {
            List<? extends TypeParameterTree> typeparams = tree.getTypeParameters();
            if (typeparams != null && !typeparams.isEmpty()) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, typeparams.get(typeparams.size() - 1));
            } else if (tree.getExtendsClause() != null) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getExtendsClause());
            } else if (tree.getModifiers() != null) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
            }
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE) continue;
            return offset < ts.offset();
        }
        return false;
    }

    private static boolean isInHeader(CompilationInfo info, MethodTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        List<? extends ExpressionTree> throwz = tree.getThrows();
        if (throwz != null && !throwz.isEmpty()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, throwz.get(throwz.size() - 1));
        } else {
            List<? extends VariableTree> params = tree.getParameters();
            if (params != null && !params.isEmpty()) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, params.get(params.size() - 1));
            } else {
                List<? extends TypeParameterTree> typeparams = tree.getTypeParameters();
                if (typeparams != null && !typeparams.isEmpty()) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, typeparams.get(typeparams.size() - 1));
                } else if (tree.getReturnType() != null) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getReturnType());
                } else if (tree.getModifiers() != null) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
                }
            }
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE && ts.token().id() != JavaTokenId.SEMICOLON) continue;
            return offset < ts.offset();
        }
        return false;
    }

    public static int[] createSignaturePositions(Tree t, CompilationInfo javac) {
        int[] span = null;
        if (t.getKind() == Tree.Kind.METHOD) {
            span = javac.getTreeUtilities().findNameSpan((MethodTree)t);
        } else if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
            span = javac.getTreeUtilities().findNameSpan((ClassTree)t);
        } else if (Tree.Kind.VARIABLE == t.getKind()) {
            span = javac.getTreeUtilities().findNameSpan((VariableTree)t);
        }
        return span;
    }

    public static SourceVersion resolveSourceVersion(FileObject file) {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
        if (sourceLevel == null) {
            return SourceVersion.latest();
        }
        if (sourceLevel.startsWith("1.6")) {
            return SourceVersion.RELEASE_6;
        }
        if (sourceLevel.startsWith("1.5")) {
            return SourceVersion.RELEASE_5;
        }
        if (sourceLevel.startsWith("1.4")) {
            return SourceVersion.RELEASE_4;
        }
        if (sourceLevel.startsWith("1.3")) {
            return SourceVersion.RELEASE_3;
        }
        if (sourceLevel.startsWith("1.2")) {
            return SourceVersion.RELEASE_2;
        }
        if (sourceLevel.startsWith("1.1")) {
            return SourceVersion.RELEASE_1;
        }
        if (sourceLevel.startsWith("1.0")) {
            return SourceVersion.RELEASE_0;
        }
        return SourceVersion.latest();
    }
}

