/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.codeception.ui.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public final class CodeceptRunParametersPanel
extends JPanel {
    private static final Map<String, ParameterContainer> PARAM_HISTORY = new HashMap<String, ParameterContainer>();
    private final PhpModule phpModule;
    private JComboBox<String> parametersComboBox;

    private CodeceptRunParametersPanel(@NonNull PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    @CheckForNull
    public static String showDialog(final @NonNull PhpModule phpModule) {
        return (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                assert (EventQueue.isDispatchThread());
                CodeceptRunParametersPanel panel = new CodeceptRunParametersPanel(phpModule);
                NotifyDescriptor descriptor = new NotifyDescriptor((Object)panel, Bundle.CodeceptRunParametersPanel_dialog_title(), 2, -1, null, NotifyDescriptor.OK_OPTION);
                if (DialogDisplayer.getDefault().notify(descriptor) != NotifyDescriptor.OK_OPTION) {
                    return null;
                }
                panel.storeParameters();
                return panel.getSelectedParameters();
            }
        });
    }

    private void init() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("");
        params.addAll(this.getStoredParameters());
        this.parametersComboBox.setModel(new DefaultComboBoxModel<String>(params.toArray(new String[0])));
        this.preselectLastSelectedParam();
    }

    private void preselectLastSelectedParam() {
        ParameterContainer params = this.getParameters();
        if (params == null) {
            return;
        }
        String lastSelected = params.getLastSelected();
        if (lastSelected == null) {
            this.parametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.parametersComboBox.getItemCount(); ++i) {
            String item = this.parametersComboBox.getItemAt(i);
            if (!item.equals(lastSelected)) continue;
            this.parametersComboBox.setSelectedIndex(i);
            break;
        }
    }

    private String getSelectedParameters() {
        return this.parametersComboBox.getSelectedItem().toString().trim();
    }

    @CheckForNull
    private ParameterContainer getParameters() {
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        String sourceDirectoryPath = sourceDirectory.getPath();
        return PARAM_HISTORY.get(sourceDirectoryPath);
    }

    private List<String> getStoredParameters() {
        ParameterContainer stored = this.getParameters();
        if (stored == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(stored.getParams());
        Collections.sort(result);
        return result;
    }

    private void storeParameters() {
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return;
        }
        String sourceDirectoryPath = sourceDirectory.getPath();
        ParameterContainer params = PARAM_HISTORY.get(sourceDirectoryPath);
        if (params == null) {
            params = new ParameterContainer();
            PARAM_HISTORY.put(sourceDirectoryPath, params);
        }
        String currentParam = this.getSelectedParameters();
        params.addParam(currentParam);
        params.setLastSelected(currentParam);
    }

    private void initComponents() {
        this.parametersComboBox = new JComboBox();
        this.parametersComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersComboBox, GroupLayout.Alignment.TRAILING, 0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersComboBox, -2, -1, -2));
    }

    private static final class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public String getLastSelected() {
            assert (EventQueue.isDispatchThread());
            return this.lastSelected;
        }

        public void setLastSelected(String lastSelected) {
            assert (EventQueue.isDispatchThread());
            this.lastSelected = lastSelected;
        }

        public Set<String> getParams() {
            return Collections.unmodifiableSet(this.params);
        }
    }
}

