/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNetworkSecurityGroupRequest
extends BmcRequest<Void> {
    private String networkSecurityGroupId;

    public String getNetworkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    public Builder toBuilder() {
        return new Builder().networkSecurityGroupId(this.networkSecurityGroupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkSecurityGroupId=").append(String.valueOf(this.networkSecurityGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkSecurityGroupRequest)) {
            return false;
        }
        GetNetworkSecurityGroupRequest other = (GetNetworkSecurityGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkSecurityGroupId, other.networkSecurityGroupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkSecurityGroupId == null ? 43 : this.networkSecurityGroupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkSecurityGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkSecurityGroupId = null;

        public Builder networkSecurityGroupId(String networkSecurityGroupId) {
            this.networkSecurityGroupId = networkSecurityGroupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkSecurityGroupRequest o) {
            this.networkSecurityGroupId(o.getNetworkSecurityGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkSecurityGroupRequest build() {
            GetNetworkSecurityGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNetworkSecurityGroupRequest buildWithoutInvocationCallback() {
            GetNetworkSecurityGroupRequest request = new GetNetworkSecurityGroupRequest();
            request.networkSecurityGroupId = this.networkSecurityGroupId;
            return request;
        }
    }
}

