/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.assistant;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.util.NbBundle;

public class AssistantMessages {
    private static AssistantMessages defaultInstance = new AssistantMessages();
    private boolean initialized = false;
    private Map<String, String[]> contextToMessages;

    private AssistantMessages() {
    }

    public static AssistantMessages getDefault() {
        return defaultInstance;
    }

    public String[] getMessages(String context) {
        if (!this.initialized) {
            this.initialize();
        }
        String[] messages = this.contextToMessages.get(context);
        return messages;
    }

    public void setMessages(String context, String ... messages) {
        if (!this.initialized) {
            this.initialize();
        }
        this.contextToMessages.put(context, messages);
    }

    private void initialize() {
        HashMap<String, HashSet<String>> contextToSet = new HashMap<String, HashSet<String>>();
        ResourceBundle bundle = NbBundle.getBundle(AssistantMessages.class);
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String bundleKey = enumeration.nextElement();
            String message = bundle.getString(bundleKey);
            if (message == null || message.trim().length() == 0) continue;
            String context = this.getContext(bundleKey);
            HashSet<String> messages = (HashSet<String>)contextToSet.get(context);
            if (messages == null) {
                messages = new HashSet<String>();
                contextToSet.put(context, messages);
            }
            messages.add(message);
        }
        this.contextToMessages = new HashMap<String, String[]>();
        for (Map.Entry entry : contextToSet.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            String[] messages = value.toArray(new String[0]);
            this.contextToMessages.put(key, messages);
        }
        this.initialized = true;
    }

    private String getContext(String bundleKey) {
        int index = bundleKey.indexOf(95);
        if (index == -1) {
            return bundleKey;
        }
        return bundleKey.substring(0, index);
    }
}

