/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class InitTaskBuildItem
extends MultiBuildItem {
    private final String name;
    private final Optional<String> image;
    private final List<String> command;
    private final List<String> arguments;
    private final Map<String, String> taskEnvVars;
    private final Map<String, String> appEnvVars;
    private final boolean sharedEnvironment;
    private final boolean sharedFilesystem;

    public static InitTaskBuildItem create() {
        return new InitTaskBuildItem("init", Optional.empty(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), false, false);
    }

    public InitTaskBuildItem(String name, Optional<String> image, List<String> command, List<String> arguments, Map<String, String> taskEnvVars, Map<String, String> appEnvVars, boolean sharedEnvironment, boolean sharedFilesystem) {
        this.name = name;
        this.image = image;
        this.command = command;
        this.arguments = arguments;
        this.taskEnvVars = taskEnvVars;
        this.appEnvVars = appEnvVars;
        this.sharedEnvironment = sharedEnvironment;
        this.sharedFilesystem = sharedFilesystem;
    }

    public String getName() {
        return this.name;
    }

    public InitTaskBuildItem withName(String name) {
        return new InitTaskBuildItem(name, this.image, this.command, this.arguments, this.taskEnvVars, this.appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public Optional<String> getImage() {
        return this.image;
    }

    public InitTaskBuildItem withImage(String image) {
        return new InitTaskBuildItem(this.name, Optional.of(image), this.command, this.arguments, this.taskEnvVars, this.appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public InitTaskBuildItem withCommand(List<String> command) {
        return new InitTaskBuildItem(this.name, this.image, command, this.arguments, this.taskEnvVars, this.appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public InitTaskBuildItem withArguments(List<String> arguments) {
        return new InitTaskBuildItem(this.name, this.image, this.command, arguments, this.taskEnvVars, this.appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public Map<String, String> getTaskEnvVars() {
        return this.taskEnvVars;
    }

    public InitTaskBuildItem withTaskEnvVars(Map<String, String> taskEnvVars) {
        return new InitTaskBuildItem(this.name, this.image, this.command, this.arguments, taskEnvVars, this.appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public Map<String, String> getAppEnvVars() {
        return this.appEnvVars;
    }

    public InitTaskBuildItem withAppEnvVars(Map<String, String> appEnvVars) {
        return new InitTaskBuildItem(this.name, this.image, this.command, this.arguments, this.taskEnvVars, appEnvVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public boolean isSharedEnvironment() {
        return this.sharedEnvironment;
    }

    public InitTaskBuildItem withSharedEnvironment(boolean sharedEnvironment) {
        return new InitTaskBuildItem(this.name, this.image, this.command, this.arguments, this.taskEnvVars, this.appEnvVars, sharedEnvironment, this.sharedFilesystem);
    }

    public boolean isSharedFilesystem() {
        return this.sharedFilesystem;
    }

    public InitTaskBuildItem withSharedFilesystem(boolean sharedFilesystem) {
        return new InitTaskBuildItem(this.name, this.image, this.command, this.arguments, this.taskEnvVars, this.appEnvVars, this.sharedEnvironment, sharedFilesystem);
    }
}

