/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapReplaceFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Boolean> {
    public static final Externalizer EXTERNALIZER = new Externalizer();
    private final HK property;
    private final HV expected;
    private final HV replacement;

    public HashMapReplaceFunction(HK property, HV expected, HV replacement) {
        this.property = property;
        this.expected = expected;
        this.replacement = replacement;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Optional existing = view.peek();
        HashMapBucket<HK, HV> bucket = existing.orElse(HashMapBucket.create(Map.of()));
        HashMapBucket next = bucket.replace(this.property, this.expected, this.replacement);
        if (next != null && next != bucket) {
            view.set(next, new MetaParam.Writable[0]);
        }
        return next != null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<HashMapReplaceFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends HashMapReplaceFunction>> getTypeClasses() {
            return Collections.singleton(HashMapReplaceFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_REPLACE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapReplaceFunction object) throws IOException {
            output.writeObject(object.property);
            output.writeObject(object.expected);
            output.writeObject(object.replacement);
        }

        public HashMapReplaceFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new HashMapReplaceFunction(input.readObject(), input.readObject(), input.readObject());
        }
    }
}

