/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoOptimized;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoStandard;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorProxied;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.internal.CompositeUserTypeJavaTypeWrapper;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableRepresentationStrategyPojo
implements EmbeddableRepresentationStrategy {
    private final JavaType<?> embeddableJavaType;
    private final PropertyAccess[] propertyAccesses;
    private final Map<String, Integer> attributeNameToPositionMap;
    private final StrategySelector strategySelector;
    private final ReflectionOptimizer reflectionOptimizer;
    private final EmbeddableInstantiator instantiator;
    private final Map<Object, EmbeddableInstantiator> instantiatorsByDiscriminator;
    private final Map<String, EmbeddableInstantiator> instantiatorsByClass;

    public EmbeddableRepresentationStrategyPojo(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, EmbeddableInstantiator customInstantiator, CompositeUserType<Object> compositeUserType, RuntimeModelCreationContext creationContext) {
        this.embeddableJavaType = EmbeddableRepresentationStrategyPojo.resolveEmbeddableJavaType(bootDescriptor, compositeUserType, creationContext);
        int propertySpan = bootDescriptor.getPropertySpan();
        this.propertyAccesses = new PropertyAccess[propertySpan];
        this.attributeNameToPositionMap = new HashMap<String, Integer>(propertySpan);
        Map<String, Class<?>> subclassesByName = EmbeddableRepresentationStrategyPojo.getSubclassesByName(bootDescriptor, creationContext);
        boolean foundCustomAccessor = false;
        for (int i = 0; i < bootDescriptor.getProperties().size(); ++i) {
            Class<?> subclass;
            Property property = bootDescriptor.getProperty(i);
            Class<?> embeddableClass = bootDescriptor.isPolymorphic() ? ((subclass = NullnessUtil.castNonNull(subclassesByName).get(bootDescriptor.getPropertyDeclaringClass(property))) != null ? subclass : this.getEmbeddableJavaType().getJavaTypeClass()) : this.getEmbeddableJavaType().getJavaTypeClass();
            this.propertyAccesses[i] = this.buildPropertyAccess(property, embeddableClass, customInstantiator == null);
            this.attributeNameToPositionMap.put(property.getName(), i);
            if (property.isBasicPropertyAccessor()) continue;
            foundCustomAccessor = true;
        }
        boolean hasCustomAccessors = foundCustomAccessor;
        this.strategySelector = creationContext.getServiceRegistry().getService(StrategySelector.class);
        this.reflectionOptimizer = EmbeddableRepresentationStrategyPojo.buildReflectionOptimizer(bootDescriptor, hasCustomAccessors, this.propertyAccesses, creationContext);
        if (bootDescriptor.isPolymorphic()) {
            int size = bootDescriptor.getDiscriminatorValues().size();
            this.instantiatorsByDiscriminator = new HashMap<Object, EmbeddableInstantiator>(size);
            this.instantiatorsByClass = new HashMap<String, EmbeddableInstantiator>(size);
            for (Map.Entry<Object, String> discriminator : bootDescriptor.getDiscriminatorValues().entrySet()) {
                String className = discriminator.getValue();
                EmbeddableInstantiator instantiator = EmbeddableRepresentationStrategyPojo.determineInstantiator(bootDescriptor, NullnessUtil.castNonNull(subclassesByName).get(className), this.reflectionOptimizer, runtimeDescriptorAccess, creationContext);
                this.instantiatorsByDiscriminator.put(discriminator.getKey(), instantiator);
                this.instantiatorsByClass.put(className, instantiator);
            }
            this.instantiator = null;
        } else {
            this.instantiator = customInstantiator != null ? customInstantiator : EmbeddableRepresentationStrategyPojo.determineInstantiator(bootDescriptor, bootDescriptor.getComponentClass(), this.reflectionOptimizer, runtimeDescriptorAccess, creationContext);
            this.instantiatorsByDiscriminator = null;
            this.instantiatorsByClass = null;
        }
    }

    private static <T> JavaType<T> resolveEmbeddableJavaType(Component bootDescriptor, CompositeUserType<T> compositeUserType, RuntimeModelCreationContext creationContext) {
        JavaTypeRegistry javaTypeRegistry = creationContext.getTypeConfiguration().getJavaTypeRegistry();
        if (compositeUserType == null) {
            return javaTypeRegistry.resolveDescriptor(bootDescriptor.getComponentClass());
        }
        return javaTypeRegistry.resolveDescriptor(compositeUserType.returnedClass(), () -> new CompositeUserTypeJavaTypeWrapper(compositeUserType));
    }

    private static EmbeddableInstantiator determineInstantiator(Component bootDescriptor, Class<?> embeddableClass, ReflectionOptimizer reflectionOptimizer, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, RuntimeModelCreationContext creationContext) {
        if (reflectionOptimizer != null && reflectionOptimizer.getInstantiationOptimizer() != null) {
            ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer = reflectionOptimizer.getInstantiationOptimizer();
            return new EmbeddableInstantiatorPojoOptimized(embeddableClass, runtimeDescriptorAccess, instantiationOptimizer);
        }
        if (bootDescriptor.isEmbedded() && ReflectHelper.isAbstractClass(embeddableClass)) {
            return new EmbeddableInstantiatorProxied(embeddableClass, runtimeDescriptorAccess, creationContext.getServiceRegistry().requireService(ProxyFactoryFactory.class).buildBasicProxyFactory(embeddableClass));
        }
        return new EmbeddableInstantiatorPojoStandard(embeddableClass, runtimeDescriptorAccess);
    }

    private PropertyAccess buildPropertyAccess(Property bootAttributeDescriptor, Class<?> embeddableClass, boolean requireSetters) {
        PropertyAccessStrategy strategy = bootAttributeDescriptor.getPropertyAccessStrategy(embeddableClass);
        if (strategy == null) {
            String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttributeDescriptor instanceof Backref) {
                Backref backref = (Backref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttributeDescriptor instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.getEmbeddableJavaType().getTypeName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(embeddableClass, bootAttributeDescriptor.getName(), requireSetters);
    }

    private static ReflectionOptimizer buildReflectionOptimizer(Component bootDescriptor, boolean hasCustomAccessors, PropertyAccess[] propertyAccesses, RuntimeModelCreationContext creationContext) {
        if (hasCustomAccessors || bootDescriptor.getCustomInstantiator() != null || bootDescriptor.getInstantiator() != null || bootDescriptor.isPolymorphic()) {
            return null;
        }
        LinkedHashMap<String, PropertyAccess> propertyAccessMap = new LinkedHashMap<String, PropertyAccess>();
        int i = 0;
        for (Property property : bootDescriptor.getProperties()) {
            propertyAccessMap.put(property.getName(), propertyAccesses[i]);
            ++i;
        }
        return creationContext.getServiceRegistry().requireService(BytecodeProvider.class).getReflectionOptimizer(bootDescriptor.getComponentClass(), propertyAccessMap);
    }

    private static Map<String, Class<?>> getSubclassesByName(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (bootDescriptor.isPolymorphic()) {
            Collection<String> subclassNames = bootDescriptor.getDiscriminatorValues().values();
            HashMap result = new HashMap(subclassNames.size());
            ClassLoaderService classLoaderService = creationContext.getMetadata().getMetadataBuildingOptions().getServiceRegistry().requireService(ClassLoaderService.class);
            for (String subclassName : subclassNames) {
                Class<Object> embeddableClass = subclassName.equals(bootDescriptor.getComponentClassName()) ? bootDescriptor.getComponentClass() : classLoaderService.classForName(subclassName);
                result.put(subclassName, embeddableClass);
            }
            return result;
        }
        return null;
    }

    public JavaType<?> getEmbeddableJavaType() {
        return this.embeddableJavaType;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getEmbeddableJavaType();
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return this.propertyAccesses[this.attributeNameToPositionMap.get(bootAttributeDescriptor.getName())];
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        assert (this.instantiator != null && this.instantiatorsByDiscriminator == null && this.instantiatorsByClass == null);
        return this.instantiator;
    }

    @Override
    public EmbeddableInstantiator getInstantiatorForDiscriminator(Object discriminatorValue) {
        if (this.instantiator != null) {
            assert (this.instantiatorsByDiscriminator == null);
            return this.instantiator;
        }
        assert (this.instantiatorsByDiscriminator != null);
        return this.instantiatorsByDiscriminator.get(discriminatorValue);
    }

    @Override
    public EmbeddableInstantiator getInstantiatorForClass(String className) {
        if (this.instantiator != null) {
            assert (this.instantiatorsByClass == null);
            return this.instantiator;
        }
        assert (this.instantiatorsByClass != null);
        return this.instantiatorsByClass.get(className);
    }
}

