/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;
import javax.sip.header.ToHeader;

public final class To
extends AddressParametersHeader
implements ToHeader {
    private static final long serialVersionUID = -4057413800584586316L;

    public To() {
        super("To", true);
    }

    public To(From from) {
        super("To");
        this.setAddress(from.address);
        this.setParameters(from.parameters);
    }

    @Override
    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.address != null) {
            if (this.address.getAddressType() == 2) {
                buffer.append("<");
            }
            this.address.encode(buffer);
            if (this.address.getAddressType() == 2) {
                buffer.append(">");
            }
            if (!this.parameters.isEmpty()) {
                buffer.append(";");
                this.parameters.encode(buffer);
            }
        }
        return buffer;
    }

    public HostPort getHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        if (this.address == null) {
            return null;
        }
        return this.address.getDisplayName();
    }

    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        if (this.parameters == null) {
            return false;
        }
        return this.hasParameter("tag");
    }

    public void removeTag() {
        if (this.parameters != null) {
            this.parameters.delete("tag");
        }
    }

    public void setTag(String t2) throws ParseException {
        Parser.checkToken(t2);
        this.setParameter("tag", t2);
    }

    public String getUserAtHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUserAtHostPort();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ToHeader && super.equals(other);
    }
}

