/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExpressionStack;
import org.jetbrains.java.decompiler.modules.decompiler.PrimitiveExpressionList;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ExprProcessor {
    public static final String UNDEFINED_TYPE_STRING = "<undefinedtype>";
    public static final String UNKNOWN_TYPE_STRING = "<unknown>";
    public static final String NULL_TYPE_STRING = "<null>";
    private static final Map<Integer, Integer> functionMap = Map.of(190, 31, 192, 29, 193, 30);
    private static final VarType[] constants = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_FLOAT, VarType.VARTYPE_LONG, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_CLASS, VarType.VARTYPE_STRING};
    private static final VarType[] varTypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT};
    private static final VarType[] arrTypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT, VarType.VARTYPE_BOOLEAN, VarType.VARTYPE_CHAR, VarType.VARTYPE_SHORT};
    private static final int[] func1 = new int[]{0, 1, 2, 3, 7};
    private static final int[] func2 = new int[]{8, 9, 10, 4, 5, 6};
    private static final int[] func3 = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
    private static final int[] func4 = new int[]{37, 38, 39, 40, 41};
    private static final int[] func5 = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] func6 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] func7 = new int[]{6, 7};
    private static final int[] func8 = new int[]{0, 1};
    private static final int[] arrTypeIds = new int[]{7, 1, 3, 2, 0, 6, 4, 5};
    private static final int[] negIfs = new int[]{1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14};
    private static final String[] typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};
    private static final String EMPTY_ENTRY_POINTS_KEY = "-";
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProcessor;

    public ExprProcessor(MethodDescriptor md, VarProcessor varProc) {
        this.methodDescriptor = md;
        this.varProcessor = varProc;
    }

    public void processStatement(RootStatement root, StructClass cl) {
        CancellationManager cancellationManager = DecompilerContext.getCancellationManager();
        cancellationManager.checkCanceled();
        FlattenStatementsHelper flattenHelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flattenHelper.buildDirectGraph(root);
        HashSet<String> setFinallyShortRangeEntryPoints = new HashSet<String>();
        for (List<FlattenStatementsHelper.FinallyPathWrapper> list : dgraph.mapShortRangeFinallyPaths.values()) {
            for (Object wrapper : list) {
                setFinallyShortRangeEntryPoints.add(((FlattenStatementsHelper.FinallyPathWrapper)wrapper).entry);
            }
        }
        HashSet<CallSite> setFinallyLongRangeEntryPaths = new HashSet<CallSite>();
        for (List<FlattenStatementsHelper.FinallyPathWrapper> list : dgraph.mapLongRangeFinallyPaths.values()) {
            for (FlattenStatementsHelper.FinallyPathWrapper wrapper : list) {
                setFinallyLongRangeEntryPaths.add((CallSite)((Object)(wrapper.source + "##" + wrapper.entry)));
            }
        }
        HashMap<String, VarExprent> hashMap = new HashMap<String, VarExprent>();
        ExprProcessor.collectCatchVars(root, flattenHelper, hashMap);
        HashMap<DirectNode, Map> hashMap2 = new HashMap<DirectNode, Map>();
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        LinkedList stackEntryPoint = new LinkedList();
        stack.add(dgraph.first);
        stackEntryPoint.add(new LinkedList());
        HashMap<String, PrimitiveExpressionList> map = new HashMap<String, PrimitiveExpressionList>();
        map.put(EMPTY_ENTRY_POINTS_KEY, new PrimitiveExpressionList());
        hashMap2.put(dgraph.first, map);
        while (!stack.isEmpty()) {
            cancellationManager.checkCanceled();
            DirectNode node = (DirectNode)stack.removeFirst();
            LinkedList entryPoints = (LinkedList)stackEntryPoint.removeFirst();
            PrimitiveExpressionList data = hashMap.containsKey(node.id) ? ExprProcessor.getExpressionData((VarExprent)hashMap.get(node.id)) : (PrimitiveExpressionList)((Map)hashMap2.get(node)).get(ExprProcessor.buildEntryPointKey(entryPoints));
            BasicBlockStatement block = node.block;
            if (block != null) {
                this.processBlock(block, data, cl);
                block.setExprents(data.getExpressions());
            }
            String currentEntrypoint = entryPoints.isEmpty() ? null : (String)entryPoints.getLast();
            for (DirectNode nd : node.successors) {
                String nodeEntryKey;
                cancellationManager.checkCanceled();
                boolean isSuccessor = true;
                if (currentEntrypoint != null && dgraph.mapLongRangeFinallyPaths.containsKey(node.id)) {
                    isSuccessor = false;
                    for (FlattenStatementsHelper.FinallyPathWrapper wrapper : dgraph.mapLongRangeFinallyPaths.get(node.id)) {
                        if (!wrapper.source.equals(currentEntrypoint) || !wrapper.destination.equals(nd.id)) continue;
                        isSuccessor = true;
                        break;
                    }
                }
                if (!isSuccessor) continue;
                Map successorMap = hashMap2.computeIfAbsent(nd, k -> new HashMap());
                LinkedList<String> nodeEntryPoints = new LinkedList<String>(entryPoints);
                if (setFinallyLongRangeEntryPaths.contains(node.id + "##" + nd.id)) {
                    nodeEntryPoints.addLast(node.id);
                } else if (!setFinallyShortRangeEntryPoints.contains(nd.id) && dgraph.mapLongRangeFinallyPaths.containsKey(node.id)) {
                    nodeEntryPoints.removeLast();
                }
                int successorEntryIndex = nodeEntryPoints.indexOf(nd.id);
                if (successorEntryIndex >= 0) {
                    for (int elementsToRemove = nodeEntryPoints.size() - successorEntryIndex; elementsToRemove > 0; --elementsToRemove) {
                        nodeEntryPoints.removeLast();
                    }
                }
                if (successorMap.containsKey(nodeEntryKey = ExprProcessor.buildEntryPointKey(nodeEntryPoints))) continue;
                successorMap.put(nodeEntryKey, data.copy());
                stack.add(nd);
                stackEntryPoint.add(nodeEntryPoints);
            }
        }
        ExprProcessor.initStatementExprEntries(root);
    }

    private static String buildEntryPointKey(LinkedList<String> entryPoints) {
        if (entryPoints.isEmpty()) {
            return EMPTY_ENTRY_POINTS_KEY;
        }
        if (entryPoints.size() == 1) {
            return entryPoints.getFirst();
        }
        return String.join((CharSequence)":", entryPoints);
    }

    private static void collectCatchVars(Statement stat, FlattenStatementsHelper flattenHelper, Map<String, VarExprent> map) {
        List<VarExprent> lst = null;
        if (stat.type == Statement.StatementType.CATCH_ALL) {
            CatchAllStatement catchall = (CatchAllStatement)stat;
            if (!catchall.isFinally()) {
                lst = catchall.getVars();
            }
        } else if (stat.type == Statement.StatementType.TRY_CATCH) {
            lst = ((CatchStatement)stat).getVars();
        }
        if (lst != null) {
            for (int i = 1; i < stat.getStats().size(); ++i) {
                map.put(flattenHelper.getMapDestinationNodes().get(((Statement)stat.getStats().get((int)i)).id)[0], lst.get(i - 1));
            }
        }
        for (Statement st : stat.getStats()) {
            ExprProcessor.collectCatchVars(st, flattenHelper, map);
        }
    }

    private static void initStatementExprEntries(Statement stat) {
        stat.initExprents();
        for (Statement st : stat.getStats()) {
            ExprProcessor.initStatementExprEntries(st);
        }
    }

    public void processBlock(BasicBlockStatement stat, PrimitiveExpressionList data, StructClass cl) {
        ConstantPool pool = cl.getPool();
        StructBootstrapMethodsAttribute bootstrap = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS);
        BasicBlock block = stat.getBlock();
        ExpressionStack stack = data.getStack();
        List<Exprent> exprList = data.getExpressions();
        InstructionSequence seq = block.getSeq();
        block40: for (int i = 0; i < seq.length(); ++i) {
            Instruction instr = seq.getInstr(i);
            Integer offset = block.getOriginalOffset(i);
            BitSet offsets = null;
            if (offset >= 0) {
                offsets = new BitSet();
                offsets.set(offset);
                int end_offset = block.getOriginalOffset(i + 1);
                if (end_offset > offset && seq.length() > i + 1) {
                    offsets.set((int)offset, end_offset);
                }
            }
            switch (instr.opcode) {
                case 1: {
                    this.pushEx(stack, exprList, new ConstExprent(VarType.VARTYPE_NULL, null, offsets));
                    continue block40;
                }
                case 16: 
                case 17: {
                    this.pushEx(stack, exprList, new ConstExprent(instr.operand(0), true, offsets));
                    continue block40;
                }
                case 9: 
                case 10: {
                    this.pushEx(stack, exprList, new ConstExprent(VarType.VARTYPE_LONG, instr.opcode - 9, offsets));
                    continue block40;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.pushEx(stack, exprList, new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(instr.opcode - 11), offsets));
                    continue block40;
                }
                case 14: 
                case 15: {
                    this.pushEx(stack, exprList, new ConstExprent(VarType.VARTYPE_DOUBLE, instr.opcode - 14, offsets));
                    continue block40;
                }
                case 18: 
                case 19: 
                case 20: {
                    PooledConstant cn = pool.getConstant(instr.operand(0));
                    if (cn instanceof PrimitiveConstant) {
                        this.pushEx(stack, exprList, new ConstExprent(constants[cn.type - 3], ((PrimitiveConstant)cn).value, offsets));
                        continue block40;
                    }
                    if (!(cn instanceof LinkConstant)) continue block40;
                    this.pushEx(stack, exprList, new ConstExprent(VarType.VARTYPE_STRING, ((LinkConstant)cn).elementName, offsets));
                    continue block40;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    VarExprent varExprent = new VarExprent(instr.operand(0), varTypes[instr.opcode - 21], this.varProcessor, offsets);
                    this.varProcessor.findLVT(varExprent, offset + instr.length);
                    this.pushEx(stack, exprList, varExprent);
                    continue block40;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Exprent index = (Exprent)stack.pop();
                    Exprent arr = (Exprent)stack.pop();
                    VarType type = instr.opcode == 47 ? VarType.VARTYPE_LONG : (instr.opcode == 49 ? VarType.VARTYPE_DOUBLE : null);
                    this.pushEx(stack, exprList, new ArrayExprent(arr, index, arrTypes[instr.opcode - 46], offsets), type);
                    continue block40;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    Exprent value = (Exprent)stack.pop();
                    int varIndex = instr.operand(0);
                    if (offsets != null) {
                        offsets.set((int)offset, offset + instr.length);
                    }
                    VarExprent left = new VarExprent(varIndex, varTypes[instr.opcode - 54], this.varProcessor, offsets);
                    this.varProcessor.findLVT(left, offset + instr.length);
                    exprList.add(new AssignmentExprent(left, value, offsets));
                    continue block40;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    Exprent value = (Exprent)stack.pop();
                    Exprent index = (Exprent)stack.pop();
                    Exprent array = (Exprent)stack.pop();
                    ArrayExprent left = new ArrayExprent(array, index, arrTypes[instr.opcode - 79], offsets);
                    exprList.add(new AssignmentExprent(left, value, offsets));
                    continue block40;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    this.pushEx(stack, exprList, new FunctionExprent(func1[(instr.opcode - 96) / 4], stack, offsets));
                    continue block40;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.pushEx(stack, exprList, new FunctionExprent(func2[(instr.opcode - 120) / 2], stack, offsets));
                    continue block40;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.pushEx(stack, exprList, new FunctionExprent(13, stack, offsets));
                    continue block40;
                }
                case 132: {
                    VarExprent varExpr = new VarExprent(instr.operand(0), VarType.VARTYPE_INT, this.varProcessor, offsets);
                    this.varProcessor.findLVT(varExpr, offset + instr.length);
                    int type = instr.operand(1) < 0 ? 1 : 0;
                    List<Exprent> operands = Arrays.asList(varExpr.copy(), new ConstExprent(VarType.VARTYPE_INT, Math.abs(instr.operand(1)), null));
                    exprList.add(new AssignmentExprent(varExpr, new FunctionExprent(type, operands, offsets), offsets));
                    continue block40;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    this.pushEx(stack, exprList, new FunctionExprent(func3[instr.opcode - 133], stack, offsets));
                    continue block40;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.pushEx(stack, exprList, new FunctionExprent(func4[instr.opcode - 148], stack, offsets));
                    continue block40;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    exprList.add(new IfExprent(negIfs[func5[instr.opcode - 153]], stack, offsets));
                    continue block40;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    exprList.add(new IfExprent(negIfs[func6[instr.opcode - 159]], stack, offsets));
                    continue block40;
                }
                case 198: 
                case 199: {
                    exprList.add(new IfExprent(negIfs[func7[instr.opcode - 198]], stack, offsets));
                    continue block40;
                }
                case 170: 
                case 171: {
                    exprList.add(new SwitchExprent((Exprent)stack.pop(), offsets));
                    continue block40;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    exprList.add(new ExitExprent(instr.opcode == 191 ? 1 : 0, instr.opcode == 177 ? null : (Exprent)stack.pop(), instr.opcode == 191 ? null : this.methodDescriptor.ret, offsets, this.methodDescriptor));
                    continue block40;
                }
                case 194: 
                case 195: {
                    exprList.add(new MonitorExprent(func8[instr.opcode - 194], (Exprent)stack.pop(), offsets));
                    continue block40;
                }
                case 192: 
                case 193: {
                    stack.push(new ConstExprent(new VarType(pool.getPrimitiveConstant(instr.operand(0)).getString(), true), null, null));
                }
                case 190: {
                    this.pushEx(stack, exprList, new FunctionExprent((int)functionMap.get(instr.opcode), stack, offsets));
                    continue block40;
                }
                case 178: 
                case 180: {
                    this.pushEx(stack, exprList, new FieldExprent(pool.getLinkConstant(instr.operand(0)), instr.opcode == 178 ? null : (Exprent)stack.pop(), offsets));
                    continue block40;
                }
                case 179: 
                case 181: {
                    Exprent valField = (Exprent)stack.pop();
                    FieldExprent exprField = new FieldExprent(pool.getLinkConstant(instr.operand(0)), instr.opcode == 179 ? null : (Exprent)stack.pop(), offsets);
                    exprList.add(new AssignmentExprent(exprField, valField, offsets));
                    continue block40;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    if (instr.opcode == 186 && instr.bytecodeVersion < 51) continue block40;
                    LinkConstant invoke_constant = pool.getLinkConstant(instr.operand(0));
                    List<PooledConstant> bootstrap_arguments = null;
                    if (instr.opcode == 186 && bootstrap != null) {
                        bootstrap_arguments = bootstrap.getMethodArguments(invoke_constant.index1);
                    }
                    InvocationExprent exprInv = new InvocationExprent(instr.opcode, invoke_constant, bootstrap_arguments, stack, offsets);
                    if (exprInv.getDescriptor().ret.getType() == 10) {
                        exprList.add(exprInv);
                        continue block40;
                    }
                    this.pushEx(stack, exprList, exprInv);
                    continue block40;
                }
                case 187: 
                case 189: 
                case 197: {
                    int dimensions = instr.opcode == 187 ? 0 : (instr.opcode == 189 ? 1 : instr.operand(1));
                    VarType arrType = new VarType(pool.getPrimitiveConstant(instr.operand(0)).getString(), true);
                    if (instr.opcode != 197) {
                        arrType = arrType.resizeArrayDim(arrType.getArrayDim() + dimensions);
                    }
                    this.pushEx(stack, exprList, new NewExprent(arrType, stack, dimensions, offsets));
                    continue block40;
                }
                case 188: {
                    this.pushEx(stack, exprList, new NewExprent(new VarType(arrTypeIds[instr.operand(0) - 4], 1), stack, 1, offsets));
                    continue block40;
                }
                case 89: {
                    this.pushEx(stack, exprList, ((Exprent)stack.getByOffset(-1)).copy());
                    continue block40;
                }
                case 90: {
                    this.insertByOffsetEx(-2, stack, exprList, -1);
                    continue block40;
                }
                case 91: {
                    if (((Exprent)stack.getByOffset(-2)).getExprType().getStackSize() == 2) {
                        this.insertByOffsetEx(-2, stack, exprList, -1);
                        continue block40;
                    }
                    this.insertByOffsetEx(-3, stack, exprList, -1);
                    continue block40;
                }
                case 92: {
                    if (((Exprent)stack.getByOffset(-1)).getExprType().getStackSize() == 2) {
                        this.pushEx(stack, exprList, ((Exprent)stack.getByOffset(-1)).copy());
                        continue block40;
                    }
                    this.pushEx(stack, exprList, ((Exprent)stack.getByOffset(-2)).copy());
                    this.pushEx(stack, exprList, ((Exprent)stack.getByOffset(-2)).copy());
                    continue block40;
                }
                case 93: {
                    if (((Exprent)stack.getByOffset(-1)).getExprType().getStackSize() == 2) {
                        this.insertByOffsetEx(-2, stack, exprList, -1);
                        continue block40;
                    }
                    this.insertByOffsetEx(-3, stack, exprList, -2);
                    this.insertByOffsetEx(-3, stack, exprList, -1);
                    continue block40;
                }
                case 94: {
                    if (((Exprent)stack.getByOffset(-1)).getExprType().getStackSize() == 2) {
                        if (((Exprent)stack.getByOffset(-2)).getExprType().getStackSize() == 2) {
                            this.insertByOffsetEx(-2, stack, exprList, -1);
                            continue block40;
                        }
                        this.insertByOffsetEx(-3, stack, exprList, -1);
                        continue block40;
                    }
                    if (((Exprent)stack.getByOffset(-3)).getExprType().getStackSize() == 2) {
                        this.insertByOffsetEx(-3, stack, exprList, -2);
                        this.insertByOffsetEx(-3, stack, exprList, -1);
                        continue block40;
                    }
                    this.insertByOffsetEx(-4, stack, exprList, -2);
                    this.insertByOffsetEx(-4, stack, exprList, -1);
                    continue block40;
                }
                case 95: {
                    this.insertByOffsetEx(-2, stack, exprList, -1);
                    stack.pop();
                    continue block40;
                }
                case 87: {
                    stack.pop();
                    continue block40;
                }
                case 88: {
                    if (((Exprent)stack.getByOffset(-1)).getExprType().getStackSize() == 1) {
                        stack.pop();
                    }
                    stack.pop();
                }
            }
        }
    }

    private static int nextMeaningfulOffset(BasicBlock block, int index) {
        InstructionSequence seq = block.getSeq();
        block3: while (++index < seq.length()) {
            switch (seq.getInstr((int)index).opcode) {
                case 0: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    continue block3;
                }
            }
            return block.getOriginalOffset(index);
        }
        List<BasicBlock> successors = block.getSuccessors();
        if (successors.size() == 1) {
            return successors.get(0).getOriginalOffset(0);
        }
        return -1;
    }

    private void pushEx(ExpressionStack stack, List<Exprent> exprlist, Exprent exprent) {
        this.pushEx(stack, exprlist, exprent, null);
    }

    private void pushEx(ExpressionStack stack, List<Exprent> exprlist, Exprent exprent, VarType vartype) {
        int varIndex = 10000 + stack.size();
        VarExprent var = new VarExprent(varIndex, vartype == null ? exprent.getExprType() : vartype, this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        stack.push(var.copy());
    }

    private void insertByOffsetEx(int offset, ExpressionStack stack, List<Exprent> exprlist, int copyOffset) {
        int base = 10000 + stack.size();
        LinkedList<VarExprent> lst = new LinkedList<VarExprent>();
        for (int i = -1; i >= offset; --i) {
            Exprent varEx = (Exprent)stack.pop();
            VarExprent varNew = new VarExprent(base + i + 1, varEx.getExprType(), this.varProcessor);
            varNew.setStack(true);
            exprlist.add(new AssignmentExprent(varNew, varEx, null));
            lst.add(0, (VarExprent)varNew.copy());
        }
        Exprent exprent = ((VarExprent)lst.get(lst.size() + copyOffset)).copy();
        VarExprent var = new VarExprent(base + offset, exprent.getExprType(), this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        lst.add(0, (VarExprent)var.copy());
        for (VarExprent expr : lst) {
            stack.push(expr);
        }
    }

    public static String getTypeName(VarType type, List<TypeAnnotationWriteHelper> typePathWriteHelper) {
        return ExprProcessor.getTypeName(type, true, typePathWriteHelper);
    }

    public static String getTypeName(VarType type, boolean getShort, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        int tp = type.getType();
        StringBuilder sb = new StringBuilder();
        typeAnnWriteHelpers = ExprProcessor.writeTypeAnnotationBeforeType(type, sb, typeAnnWriteHelpers);
        if (tp <= 7) {
            sb.append(typeNames[tp]);
            return sb.toString();
        }
        if (tp == 17) {
            sb.append(UNKNOWN_TYPE_STRING);
            return sb.toString();
        }
        if (tp == 13) {
            sb.append(NULL_TYPE_STRING);
            return sb.toString();
        }
        if (tp == 10) {
            sb.append("void");
            return sb.toString();
        }
        if (tp == 18 && type.isGeneric()) {
            sb.append(type.getValue());
            return sb.toString();
        }
        if (tp == 8) {
            if (type.isGeneric()) {
                ((GenericType)type).appendCastName(sb, typeAnnWriteHelpers);
                return sb.toString();
            }
            String ret = getShort ? DecompilerContext.getImportCollector().getNestedName(type.getValue()) : ExprProcessor.buildJavaClassName(type.getValue());
            if (ret == null) {
                return UNDEFINED_TYPE_STRING;
            }
            List<String> nestedTypes = Arrays.asList(ret.split("\\."));
            typeAnnWriteHelpers = ExprProcessor.writeNestedClass(sb, type, nestedTypes, typeAnnWriteHelpers);
            ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
            return sb.toString();
        }
        throw new RuntimeException("invalid type");
    }

    public static List<TypeAnnotationWriteHelper> writeTypeAnnotationBeforeType(Type type, StringBuilder sb, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            if (typeAnnWriteHelper.getAnnotation().isWrittenBeforeType(type)) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            StructTypePathEntry pathEntry = typeAnnWriteHelper.getPaths().peek();
            if (pathEntry != null && pathEntry.getTypePathEntryKind() == StructTypePathEntry.Kind.NESTED.getId() && type.isAnnotatable()) {
                typeAnnWriteHelper.getPaths().pop();
            }
            return true;
        }).collect(Collectors.toList());
    }

    public static List<TypeAnnotationWriteHelper> writeNestedClass(StringBuilder sb, Type type, List<String> nestedTypes, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        List<ClassesProcessor.ClassNode> enclosingClasses = ExprProcessor.enclosingClassList();
        StringBuilder curPathBuilder = new StringBuilder(type.getValue().substring(0, type.getValue().lastIndexOf(47) + 1));
        for (int i = 0; i < nestedTypes.size(); ++i) {
            String nestedType = nestedTypes.get(i);
            boolean shouldWrite = true;
            if (!enclosingClasses.isEmpty() && i != nestedTypes.size() - 1) {
                String enclosingType = enclosingClasses.remove((int)0).simpleName;
                boolean bl = shouldWrite = !nestedType.equals(enclosingType) || enclosingClasses.isEmpty() && DecompilerContext.getOption("IN_CLASS_TYPE_PARAMS");
            }
            if (i == 0) {
                if (!sb.toString().isEmpty()) {
                    shouldWrite = true;
                }
            } else if (ExprProcessor.canWriteNestedTypeAnnotation(curPathBuilder + nestedType + "$", nestedTypes.subList(i + 1, nestedTypes.size()))) {
                List<TypeAnnotationWriteHelper> notWrittenTypeAnnotations = ExprProcessor.writeNestedTypeAnnotations(sb, typeAnnWriteHelpers);
                shouldWrite |= notWrittenTypeAnnotations.size() != typeAnnWriteHelpers.size();
                typeAnnWriteHelpers = notWrittenTypeAnnotations;
                if (i != nestedTypes.size() - 1) {
                    ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
                }
            }
            if (!shouldWrite) continue;
            sb.append(nestedType);
            curPathBuilder.append(nestedType);
            if (i == nestedTypes.size() - 1) continue;
            curPathBuilder.append('$');
            sb.append('.');
        }
        return typeAnnWriteHelpers;
    }

    public static boolean canWriteNestedTypeAnnotation(String curPath, List<String> nestedTypes) {
        if (nestedTypes.isEmpty()) {
            return true;
        }
        String fullName = curPath + nestedTypes.get(0);
        StructClass currentClass = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
        StructInnerClassesAttribute attribute = currentClass.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES);
        if (attribute == null) {
            return false;
        }
        Optional<StructInnerClassesAttribute.Entry> first = attribute.getEntries().stream().filter(t -> t.innerName != null && t.innerName.equals(fullName)).findFirst();
        if (first.isEmpty()) {
            return false;
        }
        StructInnerClassesAttribute.Entry entry = first.get();
        return (entry.accessFlags & 8) == 0 && ExprProcessor.canWriteNestedTypeAnnotation(fullName + "$", nestedTypes.subList(1, nestedTypes.size()));
    }

    public static List<ClassesProcessor.ClassNode> enclosingClassList() {
        ClassesProcessor.ClassNode enclosingClass = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        ArrayList<ClassesProcessor.ClassNode> enclosingClassList = new ArrayList<ClassesProcessor.ClassNode>(List.of(enclosingClass));
        while (enclosingClass.parent != null) {
            enclosingClass = enclosingClass.parent;
            enclosingClassList.add(0, enclosingClass);
        }
        return enclosingClassList.stream().filter(classNode -> classNode.type != 2 && classNode.type != 8).collect(Collectors.toList());
    }

    public static List<TypeAnnotationWriteHelper> writeNestedTypeAnnotations(StringBuilder sb, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if (path == null) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public static void popNestedTypeAnnotation(List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        typeAnnWriteHelpers.forEach(typeAnnWriteHelper -> {
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if (path != null && path.getTypePathEntryKind() == StructTypePathEntry.Kind.NESTED.getId()) {
                typeAnnWriteHelper.getPaths().pop();
            }
        });
    }

    public static String getCastTypeName(VarType type, List<TypeAnnotationWriteHelper> typePathWriteHelper) {
        return ExprProcessor.getCastTypeName(type, true, typePathWriteHelper);
    }

    public static String getCastTypeName(VarType type, boolean getShort, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        List<TypeAnnotationWriteHelper> arrayTypeAnnWriteHelpers = ExprProcessor.arrayPath(type, typeAnnWriteHelpers);
        List<TypeAnnotationWriteHelper> nonArrayTypeAnnWriteHelpers = ExprProcessor.nonArrayPath(type, typeAnnWriteHelpers);
        StringBuilder sb = new StringBuilder(ExprProcessor.getTypeName(type, getShort, nonArrayTypeAnnWriteHelpers));
        ExprProcessor.writeArray(sb, type.getArrayDim(), arrayTypeAnnWriteHelpers);
        return sb.toString();
    }

    public static List<TypeAnnotationWriteHelper> arrayPath(Type type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> typeAnnWriteHelper.getPaths().size() < type.getArrayDim()).collect(Collectors.toList());
    }

    public static List<TypeAnnotationWriteHelper> nonArrayPath(Type type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(stack -> {
            boolean isArrayPath;
            boolean bl = isArrayPath = stack.getPaths().size() < type.getArrayDim();
            if (stack.getPaths().size() > type.getArrayDim()) {
                for (int i = 0; i < type.getArrayDim(); ++i) {
                    stack.getPaths().poll();
                }
            }
            return !isArrayPath;
        }).collect(Collectors.toList());
    }

    public static void writeArray(StringBuilder sb, int arrayDim, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        for (int i = 0; i < arrayDim; ++i) {
            boolean firstIteration = true;
            for (TypeAnnotationWriteHelper typeAnnotationWriteHelper : typeAnnWriteHelpers) {
                if (i != typeAnnotationWriteHelper.getPaths().size()) continue;
                if (firstIteration) {
                    sb.append(' ');
                    firstIteration = false;
                }
                typeAnnotationWriteHelper.writeTo(sb);
            }
            sb.append("[]");
        }
    }

    public static PrimitiveExpressionList getExpressionData(VarExprent var) {
        PrimitiveExpressionList expressionList = new PrimitiveExpressionList();
        VarExprent varTmp = new VarExprent(10000, var.getExprType(), var.getProcessor());
        varTmp.setStack(true);
        expressionList.getExpressions().add(new AssignmentExprent(varTmp, var.copy(), null));
        expressionList.getStack().push(varTmp.copy());
        return expressionList;
    }

    public static boolean endsWithSemicolon(Exprent expr) {
        int type = expr.type;
        return type != 11 && type != 9 && type != 7 && (type != 12 || !((VarExprent)expr).isClassDef());
    }

    private static void addDeletedGotoInstructionMapping(Statement stat, BytecodeMappingTracer tracer) {
        BasicBlock block;
        List<Integer> offsets;
        if (stat instanceof BasicBlockStatement && !(offsets = (block = ((BasicBlockStatement)stat).getBlock()).getOriginalOffsets()).isEmpty() && offsets.size() > block.getSeq().length()) {
            tracer.addMapping(offsets.get(offsets.size() - 1));
        }
    }

    public static TextBuffer jmpWrapper(Statement stat, int indent, boolean semicolon, BytecodeMappingTracer tracer) {
        StatEdge edge;
        TextBuffer buf = stat.toJava(indent, tracer);
        List<StatEdge> successorEdges = stat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
        if (successorEdges.size() == 1 && (edge = successorEdges.get(0)).getType() != StatEdge.EdgeType.REGULAR && edge.explicit && edge.getDestination().type != Statement.StatementType.DUMMY_EXIT) {
            buf.appendIndent(indent);
            if (StatEdge.EdgeType.BREAK.equals(edge.getType())) {
                ExprProcessor.addDeletedGotoInstructionMapping(stat, tracer);
                buf.append("break");
            } else if (StatEdge.EdgeType.CONTINUE.equals(edge.getType())) {
                ExprProcessor.addDeletedGotoInstructionMapping(stat, tracer);
                buf.append("continue");
            }
            if (edge.labeled) {
                buf.append(" label").append(Integer.toString(edge.closure.id));
            }
            buf.append(";").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        if (buf.length() == 0 && semicolon) {
            buf.appendIndent(indent).append(";").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    public static String buildJavaClassName(String name) {
        StructClass cl;
        String res = name.replace('/', '.');
        if (res.contains("$") && ((cl = DecompilerContext.getStructContext().getClass(name)) == null || !cl.isOwn())) {
            res = res.replace('$', '.');
        }
        return res;
    }

    public static TextBuffer listToJava(List<? extends Exprent> lst, int indent, BytecodeMappingTracer tracer) {
        if (lst == null || lst.isEmpty()) {
            return new TextBuffer();
        }
        TextBuffer buf = new TextBuffer();
        lst = Exprent.sortIndexed(lst);
        for (Exprent exprent : lst) {
            if (buf.length() > 0 && exprent.type == 12 && ((VarExprent)exprent).isClassDef()) {
                buf.appendLineSeparator();
                tracer.incrementCurrentSourceLine();
            }
            exprent.inferExprType(null);
            TextBuffer content = exprent.toJava(indent, tracer);
            if (content.length() <= 0) continue;
            if (exprent.type != 12 || !((VarExprent)exprent).isClassDef()) {
                buf.appendIndent(indent);
            }
            buf.append(content);
            if (exprent.type == 9 && ((MonitorExprent)exprent).getMonType() == 0) {
                buf.append("{}");
            }
            if (ExprProcessor.endsWithSemicolon(exprent)) {
                buf.append(";");
            }
            buf.appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    public static ConstExprent getDefaultArrayValue(VarType arrType) {
        ConstExprent defaultVal = arrType.getType() == 8 || arrType.getArrayDim() > 0 ? new ConstExprent(VarType.VARTYPE_NULL, null, null) : (arrType.getType() == 3 ? new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(0.0f), null) : (arrType.getType() == 5 ? new ConstExprent(VarType.VARTYPE_LONG, 0L, null) : (arrType.getType() == 2 ? new ConstExprent(VarType.VARTYPE_DOUBLE, 0.0, null) : new ConstExprent(0, true, null))));
        return defaultVal;
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, boolean castNull, BytecodeMappingTracer tracer) {
        return ExprProcessor.getCastedExprent(exprent, leftType, buffer, indent, castNull, false, false, false, tracer);
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, boolean castNull, boolean castAlways, boolean castNarrowing, boolean unbox, BytecodeMappingTracer tracer) {
        boolean quote;
        if (unbox && exprent.type == 8 && ((InvocationExprent)exprent).isBoxingCall()) {
            InvocationExprent invocationExprent = (InvocationExprent)exprent;
            exprent = invocationExprent.getParameters().get(0);
            int paramType = invocationExprent.getDescriptor().params[0].getType();
            if (exprent.type == 3 && ((ConstExprent)exprent).getConstType().getType() != paramType) {
                leftType = new VarType(paramType);
            }
        }
        exprent.inferExprType(leftType);
        VarType rightType = exprent.getExprType();
        boolean isCastNull = rightType.getType() == 13 && !UNDEFINED_TYPE_STRING.equals(ExprProcessor.getTypeName(leftType, Collections.emptyList()));
        boolean cast = castAlways || !leftType.isSuperset(rightType) && (rightType.equals(VarType.VARTYPE_OBJECT) || leftType.getType() != 8 && !isCastNull) || castNull && isCastNull || castNarrowing && ExprProcessor.isIntConstant(exprent) && ExprProcessor.isNarrowedIntType(leftType);
        boolean castLambda = !cast && exprent.type == 10 && !leftType.equals(rightType) && ExprProcessor.lambdaNeedsCast(leftType, (NewExprent)exprent);
        boolean bl = quote = cast && exprent.getPrecedence() >= FunctionExprent.getPrecedence(29);
        if (castNarrowing && exprent.type == 3 && !((ConstExprent)exprent).isNull()) {
            if (leftType.equals(VarType.VARTYPE_BYTE_OBJ)) {
                leftType = VarType.VARTYPE_BYTE;
            } else if (leftType.equals(VarType.VARTYPE_SHORT_OBJ)) {
                leftType = VarType.VARTYPE_SHORT;
            }
        }
        if (cast) {
            buffer.append('(').append(ExprProcessor.getCastTypeName(leftType, Collections.emptyList())).append(')');
        }
        if (castLambda) {
            buffer.append('(').append(ExprProcessor.getCastTypeName(rightType, Collections.emptyList())).append(')');
        }
        if (quote) {
            buffer.append('(');
        }
        if (exprent.type == 3) {
            ((ConstExprent)exprent).adjustConstType(leftType);
        }
        buffer.append(exprent.toJava(indent, tracer));
        if (quote) {
            buffer.append(')');
        }
        return cast;
    }

    private static boolean isIntConstant(Exprent exprent) {
        if (exprent.type == 3) {
            switch (((ConstExprent)exprent).getConstType().getType()) {
                case 0: 
                case 4: 
                case 6: 
                case 15: 
                case 16: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isNarrowedIntType(VarType type) {
        return VarType.VARTYPE_INT.isStrictSuperset(type) || type.equals(VarType.VARTYPE_BYTE_OBJ) || type.equals(VarType.VARTYPE_SHORT_OBJ);
    }

    private static boolean lambdaNeedsCast(VarType left, NewExprent exprent) {
        if (exprent.isLambda() && !exprent.isMethodReference()) {
            StructClass cls = DecompilerContext.getStructContext().getClass(left.getValue());
            return cls == null || cls.getMethod(exprent.getLambdaMethodKey()) == null;
        }
        return false;
    }
}

