/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.accessibilityAudit;

import com.intellij.internal.inspector.accessibilityAudit.AccessibilityAudit;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleActionNotNullInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleEditableTextNotNullInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleNameAndDescriptionNotEqualInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleNameNotEmptyForFocusableComponentsInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleNameNotEmptyForIcon;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleStateSetContainsFocusableInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleTextNotNullInspection;
import com.intellij.internal.inspector.accessibilityAudit.AccessibleValueNotNullInspection;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/inspector/accessibilityAudit/AccessibilityAuditManager;", "Lcom/intellij/internal/inspector/accessibilityAudit/AccessibilityAudit;", "<init>", "()V", "failedInspections", "", "Lcom/intellij/internal/inspector/accessibilityAudit/UiInspectorAccessibilityInspection;", "getFailedInspections", "()Ljava/util/List;", "value", "", "isRunning", "()Z", "runAccessibilityTests", "", "ac", "Ljavax/accessibility/AccessibleContext;", "clearAccessibilityTestsResult", "intellij.platform.ide.ui.inspector"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class AccessibilityAuditManager
implements AccessibilityAudit {
    @NotNull
    private final List<UiInspectorAccessibilityInspection> failedInspections = new ArrayList();
    private boolean isRunning;

    @Override
    @NotNull
    public List<UiInspectorAccessibilityInspection> getFailedInspections() {
        return this.failedInspections;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void runAccessibilityTests(@NotNull AccessibleContext ac) {
        Intrinsics.checkNotNullParameter((Object)ac, (String)"ac");
        this.isRunning = true;
        this.getFailedInspections().clear();
        UiInspectorAccessibilityInspection[] uiInspectorAccessibilityInspectionArray = new UiInspectorAccessibilityInspection[]{new AccessibleActionNotNullInspection(), new AccessibleEditableTextNotNullInspection(), new AccessibleNameAndDescriptionNotEqualInspection(), new AccessibleNameNotEmptyForFocusableComponentsInspection(), new AccessibleNameNotEmptyForIcon(), new AccessibleStateSetContainsFocusableInspection(), new AccessibleTextNotNullInspection(), new AccessibleValueNotNullInspection()};
        List inspections = CollectionsKt.listOf((Object[])uiInspectorAccessibilityInspectionArray);
        for (UiInspectorAccessibilityInspection inspection : inspections) {
            if (inspection.passesInspection(ac)) continue;
            this.getFailedInspections().add(inspection);
        }
    }

    @Override
    public void clearAccessibilityTestsResult() {
        this.isRunning = false;
        this.getFailedInspections().clear();
    }
}

