/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/resolve/AppendResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public final class AppendResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Intrinsics.checkNotNull(valuesBefore);
        Iterable iterable = valuesBefore;
        Intrinsics.checkNotNull(valuesAfter);
        for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)valuesAfter)) {
            TraceElement before = (TraceElement)pair.component1();
            TraceElement after = (TraceElement)pair.component2();
            Map map = direct;
            Object object = new TraceElement[]{after};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(before, object);
            map = reverse;
            object = new TraceElement[]{before};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(after, object);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"of(...)");
        return result;
    }
}

