/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020!J\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020!J\u0006\u0010&\u001a\u00020!J\u0013\u0010'\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "receiver", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "getProperty", "()Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getReceiver", "()Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "_parameters", "", "Lkotlin/reflect/KParameter;", "_returnType", "Lkotlin/reflect/KType;", "convertGetterToKFunctionState", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getParameters", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getReturnType", "isKProperty0", "", "isKProperty1", "isKProperty2", "isKMutableProperty0", "isKMutableProperty1", "isKMutableProperty2", "equals", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nKPropertyState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KPropertyState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class KPropertyState
extends ReflectionState {
    @NotNull
    private final IrProperty property;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private final State receiver;
    @Nullable
    private List<? extends KParameter> _parameters;
    @Nullable
    private KType _returnType;

    public KPropertyState(@NotNull IrProperty property, @NotNull IrClass irClass, @Nullable State receiver) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.property = property;
        this.irClass = irClass;
        this.receiver = receiver;
    }

    public /* synthetic */ KPropertyState(IrProperty irProperty, IrClass irClass, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            state = null;
        }
        this(irProperty, irClass, state);
    }

    @NotNull
    public final IrProperty getProperty() {
        return this.property;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Nullable
    public final State getReceiver() {
        return this.receiver;
    }

    public KPropertyState(@NotNull IrPropertyReference propertyReference, @Nullable State receiver) {
        Intrinsics.checkNotNullParameter((Object)propertyReference, (String)"propertyReference");
        IrProperty irProperty = (IrProperty)((IrPropertySymbol)propertyReference.getSymbol()).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(propertyReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(irProperty, (IrClass)irClassSymbol.getOwner(), receiver);
    }

    @NotNull
    public final KFunctionState convertGetterToKFunctionState(@NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        return new KFunctionState(irSimpleFunction, environment.getIrBuiltIns().functionN(1), environment, null, 8, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<KParameter> getParameters(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._parameters != null) {
            v0 = this._parameters;
            Intrinsics.checkNotNull(v0);
            return v0;
        }
        kParameterIrClass = (IrClass)callInterceptor.getEnvironment().getKParameterClass$ir_interpreter().getOwner();
        index = 0;
        var5_4 = this.property.getGetter();
        if (var5_4 == null || (var6_5 = var5_4.getDispatchReceiverParameter()) == null) ** GOTO lbl-1000
        it = var8_6 = var6_5;
        $i$a$-takeIf-KPropertyState$getParameters$instanceParameter$1 = false;
        v1 = var7_9 = this.receiver == null != false ? var8_6 : null;
        if (var7_9 != null) {
            it = var7_9;
            $i$a$-let-KPropertyState$getParameters$instanceParameter$2 = false;
            var11_10 = index;
            index = var11_10 + 1;
            v2 = new KParameterProxy(new KParameterState(kParameterIrClass, it, var11_10, KParameter.Kind.INSTANCE), callInterceptor);
            v3 = v2;
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        instanceParameter = v3;
        var6_5 = this.property.getGetter();
        if (var6_5 != null && (var7_9 = var6_5.getExtensionReceiverParameter()) != null) {
            it = var7_9;
            $i$a$-let-KPropertyState$getParameters$extensionParameter$1 = false;
            var11_10 = index;
            index = var11_10 + 1;
            v4 = new KParameterProxy(new KParameterState(kParameterIrClass, it, var11_10, KParameter.Kind.EXTENSION_RECEIVER), callInterceptor);
            v5 = v4;
        } else {
            v5 = null;
        }
        extensionParameter = v5;
        var6_5 = new KParameterProxy[]{instanceParameter, extensionParameter};
        this._parameters = CollectionsKt.listOfNotNull((Object[])var6_5);
        v6 = this._parameters;
        Intrinsics.checkNotNull(v6);
        return v6;
    }

    @NotNull
    public final KType getReturnType(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._returnType != null) {
            KType kType = this._returnType;
            Intrinsics.checkNotNull((Object)kType);
            return kType;
        }
        IrClass kTypeIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeClass$ir_interpreter().getOwner();
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        KType kType = this._returnType = (KType)new KTypeProxy(new KTypeState(irSimpleFunction.getReturnType(), kTypeIrClass), callInterceptor);
        Intrinsics.checkNotNull((Object)kType);
        return kType;
    }

    public final boolean isKProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty0");
    }

    public final boolean isKProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty1");
    }

    public final boolean isKProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty2");
    }

    public final boolean isKMutableProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty0");
    }

    public final boolean isKMutableProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty1");
    }

    public final boolean isKMutableProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty2");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState");
        KPropertyState cfr_ignored_0 = (KPropertyState)other;
        if (!Intrinsics.areEqual((Object)this.property, (Object)((KPropertyState)other).property)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.receiver, (Object)((KPropertyState)other).receiver);
    }

    public int hashCode() {
        int result = this.property.hashCode();
        State state = this.receiver;
        result = 31 * result + (state != null ? state.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return this.renderProperty(this.property);
    }
}

