/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.preimport;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.preimport.MavenProjectData;
import org.jetbrains.idea.maven.project.preimport.ProjectTree;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/jetbrains/idea/maven/project/preimport/StatisticsData;", "", "project", "Lcom/intellij/openapi/project/Project;", "rootProjects", "", "<init>", "(Lcom/intellij/openapi/project/Project;I)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRootProjects", "()I", "modulesBefore", "getModulesBefore", "add", "", "forest", "", "Lorg/jetbrains/idea/maven/project/preimport/ProjectTree;", "allProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "linkedProject", "getLinkedProject", "setLinkedProject", "(I)V", "resolvedDependencies", "getResolvedDependencies", "setResolvedDependencies", "totalDependencies", "getTotalDependencies", "setTotalDependencies", "totalProjects", "getTotalProjects", "setTotalProjects", "addedModules", "getAddedModules", "setAddedModules", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectStaticImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectStaticImporter.kt\norg/jetbrains/idea/maven/project/preimport/StatisticsData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,753:1\n1368#2:754\n1454#2,5:755\n1368#2:761\n1454#2,5:762\n1#3:760\n*S KotlinDebug\n*F\n+ 1 MavenProjectStaticImporter.kt\norg/jetbrains/idea/maven/project/preimport/StatisticsData\n*L\n644#1:754\n644#1:755,5\n645#1:761\n645#1:762,5\n*E\n"})
final class StatisticsData {
    @NotNull
    private final Project project;
    private final int rootProjects;
    private final int modulesBefore;
    private int linkedProject;
    private int resolvedDependencies;
    private int totalDependencies;
    private int totalProjects;
    private int addedModules;

    public StatisticsData(@NotNull Project project, int rootProjects) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rootProjects = rootProjects;
        ImmutableEntityStorage immutableEntityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        Intrinsics.checkNotNull((Object)immutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation");
        this.modulesBefore = ((ImmutableEntityStorageInstrumentation)immutableEntityStorage).entityCount(ModuleEntity.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final int getRootProjects() {
        return this.rootProjects;
    }

    public final int getModulesBefore() {
        return this.modulesBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void add(@NotNull List<ProjectTree> forest, @NotNull List<MavenProject> allProjects) {
        Intrinsics.checkNotNullParameter(forest, (String)"forest");
        Intrinsics.checkNotNullParameter(allProjects, (String)"allProjects");
        long time = System.currentTimeMillis();
        try {
            int n;
            int n2;
            Iterable list$iv$iv;
            ProjectTree it;
            Object element$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            this.linkedProject = forest.size();
            Iterable iterable = forest;
            StatisticsData statisticsData = this;
            int $i$f$flatMap = 0;
            Iterator iterator = $this$flatMap$iv;
            Collection<Object> destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (ProjectTree)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.projectsData();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$flatMap = 0;
            for (Collection<Object> destination$iv$iv2 : $this$flatMap$iv) {
                void it2;
                MavenProjectData $i$f$flatMapTo2 = (MavenProjectData)((Object)destination$iv$iv2);
                n2 = $i$f$flatMap;
                boolean bl = false;
                n = it2.getResolvedDependencies().size();
                $i$f$flatMap = n2 + n;
            }
            statisticsData.resolvedDependencies = n2 = $i$f$flatMap;
            $this$flatMap$iv = forest;
            statisticsData = this;
            $i$f$flatMap = 0;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo2 = false;
            Iterator bl = $this$flatMapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                it = (ProjectTree)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.projectsData();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            iterable = (List)destination$iv$iv2;
            int n3 = 0;
            for (Object t : iterable) {
                void it3;
                MavenProjectData $i$f$flatMapTo3 = (MavenProjectData)t;
                n2 = n3;
                boolean bl3 = false;
                n = it3.getDeclaredDependencies().size();
                n3 = n2 + n;
            }
            statisticsData.totalDependencies = n2 = n3;
            ImmutableEntityStorage immutableEntityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
            Intrinsics.checkNotNull((Object)immutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation");
            this.addedModules = ((ImmutableEntityStorageInstrumentation)immutableEntityStorage).entityCount(ModuleEntity.class) - this.modulesBefore;
            this.totalProjects = allProjects.size();
        }
        finally {
            MavenLog.LOG.info("preimport statistics: linked: " + this.linkedProject + " of " + this.rootProjects + " with total " + this.totalProjects + " modules interpolated " + this.resolvedDependencies + " of " + this.totalDependencies + ", " + this.addedModules + " modules added. This statistics calculated for " + (System.currentTimeMillis() - time) + " millis");
        }
    }

    public final int getLinkedProject() {
        return this.linkedProject;
    }

    public final void setLinkedProject(int n) {
        this.linkedProject = n;
    }

    public final int getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public final void setResolvedDependencies(int n) {
        this.resolvedDependencies = n;
    }

    public final int getTotalDependencies() {
        return this.totalDependencies;
    }

    public final void setTotalDependencies(int n) {
        this.totalDependencies = n;
    }

    public final int getTotalProjects() {
        return this.totalProjects;
    }

    public final void setTotalProjects(int n) {
        this.totalProjects = n;
    }

    public final int getAddedModules() {
        return this.addedModules;
    }

    public final void setAddedModules(int n) {
        this.addedModules = n;
    }
}

