/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.FilePosition;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenEventHandler;
import org.jetbrains.idea.maven.buildtool.MessageEventUtilsKt;
import org.jetbrains.idea.maven.buildtool.quickfix.MavenFullSyncQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OffMavenOfflineModeQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.quickfixes.DownloadArtifactBuildIssue;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0081\u00012\u00020\u0001:\u0002\u0081\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\fJ\r\u0010#\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\u000b\u0010$\u001a\u00070\t\u00a2\u0006\u0002\b\nJ\u0010\u0010%\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u0013J\u0018\u0010%\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\fJ\u0010\u0010(\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u0013J\"\u0010%\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001f2\b\b\u0001\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\fH\u0002J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u00132\b\b\u0001\u0010.\u001a\u00020\u0013J\u0016\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J$\u0010-\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u00132\b\b\u0001\u0010.\u001a\u00020\u00132\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0013H\u0002J\u0010\u00108\u001a\u00020\u001a2\b\b\u0002\u00109\u001a\u00020\fJ\u000e\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<H\u0002J\u0006\u0010>\u001a\u00020\u001aJ\u0012\u0010?\u001a\u00020\u001a2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010AJ\u000e\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020GJ\f\u0010H\u001a\u000205*\u00020GH\u0002J\u001a\u0010I\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<\u0018\u00010\u001e*\u00020GH\u0002J\u001a\u0010J\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<\u0018\u00010\u001e*\u00020GH\u0002J,\u0010K\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<\u0018\u00010\u001e*\u00020G2\b\u0010L\u001a\u0004\u0018\u00010\u00132\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010O\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020A2\u0006\u0010P\u001a\u00020\u0007H\u0007J\u0010\u0010O\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020AH\u0007J\u0010\u0010Q\u001a\u00020\u00132\u0006\u0010R\u001a\u00020SH\u0002J\u0012\u0010T\u001a\u00020\u001a2\b\b\u0002\u00109\u001a\u00020\fH\u0002J\b\u0010U\u001a\u00020\u001aH\u0002J\b\u0010V\u001a\u00020\u001aH\u0002J\"\u0010W\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020\u00132\b\u0010Z\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010W\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u00132\b\u0010Z\u001a\u0004\u0018\u00010\u0013J\u000e\u0010[\u001a\u00020\u001a2\u0006\u0010\\\u001a\u000201J\u0016\u0010[\u001a\u00020\u001a2\u0006\u0010\\\u001a\u0002012\u0006\u00102\u001a\u000203J\u001a\u0010]\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001f2\b\b\u0001\u0010^\u001a\u00020\u0013H\u0002J\"\u0010_\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001f2\b\b\u0001\u0010^\u001a\u00020\u00132\u0006\u0010`\u001a\u00020aH\u0002J\u0006\u0010b\u001a\u00020\u001aJ\u0006\u0010c\u001a\u00020\u001aJ\u0010\u0010d\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u0013H\u0002J\u0018\u0010e\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020\u0013H\u0002J\u0018\u0010f\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020\u0013H\u0002J0\u0010g\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u00132\b\b\u0001\u0010Y\u001a\u00020\u00132\b\b\u0001\u0010h\u001a\u00020\u00132\n\b\u0001\u0010i\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010j\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\u0013H\u0002J\u0017\u0010k\u001a\u00020\u001a2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0082\bJ\u0016\u0010m\u001a\u00020\u001a2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\b\u0010n\u001a\u00020\u001aH\u0007J\u0010\u0010o\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\fH\u0007J\u0016\u0010p\u001a\u00020\u001a2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020s0rH\u0016J\u0016\u0010t\u001a\u00020\u001a2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020v0rH\u0016J\"\u0010w\u001a\u00020\u001a2\u0006\u0010x\u001a\u00020<2\u0006\u0010y\u001a\u00020\u00132\b\u0010z\u001a\u0004\u0018\u00010AH\u0002J\u001a\u0010{\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\u00132\u0006\u0010R\u001a\u00020|H\u0002J\u0010\u0010}\u001a\u00020\f2\u0006\u0010x\u001a\u00020<H\u0002J\u001a\u0010~\u001a\u00020\u00132\u0006\u0010x\u001a\u00020<2\b\u0010\u007f\u001a\u0004\u0018\u00010\u0013H\u0002J\u0013\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00132\u0006\u0010x\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0015j\b\u0012\u0004\u0012\u00020\u0013`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00130\u001e0\u001dj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00130\u001e` X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "Lorg/jetbrains/idea/maven/buildtool/MavenEventHandler;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mySyncView", "Lcom/intellij/build/BuildProgressListener;", "mySyncId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "finished", "", "started", "syncTransactionStarted", "hasErrors", "hasUnresolved", "JAVADOC_AND_SOURCE_CLASSIFIERS", "", "", "shownIssues", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "myPostponed", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "", "Lkotlin/collections/LinkedHashSet;", "startImport", "explicit", "createTaskId", "getTaskId", "addText", "text", "stdout", "addWrapperProgressText", "parentId", "addBuildEvent", "buildEvent", "Lcom/intellij/build/events/BuildEvent;", "addWarning", "description", "addBuildIssue", "issue", "Lcom/intellij/build/issue/BuildIssue;", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "filePosition", "Lcom/intellij/build/FilePosition;", "newIssue", "s", "finishImport", "showFullSyncQuickFix", "terminated", "exitCode", "", "doTerminate", "startWrapperResolving", "finishWrapperResolving", "e", "", "notifyReadingProblems", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showProblem", "problem", "Lorg/jetbrains/idea/maven/model/MavenProjectProblem;", "getFilePosition", "getPositionFromDescription", "getPositionFromPath", "getPosition", "source", "pattern", "Lkotlin/text/Regex;", "addException", "ignoredProgressListener", "getKeyPrefix", "type", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleIndicator$ResolveType;", "doFinish", "attachFullSyncQuickFix", "attachOfflineQuickFix", "showArtifactBuildIssue", "keyPrefix", "dependency", "errorMessage", "showBuildIssue", "buildIssue", "startTask", "taskName", "completeTask", "result", "Lcom/intellij/build/events/EventResult;", "finishPluginResolution", "finishArtifactsDownload", "completeUmbrellaEvents", "downloadEventStarted", "downloadEventCompleted", "downloadEventFailed", "error", "stackTrace", "isJavadocOrSource", "doIfImportInProcess", "action", "doIfImportInProcessOrPostpone", "startTransaction", "finishTransaction", "handleDownloadEvents", "downloadEvents", "", "Lorg/jetbrains/idea/maven/server/MavenArtifactEvent;", "handleConsoleEvents", "consoleEvents", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleEvent;", "printMessage", "level", "string", "throwable", "doPrint", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$Companion$OutputType;", "isSuppressed", "composeLine", "message", "getPrefixByLevel", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenSyncConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenSyncConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsole\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n449#1,3:553\n449#1,3:557\n449#1,3:560\n449#1,3:563\n449#1,3:566\n449#1,3:569\n449#1,3:572\n449#1,3:577\n449#1,3:580\n449#1,3:585\n449#1,3:588\n449#1,3:591\n449#1,3:594\n449#1,3:597\n449#1,3:600\n449#1,3:603\n449#1,3:606\n449#1,3:609\n1863#2:552\n1864#2:556\n1863#2,2:575\n1863#2,2:583\n*S KotlinDebug\n*F\n+ 1 MavenSyncConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsole\n*L\n81#1:553,3\n93#1:557,3\n98#1:560,3\n103#1:563,3\n112#1:566,3\n127#1:569,3\n151#1:572,3\n193#1:577,3\n203#1:580,3\n325#1:585,3\n341#1:588,3\n350#1:591,3\n358#1:594,3\n367#1:597,3\n385#1:600,3\n391#1:603,3\n399#1:606,3\n411#1:609,3\n81#1:552\n81#1:556\n162#1:575,2\n283#1:583,2\n*E\n"})
public final class MavenSyncConsole
implements MavenEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final BuildProgressListener mySyncView;
    @NotNull
    private ExternalSystemTaskId mySyncId;
    private boolean finished;
    private boolean started;
    private boolean syncTransactionStarted;
    private boolean hasErrors;
    private boolean hasUnresolved;
    @NotNull
    private final Set<String> JAVADOC_AND_SOURCE_CLASSIFIERS;
    @NotNull
    private final HashSet<String> shownIssues;
    @NotNull
    private final ArrayList<Function0<Unit>> myPostponed;
    @NotNull
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    private static final int EXIT_CODE_OK;
    private static final int EXIT_CODE_SIGTERM;
    @NotNull
    private static final String LINE_SEPARATOR;
    @NotNull
    private static final Map<Integer, String> LEVEL_TO_PREFIX;

    public MavenSyncConsole(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        Object object = this.myProject.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.mySyncView = (BuildProgressListener)object;
        this.mySyncId = this.createTaskId();
        Object[] objectArray = new String[]{"javadoc", "sources", "test-javadoc", "test-sources"};
        this.JAVADOC_AND_SOURCE_CLASSIFIERS = SetsKt.setOf((Object[])objectArray);
        this.shownIssues = new HashSet();
        this.myPostponed = new ArrayList();
        this.myStartedSet = new LinkedHashSet();
    }

    public final synchronized void startImport(boolean explicit) {
        if (this.started) {
            return;
        }
        this.started = true;
        this.finished = false;
        this.hasErrors = false;
        this.hasUnresolved = false;
        this.shownIssues.clear();
        this.mySyncId = this.createTaskId();
        String string = SyncBundle.message("maven.sync.title", new Object[0]);
        String string2 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.mySyncId, string, string2, System.currentTimeMillis());
        descriptor2.setActivateToolWindowWhenFailed(explicit);
        descriptor2.setActivateToolWindowWhenAdded(false);
        descriptor2.setNavigateToError(explicit ? ThreeState.YES : ThreeState.NO);
        Object[] objectArray = new Object[]{this.myProject.getName()};
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, SyncBundle.message("maven.sync.project.title", objectArray)));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "maven sync: started importing " + this.myProject, null, 2, null);
        Iterable $this$forEach$iv = this.myPostponed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 p0 = (Function0)element$iv;
            boolean $i$f$startImport$stub_for_inlining = false;
            boolean bl = false;
            MavenSyncConsole this_$iv = this;
            boolean $i$f$doIfImportInProcess = false;
            if (!this_$iv.started || this_$iv.finished) continue;
            p0.invoke();
        }
        this.myPostponed.clear();
    }

    private final ExternalSystemTaskId createTaskId() {
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"create(...)");
        return externalSystemTaskId;
    }

    @NotNull
    public final ExternalSystemTaskId getTaskId() {
        return this.mySyncId;
    }

    public final void addText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addText(text, true);
    }

    public final synchronized void addText(@Nls @NotNull String text, boolean stdout) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.addText(this.mySyncId, text, true);
        }
    }

    public final synchronized void addWrapperProgressText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.addText(string, text, true);
        }
    }

    private final synchronized void addText(Object parentId, @Nls String text, boolean stdout) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            Object toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + "\n";
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new OutputBuildEventImpl(parentId, (String)toPrint, stdout));
        }
    }

    public final synchronized void addBuildEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.mySyncView.onEvent((Object)this.mySyncId, buildEvent);
        }
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.addWarning(text, description, null);
    }

    public final void addBuildIssue(@NotNull BuildIssue issue, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.doIfImportInProcessOrPostpone((Function0<Unit>)((Function0)() -> MavenSyncConsole.addBuildIssue$lambda$4(this, issue, kind)));
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description, @Nullable FilePosition filePosition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (!this.newIssue(text + description + filePosition)) {
                return;
            }
            if (filePosition == null) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description));
            } else {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description, filePosition));
            }
        }
    }

    private final boolean newIssue(String s) {
        return this.shownIssues.add(s);
    }

    public final synchronized void finishImport(boolean showFullSyncQuickFix) {
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: finishImport", null, 2, null);
        this.doFinish(showFullSyncQuickFix);
    }

    public static /* synthetic */ void finishImport$default(MavenSyncConsole mavenSyncConsole, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mavenSyncConsole.finishImport(bl);
    }

    public final void terminated(int exitCode) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (EXIT_CODE_OK == exitCode || EXIT_CODE_SIGTERM == exitCode) {
                MavenSyncConsole.doFinish$default(this, false, 1, null);
            } else {
                this.doTerminate(exitCode);
            }
        }
    }

    private final void doTerminate(int exitCode) {
        if (this.syncTransactionStarted) {
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: sync transaction is still not finished, postpone build finish event", null, 2, null);
            return;
        }
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{exitCode};
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", objectArray)));
        }
        Object[] objectArray = new Object[]{exitCode};
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", objectArray))));
        this.finished = true;
        this.started = false;
    }

    public final synchronized void startWrapperResolving() {
        if (!this.started || this.finished) {
            this.startImport(true);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.startTask(this.mySyncId, string);
    }

    public final synchronized void finishWrapperResolving(@Nullable Throwable e) {
        if (e != null) {
            this.addBuildIssue(new BuildIssue(e){
                private final String title;
                private final String description;
                private final List<BuildIssueQuickFix> quickFixes;
                {
                    String string = SyncBundle.message("maven.sync.wrapper.failure", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.title = string;
                    Object[] objectArray = new Object[]{$e.getLocalizedMessage(), "open_maven_settings_quick_fix"};
                    String string2 = SyncBundle.message("maven.sync.wrapper.failure.description", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.description = string2;
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
                }

                public String getTitle() {
                    return this.title;
                }

                public String getDescription() {
                    return this.description;
                }

                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                public Navigatable getNavigatable(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    return null;
                }
            }, MessageEvent.Kind.WARNING);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.completeTask(this.mySyncId, string, (EventResult)new SuccessResultImpl());
    }

    public static /* synthetic */ void finishWrapperResolving$default(MavenSyncConsole mavenSyncConsole, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        mavenSyncConsole.finishWrapperResolving(throwable);
    }

    public final synchronized void notifyReadingProblems(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "reading problems in " + file, null, 2, null);
            this.hasErrors = true;
            Object[] objectArray = new Object[]{file.getPath()};
            String desc = SyncBundle.message("maven.sync.failure.error.reading.file", objectArray);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), desc, desc, new FilePosition(new File(file.getPath()), -1, -1)));
        }
    }

    public final synchronized void showProblem(@NotNull MavenProjectProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String string;
            String message;
            boolean bl = false;
            this.hasErrors = true;
            String group = SyncBundle.message("maven.sync.group.error", new Object[0]);
            FilePosition position = this.getFilePosition(problem);
            String string2 = problem.getDescription();
            if (string2 == null) {
                string2 = message = SyncBundle.message("maven.sync.failure.error.undefined.message", new Object[0]);
            }
            if ((string = problem.getDescription()) == null) {
                Object[] objectArray = new Object[]{problem.getPath()};
                string = SyncBundle.message("maven.sync.failure.error.undefined.detailed.message", objectArray);
            }
            String detailedMessage = string;
            FileMessageEventImpl eventImpl = new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, group, message, detailedMessage, position);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)eventImpl);
        }
    }

    private final FilePosition getFilePosition(MavenProjectProblem $this$getFilePosition) {
        Pair pair = this.getPositionFromDescription($this$getFilePosition);
        if (pair == null && (pair = this.getPositionFromPath($this$getFilePosition)) == null) {
            pair = TuplesKt.to((Object)-1, (Object)-1);
        }
        Pair pair2 = pair;
        int line = ((Number)pair2.component1()).intValue();
        int column2 = ((Number)pair2.component2()).intValue();
        String string = $this$getFilePosition.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String pathWithoutPosition = StringsKt.substringBeforeLast$default((String)string, (String)(":" + (line + 1) + ":" + column2), null, (int)2, null);
        return new FilePosition(new File(pathWithoutPosition), line, column2);
    }

    private final Pair<Integer, Integer> getPositionFromDescription(MavenProjectProblem $this$getPositionFromDescription) {
        return this.getPosition($this$getPositionFromDescription, $this$getPositionFromDescription.getDescription(), new Regex("@(\\d+):(\\d+)"));
    }

    private final Pair<Integer, Integer> getPositionFromPath(MavenProjectProblem $this$getPositionFromPath) {
        return this.getPosition($this$getPositionFromPath, $this$getPositionFromPath.getPath(), new Regex(":(\\d+):(\\d+)"));
    }

    private final Pair<Integer, Integer> getPosition(MavenProjectProblem $this$getPosition, String source, Regex pattern) {
        if (source == null) {
            return null;
        }
        if ($this$getPosition.getType() == MavenProjectProblem.ProblemType.STRUCTURE) {
            Sequence matchResults = Regex.findAll$default((Regex)pattern, (CharSequence)source, (int)0, (int)2, null);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)matchResults);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            List list = matchResult2.getGroupValues();
            String line = (String)list.get(1);
            String offset = (String)list.get(2);
            return TuplesKt.to((Object)(Integer.parseInt(line) - 1), (Object)Integer.parseInt(offset));
        }
        return null;
    }

    @Deprecated(message="use {@link #addException(Throwable)}", replaceWith=@ReplaceWith(expression="addException(e)", imports={}))
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    public final synchronized void addException(@NotNull Throwable e, @NotNull BuildProgressListener ignoredProgressListener) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)ignoredProgressListener, (String)"ignoredProgressListener");
        this.addException(e);
    }

    @ApiStatus.Internal
    public final synchronized void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.started && !this.finished) {
            MavenLog.LOG.warn(e);
            this.hasErrors = true;
            BuildIssueException buildIssueException = (BuildIssueException)ExceptionUtil.findCause((Throwable)e, BuildIssueException.class);
            if (buildIssueException != null) {
                BuildIssue buildIssue2 = buildIssueException.getBuildIssue();
                Intrinsics.checkNotNullExpressionValue((Object)buildIssue2, (String)"<get-buildIssue>(...)");
                this.addBuildIssue(buildIssue2, MessageEvent.Kind.ERROR);
            } else {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)MessageEventUtilsKt.createMessageEvent(this.myProject, this.mySyncId, e));
            }
        } else {
            this.startImport(true);
            this.addException(e);
            MavenSyncConsole.finishImport$default(this, false, 1, null);
        }
    }

    private final String getKeyPrefix(MavenServerConsoleIndicator.ResolveType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> "maven.sync.plugins";
            case 2 -> "maven.sync.dependencies";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final synchronized void doFinish(boolean showFullSyncQuickFix) {
        if (this.syncTransactionStarted) {
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: sync transaction is still not finished, postpone build finish event", null, 2, null);
            return;
        }
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
        this.attachOfflineQuickFix();
        if (showFullSyncQuickFix) {
            this.attachFullSyncQuickFix();
        }
        this.finished = true;
        this.started = false;
    }

    static /* synthetic */ void doFinish$default(MavenSyncConsole mavenSyncConsole, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mavenSyncConsole.doFinish(bl);
    }

    private final void attachFullSyncQuickFix() {
        try {
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                private final String title;
                private final String description;
                private final List<BuildIssueQuickFix> quickFixes;
                {
                    this.title = "Sync Finished";
                    this.description = "Sync finished. If there is something wrong with the project model, <a href=\"maven_full_sync_quick_fix\">reload all projects</a>\n";
                    this.quickFixes = CollectionsKt.listOf((Object)new MavenFullSyncQuickFix());
                }

                public String getTitle() {
                    return this.title;
                }

                public String getDescription() {
                    return this.description;
                }

                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                public Navigatable getNavigatable(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    return null;
                }
            }, MessageEvent.Kind.INFO));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void attachOfflineQuickFix() {
        try {
            MavenGeneralSettings generalSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getGeneralSettings();
            if (this.hasUnresolved && generalSettings.isWorkOffline()) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                    private final String title;
                    private final String description;
                    private final List<BuildIssueQuickFix> quickFixes;
                    {
                        this.title = "Dependency Resolution Failed";
                        this.description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                        this.quickFixes = CollectionsKt.listOf((Object)new OffMavenOfflineModeQuickFix());
                    }

                    public String getTitle() {
                        return this.title;
                    }

                    public String getDescription() {
                        return this.description;
                    }

                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    public Navigatable getNavigatable(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return null;
                    }
                }, MessageEvent.Kind.ERROR));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final synchronized void showArtifactBuildIssue(String keyPrefix, String dependency, String errorMessage) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", objectArray);
            Intrinsics.checkNotNull((Object)umbrellaString);
            this.startTask(this.mySyncId, umbrellaString);
            Intrinsics.checkNotNull((Object)errorString);
            String string = errorMessage;
            if (string == null) {
                string = errorString;
            }
            BuildIssue buildIssue2 = DownloadArtifactBuildIssue.INSTANCE.getIssue(errorString, string);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)umbrellaString, buildIssue2, MessageEvent.Kind.ERROR));
            this.addText(this.mySyncId, errorString, false);
        }
    }

    public final void showArtifactBuildIssue(@NotNull MavenServerConsoleIndicator.ResolveType type, @NotNull String dependency, @Nullable String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.showArtifactBuildIssue(this.getKeyPrefix(type), dependency, errorMessage);
    }

    public final synchronized void showBuildIssue(@NotNull BuildIssue buildIssue2) {
        Intrinsics.checkNotNullParameter((Object)buildIssue2, (String)"buildIssue");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String key = this.getKeyPrefix(MavenServerConsoleIndicator.ResolveType.DEPENDENCY);
            this.startTask(this.mySyncId, key);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)key, buildIssue2, MessageEvent.Kind.ERROR));
        }
    }

    public final synchronized void showBuildIssue(@NotNull BuildIssue buildIssue2, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)buildIssue2, (String)"buildIssue");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || kind == MessageEvent.Kind.ERROR;
            String key = this.getKeyPrefix(MavenServerConsoleIndicator.ResolveType.DEPENDENCY);
            this.startTask(this.mySyncId, key);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)key, buildIssue2, kind));
        }
    }

    private final synchronized void startTask(Object parentId, @NlsSafe String taskName) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: start " + taskName, null, 2, null);
            if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName));
            }
        }
    }

    private final synchronized void completeTask(Object parentId, @NlsSafe String taskName, EventResult result2) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || result2 instanceof FailureResultImpl;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: complete " + taskName + " with " + result2, null, 2, null);
            if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName, result2));
            }
        }
    }

    public final void finishPluginResolution() {
        this.completeUmbrellaEvents(this.getKeyPrefix(MavenServerConsoleIndicator.ResolveType.PLUGIN));
    }

    public final void finishArtifactsDownload() {
        this.completeUmbrellaEvents(this.getKeyPrefix(MavenServerConsoleIndicator.ResolveType.DEPENDENCY));
    }

    private final synchronized void completeUmbrellaEvents(String keyPrefix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String taskName = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Intrinsics.checkNotNull((Object)taskName);
            this.completeTask(this.mySyncId, taskName, (EventResult)new DerivedResultImpl());
        }
    }

    private final synchronized void downloadEventStarted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            Intrinsics.checkNotNull((Object)downloadString);
            this.startTask(this.mySyncId, downloadString);
            Intrinsics.checkNotNull((Object)downloadArtifactString);
            this.startTask(downloadString, downloadArtifactString);
        }
    }

    private final synchronized void downloadEventCompleted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            Intrinsics.checkNotNull((Object)downloadArtifactString);
            this.addText(downloadArtifactString, downloadArtifactString, true);
            Intrinsics.checkNotNull((Object)downloadString);
            this.completeTask(downloadString, downloadArtifactString, (EventResult)new SuccessResultImpl(false));
        }
    }

    private final synchronized void downloadEventFailed(String keyPrefix, @NlsSafe String dependency, @NlsSafe String error, @NlsSafe String stackTrace) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            if (this.isJavadocOrSource(dependency)) {
                Intrinsics.checkNotNull((Object)downloadArtifactString);
                Object[] objectArray2 = new Object[]{dependency};
                String string = SyncBundle.message("maven.sync.failure.dependency.not.found", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.addText(downloadArtifactString, string, true);
                Intrinsics.checkNotNull((Object)downloadString);
                this.completeTask(downloadString, downloadArtifactString, (EventResult)new MessageEventResult(dependency){
                    final /* synthetic */ String $dependency;
                    {
                        this.$dependency = $dependency;
                    }

                    public MessageEvent.Kind getKind() {
                        return MessageEvent.Kind.WARNING;
                    }

                    public String getDetails() {
                        Object[] objectArray = new Object[]{this.$dependency};
                        return SyncBundle.message("maven.sync.failure.dependency.not.found", objectArray);
                    }
                });
            } else {
                if (stackTrace != null && Registry.Companion.is("maven.spy.events.debug")) {
                    Intrinsics.checkNotNull((Object)downloadArtifactString);
                    this.addText(downloadArtifactString, stackTrace, false);
                } else {
                    Intrinsics.checkNotNull((Object)downloadArtifactString);
                    this.addText(downloadArtifactString, error, true);
                }
                Intrinsics.checkNotNull((Object)downloadString);
                this.completeTask(downloadString, downloadArtifactString, (EventResult)new FailureResultImpl(error));
            }
        }
    }

    private final boolean isJavadocOrSource(String dependency) {
        char[] cArray = new char[]{':'};
        List split = StringsKt.split$default((CharSequence)dependency, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 4) {
            return false;
        }
        String classifier = (String)split.get(2);
        return this.JAVADOC_AND_SOURCE_CLASSIFIERS.contains(classifier);
    }

    private final void doIfImportInProcess(Function0<Unit> action) {
        boolean $i$f$doIfImportInProcess = false;
        if (!this.started || this.finished) {
            return;
        }
        action.invoke();
    }

    private final void doIfImportInProcessOrPostpone(Function0<Unit> action) {
        if (!this.started || this.finished) {
            this.myPostponed.add(action);
        } else {
            action.invoke();
        }
    }

    @ApiStatus.Experimental
    public final synchronized void startTransaction() {
        this.syncTransactionStarted = true;
    }

    @ApiStatus.Experimental
    public final synchronized void finishTransaction(boolean showFullSyncQuickFix) {
        this.syncTransactionStarted = false;
        this.finishImport(showFullSyncQuickFix);
    }

    @Override
    public synchronized void handleDownloadEvents(@NotNull List<? extends MavenArtifactEvent> downloadEvents) {
        Intrinsics.checkNotNullParameter(downloadEvents, (String)"downloadEvents");
        block5: for (MavenArtifactEvent mavenArtifactEvent : downloadEvents) {
            MavenServerConsoleIndicator.ResolveType resolveType = mavenArtifactEvent.getResolveType();
            Intrinsics.checkNotNullExpressionValue((Object)resolveType, (String)"getResolveType(...)");
            String key = this.getKeyPrefix(resolveType);
            String id = mavenArtifactEvent.getDependencyId();
            switch (WhenMappings.$EnumSwitchMapping$1[mavenArtifactEvent.getArtifactEventType().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)id);
                    this.downloadEventStarted(key, id);
                    continue block5;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)id);
                    this.downloadEventCompleted(key, id);
                    continue block5;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)id);
                    String string = mavenArtifactEvent.getErrorMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorMessage(...)");
                    this.downloadEventFailed(key, id, string, mavenArtifactEvent.getStackTrace());
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void handleConsoleEvents(@NotNull List<? extends MavenServerConsoleEvent> consoleEvents) {
        Intrinsics.checkNotNullParameter(consoleEvents, (String)"consoleEvents");
        for (MavenServerConsoleEvent mavenServerConsoleEvent : consoleEvents) {
            int n = mavenServerConsoleEvent.getLevel();
            String string = mavenServerConsoleEvent.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            this.printMessage(n, string, mavenServerConsoleEvent.getThrowable());
        }
    }

    private final void printMessage(int level, String string, Throwable throwable) {
        if (this.isSuppressed(level)) {
            return;
        }
        Companion.OutputType type = Companion.OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type = Companion.OutputType.ERROR;
        }
        this.doPrint(this.composeLine(level, string), type);
        if (throwable != null) {
            String string2 = ExceptionUtil.getThrowableText((Throwable)throwable);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
            String throwableText = string2;
            if (Registry.Companion.is("maven.print.import.stacktraces") || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doPrint(LINE_SEPARATOR + this.composeLine(3, throwableText), type);
            } else {
                this.doPrint(LINE_SEPARATOR + this.composeLine(3, throwable.getMessage()), type);
            }
        }
    }

    private final void doPrint(@NlsSafe String text, Companion.OutputType type) {
        this.addText(text, type == Companion.OutputType.NORMAL);
    }

    private final boolean isSuppressed(int level) {
        return level < MavenProjectsManager.getInstance(this.myProject).getGeneralSettings().getOutputLevel().getLevel();
    }

    private final String composeLine(int level, String message) {
        Object[] objectArray = new Object[]{this.getPrefixByLevel(level), message};
        String string = MessageFormat.format("[{0}] {1}", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String getPrefixByLevel(int level) {
        return LEVEL_TO_PREFIX.get(level);
    }

    private static final Unit addBuildIssue$lambda$4(MavenSyncConsole this$0, BuildIssue $issue, MessageEvent.Kind $kind) {
        if (!this$0.newIssue($issue.getTitle() + $issue.getDescription())) {
            return Unit.INSTANCE;
        }
        this$0.mySyncView.onEvent((Object)this$0.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this$0.mySyncId, $issue, $kind));
        this$0.hasErrors = this$0.hasErrors || $kind == MessageEvent.Kind.ERROR;
        return Unit.INSTANCE;
    }

    static {
        EXIT_CODE_SIGTERM = 143;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        LINE_SEPARATOR = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)"DEBUG"), TuplesKt.to((Object)1, (Object)"INFO"), TuplesKt.to((Object)2, (Object)"WARNING"), TuplesKt.to((Object)3, (Object)"ERROR"), TuplesKt.to((Object)4, (Object)"FATAL_ERROR")};
        LEVEL_TO_PREFIX = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$Companion;", "", "<init>", "()V", "EXIT_CODE_OK", "", "getEXIT_CODE_OK", "()I", "EXIT_CODE_SIGTERM", "getEXIT_CODE_SIGTERM", "LINE_SEPARATOR", "", "LEVEL_TO_PREFIX", "", "debugLog", "", "s", "exception", "", "OutputType", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public final int getEXIT_CODE_OK() {
            return EXIT_CODE_OK;
        }

        public final int getEXIT_CODE_SIGTERM() {
            return EXIT_CODE_SIGTERM;
        }

        private final void debugLog(String s, Throwable exception) {
            MavenLog.LOG.debug(s, exception);
        }

        static /* synthetic */ void debugLog$default(Companion companion, String string, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            companion.debugLog(string, throwable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$Companion$OutputType;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "ERROR", "intellij.maven"})
        private static final class OutputType
        extends Enum<OutputType> {
            public static final /* enum */ OutputType NORMAL = new OutputType();
            public static final /* enum */ OutputType ERROR = new OutputType();
            private static final /* synthetic */ OutputType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static OutputType[] values() {
                return (OutputType[])$VALUES.clone();
            }

            public static OutputType valueOf(String value) {
                return Enum.valueOf(OutputType.class, value);
            }

            @NotNull
            public static EnumEntries<OutputType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = outputTypeArray = new OutputType[]{OutputType.NORMAL, OutputType.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MavenServerConsoleIndicator.ResolveType.values().length];
            try {
                nArray[MavenServerConsoleIndicator.ResolveType.PLUGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenServerConsoleIndicator.ResolveType.DEPENDENCY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MavenArtifactEvent.ArtifactEventType.values().length];
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

