/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.ProfilerDumpManager;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u0006\u0010 \u001a\u00020\u0019J\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0019J\t\u0010#\u001a\u00020\u0003H\u00c2\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010(\u001a\u00020\rH\u00c2\u0003JG\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "time", "Ljava/util/Date;", "file", "Ljava/io/File;", "parserProvider", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "openCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Date;Ljava/io/File;Lcom/intellij/profiler/api/ProfilerDumpParserProvider;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getName", "()Ljava/lang/String;", "getTime", "()Ljava/util/Date;", "getFile", "()Ljava/io/File;", "getParserProvider", "()Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "open", "", "onComplete", "Ljava/lang/Runnable;", "isClosed", "", "isClosed$intellij_profiler_common", "()Z", "markOpened", "release", "remove", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.profiler.common"})
public final class ProfilerDumpDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final Date time;
    @NotNull
    private final File file;
    @Nullable
    private final ProfilerDumpParserProvider parserProvider;
    @NotNull
    private AtomicInteger openCounter;

    public ProfilerDumpDescriptor(@NotNull Project project, @NlsSafe @NotNull String name, @NotNull Date time, @NotNull File file, @Nullable ProfilerDumpParserProvider parserProvider, @NotNull AtomicInteger openCounter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)openCounter, (String)"openCounter");
        this.project = project;
        this.name = name;
        this.time = time;
        this.file = file;
        this.parserProvider = parserProvider;
        this.openCounter = openCounter;
    }

    public /* synthetic */ ProfilerDumpDescriptor(Project project, String string, Date date, File file, ProfilerDumpParserProvider profilerDumpParserProvider, AtomicInteger atomicInteger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            atomicInteger = new AtomicInteger(1);
        }
        this(project, string, date, file, profilerDumpParserProvider, atomicInteger);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Date getTime() {
        return this.time;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final ProfilerDumpParserProvider getParserProvider() {
        return this.parserProvider;
    }

    @JvmOverloads
    public final void open(@Nullable Runnable onComplete) {
        ImportProfilerResultAction.Companion.importProfilerDump$default(ImportProfilerResultAction.Companion, this.project, this, onComplete, null, 8, null);
    }

    public static /* synthetic */ void open$default(ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            runnable = null;
        }
        profilerDumpDescriptor.open(runnable);
    }

    public final boolean isClosed$intellij_profiler_common() {
        return this.openCounter.get() <= 0;
    }

    public final void markOpened() {
        this.openCounter.incrementAndGet();
    }

    public final void release() {
        this.openCounter.updateAndGet(ProfilerDumpDescriptor::release$lambda$0);
        ProfilerDumpManager.Companion.getInstance(this.project).removeOldDumps$intellij_profiler_common();
    }

    public final void remove() {
        ProfilerDumpManager.Companion.getInstance(this.project).removeDump$intellij_profiler_common(this);
    }

    private final Project component1() {
        return this.project;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Date component3() {
        return this.time;
    }

    @NotNull
    public final File component4() {
        return this.file;
    }

    @Nullable
    public final ProfilerDumpParserProvider component5() {
        return this.parserProvider;
    }

    private final AtomicInteger component6() {
        return this.openCounter;
    }

    @NotNull
    public final ProfilerDumpDescriptor copy(@NotNull Project project, @NlsSafe @NotNull String name, @NotNull Date time, @NotNull File file, @Nullable ProfilerDumpParserProvider parserProvider, @NotNull AtomicInteger openCounter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)openCounter, (String)"openCounter");
        return new ProfilerDumpDescriptor(project, name, time, file, parserProvider, openCounter);
    }

    public static /* synthetic */ ProfilerDumpDescriptor copy$default(ProfilerDumpDescriptor profilerDumpDescriptor, Project project, String string, Date date, File file, ProfilerDumpParserProvider profilerDumpParserProvider, AtomicInteger atomicInteger, int n, Object object) {
        if ((n & 1) != 0) {
            project = profilerDumpDescriptor.project;
        }
        if ((n & 2) != 0) {
            string = profilerDumpDescriptor.name;
        }
        if ((n & 4) != 0) {
            date = profilerDumpDescriptor.time;
        }
        if ((n & 8) != 0) {
            file = profilerDumpDescriptor.file;
        }
        if ((n & 0x10) != 0) {
            profilerDumpParserProvider = profilerDumpDescriptor.parserProvider;
        }
        if ((n & 0x20) != 0) {
            atomicInteger = profilerDumpDescriptor.openCounter;
        }
        return profilerDumpDescriptor.copy(project, string, date, file, profilerDumpParserProvider, atomicInteger);
    }

    @NotNull
    public String toString() {
        return "ProfilerDumpDescriptor(project=" + this.project + ", name=" + this.name + ", time=" + this.time + ", file=" + this.file + ", parserProvider=" + this.parserProvider + ", openCounter=" + this.openCounter + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.time.hashCode();
        result2 = result2 * 31 + this.file.hashCode();
        result2 = result2 * 31 + (this.parserProvider == null ? 0 : this.parserProvider.hashCode());
        result2 = result2 * 31 + this.openCounter.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfilerDumpDescriptor)) {
            return false;
        }
        ProfilerDumpDescriptor profilerDumpDescriptor = (ProfilerDumpDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)profilerDumpDescriptor.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)profilerDumpDescriptor.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.time, (Object)profilerDumpDescriptor.time)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)profilerDumpDescriptor.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parserProvider, (Object)profilerDumpDescriptor.parserProvider)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.openCounter, (Object)profilerDumpDescriptor.openCounter);
    }

    @JvmOverloads
    public final void open() {
        ProfilerDumpDescriptor.open$default(this, null, 1, null);
    }

    private static final int release$lambda$0(int it) {
        return it > 0 ? it - 1 : 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/api/ProfilerDumpDescriptor$Companion;", "", "<init>", "()V", "fromFile", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "file", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProfilerDumpDescriptor fromFile(@NotNull File file, @NotNull Project project, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            FileTime time = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
            return new ProfilerDumpDescriptor(project, name, new Date(time.toMillis()), file, null, null, 32, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

