/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jt\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\b\b\u0000\u0010\u0011*\u00020\t\"\n\b\u0001\u0010\u0012*\u0004\u0018\u00010\t2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\n0\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\n0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016R(\u0010\u0006\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0006\b\u0000\u0012\u00020\t\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t0\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "totalCacheSize", "", "<init>", "(J)V", "sharedCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SharedCacheKey;", "", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "subCachesDescriptors", "Ljava/util/concurrent/atomic/AtomicReference;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SubCacheDescriptor;", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "valueReader", "Ljava/util/function/Function;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSizeHint", "", "totalReads", "totalReadsUncached", "totalEvicted", "SharedCacheKey", "SubCacheDescriptor", "CaffeineSharedCache", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,530:1\n24#2:531\n1#3:532\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider\n*L\n400#1:531\n*E\n"})
public final class SharedCaffeineIndexStorageCacheProvider
implements MapIndexStorageCacheProvider {
    @NotNull
    private final LoadingCache<SharedCacheKey<Object>, ChangeTrackingValueContainer<Object>> sharedCache;
    @NotNull
    private final AtomicReference<Int2ObjectMap<SubCacheDescriptor<? super Object, ? super Object>>> subCachesDescriptors;

    public SharedCaffeineIndexStorageCacheProvider(long totalCacheSize) {
        SharedCaffeineIndexStorageCacheProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SharedCaffeineIndexStorageCacheProvider.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        logger.info("Caffeine shared cache will be used for indexes (totalCacheSize: " + totalCacheSize + ')');
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(totalCacheSize).executor(SharedCaffeineIndexStorageCacheProvider::sharedCache$lambda$0).removalListener((arg_0, arg_1, arg_2) -> SharedCaffeineIndexStorageCacheProvider.sharedCache$lambda$3(this, arg_0, arg_1, arg_2)).build(arg_0 -> SharedCaffeineIndexStorageCacheProvider.sharedCache$lambda$5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "build(...)");
        this.sharedCache = loadingCache;
        this.subCachesDescriptors = new AtomicReference<Int2ObjectOpenHashMap<Int2ObjectMap<SubCacheDescriptor<? super Object, ? super Object>>>>(new Int2ObjectOpenHashMap());
    }

    public /* synthetic */ SharedCaffeineIndexStorageCacheProvider(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 262144L;
        }
        this(l);
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSizeHint) {
        int subCacheId;
        Int2ObjectOpenHashMap<SubCacheDescriptor<? super Object, ? super Object>> updatedDescriptors;
        Int2ObjectMap<SubCacheDescriptor<? super Object, ? super Object>> currentDescriptors;
        Intrinsics.checkNotNullParameter(valueReader, "valueReader");
        Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
        Intrinsics.checkNotNullParameter(hashingStrategy, "hashingStrategy");
        SubCacheDescriptor newDescriptor = new SubCacheDescriptor(valueReader, evictedValuesPersister, null, 4, null);
        do {
            if (!(!(updatedDescriptors = new Int2ObjectOpenHashMap<SubCacheDescriptor<? super Object, ? super Object>>(currentDescriptors = this.subCachesDescriptors.get())).containsKey(subCacheId = updatedDescriptors.size() + 1))) {
                boolean $i$a$-check-SharedCaffeineIndexStorageCacheProvider$createCache$22 = false;
                String $i$a$-check-SharedCaffeineIndexStorageCacheProvider$createCache$22 = "Cache with id=" + subCacheId + " already registered";
                throw new IllegalStateException($i$a$-check-SharedCaffeineIndexStorageCacheProvider$createCache$22.toString());
            }
            SharedCaffeineIndexStorageCacheProvider $this$createCache_u24lambda_u247 = this;
            boolean bl = false;
            Integer n = subCacheId;
            ((Map)updatedDescriptors).put(n, newDescriptor);
        } while (!this.subCachesDescriptors.compareAndSet(currentDescriptors, updatedDescriptors));
        CaffeineSharedCache caffeineSharedCache = new CaffeineSharedCache(subCacheId, newDescriptor, this.sharedCache, hashingStrategy);
        return caffeineSharedCache;
    }

    @Override
    public long totalReads() {
        return this.sharedCache.stats().requestCount();
    }

    @Override
    public long totalReadsUncached() {
        return this.sharedCache.stats().loadCount();
    }

    @Override
    public long totalEvicted() {
        return this.sharedCache.stats().evictionCount();
    }

    private static final void sharedCache$lambda$0(Runnable it) {
        it.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sharedCache$lambda$3(SharedCaffeineIndexStorageCacheProvider this$0, SharedCacheKey sharedCacheKey, ChangeTrackingValueContainer container, RemovalCause removalCause) {
        if (container != null && sharedCacheKey != null) {
            SubCacheDescriptor cacheInfo = (SubCacheDescriptor)this$0.subCachesDescriptors.get().get(sharedCacheKey.getSubCacheId());
            if (!(cacheInfo != null)) {
                boolean $i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$2$22 = false;
                String $i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$2$22 = "Cache registration info for " + sharedCacheKey + " not found";
                throw new IllegalStateException($i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$2$22.toString());
            }
            Lock lock = cacheInfo.getCacheAccessLock();
            lock.lock();
            try {
                boolean bl = false;
                cacheInfo.getEvictedValuesPersister().accept(sharedCacheKey.getKey(), container);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static final ChangeTrackingValueContainer sharedCache$lambda$5(SharedCaffeineIndexStorageCacheProvider this$0, SharedCacheKey sharedCacheKey) {
        SubCacheDescriptor cacheInfo = (SubCacheDescriptor)this$0.subCachesDescriptors.get().get(sharedCacheKey.getSubCacheId());
        if (!(cacheInfo != null)) {
            boolean $i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$3$22 = false;
            String $i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$3$22 = "Cache registration info for " + sharedCacheKey + " not found";
            throw new IllegalStateException($i$a$-check-SharedCaffeineIndexStorageCacheProvider$sharedCache$3$22.toString());
        }
        Function valueReader = cacheInfo.getValueReader();
        Object key = sharedCacheKey.getKey();
        return valueReader.apply(key);
    }

    public SharedCaffeineIndexStorageCacheProvider() {
        this(0L, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BS\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012 \u0010\t\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f0\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$CaffeineSharedCache;", "Key", "", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "cacheId", "", "subCacheDescriptor", "Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SubCacheDescriptor;", "sharedCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SharedCacheKey;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "equalityPolicy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "<init>", "(ILcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SubCacheDescriptor;Lcom/github/benmanes/caffeine/cache/LoadingCache;Lcom/intellij/util/containers/hash/EqualityPolicy;)V", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "getCachedValues", "", "invalidateAll", "", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$CaffeineSharedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,530:1\n774#2:531\n865#2,2:532\n1557#2:534\n1628#2,3:535\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$CaffeineSharedCache\n*L\n514#1:531\n514#1:532,2\n515#1:534\n515#1:535,3\n*E\n"})
    private static final class CaffeineSharedCache<Key, Value>
    implements MapIndexStorageCache<Key, Value> {
        private final int cacheId;
        @NotNull
        private final SubCacheDescriptor<Key, Value> subCacheDescriptor;
        @NotNull
        private final LoadingCache<SharedCacheKey<Object>, ChangeTrackingValueContainer<Object>> sharedCache;
        @NotNull
        private final EqualityPolicy<Key> equalityPolicy;

        public CaffeineSharedCache(int cacheId, @NotNull SubCacheDescriptor<Key, Value> subCacheDescriptor, @NotNull LoadingCache<SharedCacheKey<Object>, ChangeTrackingValueContainer<Object>> sharedCache, @NotNull EqualityPolicy<Key> equalityPolicy) {
            Intrinsics.checkNotNullParameter(subCacheDescriptor, "subCacheDescriptor");
            Intrinsics.checkNotNullParameter(sharedCache, "sharedCache");
            Intrinsics.checkNotNullParameter(equalityPolicy, "equalityPolicy");
            this.cacheId = cacheId;
            this.subCacheDescriptor = subCacheDescriptor;
            this.sharedCache = sharedCache;
            this.equalityPolicy = equalityPolicy;
        }

        @Override
        @NotNull
        public ChangeTrackingValueContainer<Value> read(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            Object object = this.sharedCache.get(new SharedCacheKey<Key>(key, this.cacheId, this.equalityPolicy));
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.intellij.util.indexing.impl.ChangeTrackingValueContainer<Value of com.intellij.util.indexing.impl.SharedCaffeineIndexStorageCacheProvider.CaffeineSharedCache>");
            return (ChangeTrackingValueContainer)object;
        }

        @Override
        @Nullable
        public ChangeTrackingValueContainer<Value> readIfCached(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return (ChangeTrackingValueContainer)this.sharedCache.getIfPresent(new SharedCacheKey<Key>(key, this.cacheId, this.equalityPolicy));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.sharedCache.asMap().entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((SharedCacheKey)it.getKey()).getSubCacheId() == this.cacheId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, "null cannot be cast to non-null type com.intellij.util.indexing.impl.ChangeTrackingValueContainer<Value of com.intellij.util.indexing.impl.SharedCaffeineIndexStorageCacheProvider.CaffeineSharedCache>");
                collection.add((ChangeTrackingValueContainer)v);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public void invalidateAll() {
            this.sharedCache.invalidateAll((Iterable)SequencesKt.toList(SequencesKt.filter(CollectionsKt.asSequence(this.sharedCache.asMap().keySet()), arg_0 -> CaffeineSharedCache.invalidateAll$lambda$2(this, arg_0))));
        }

        private static final boolean invalidateAll$lambda$2(CaffeineSharedCache this$0, SharedCacheKey it) {
            return it.getSubCacheId() == this$0.cacheId;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SharedCacheKey;", "K", "", "key", "subCacheId", "", "equalityPolicy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "<init>", "(Ljava/lang/Object;ILcom/intellij/util/containers/hash/EqualityPolicy;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSubCacheId", "()I", "equals", "", "other", "hashCode", "intellij.platform.util"})
    private static final class SharedCacheKey<K> {
        private final K key;
        private final int subCacheId;
        @NotNull
        private final EqualityPolicy<K> equalityPolicy;

        public SharedCacheKey(K key, int subCacheId, @NotNull EqualityPolicy<K> equalityPolicy) {
            Intrinsics.checkNotNullParameter(equalityPolicy, "equalityPolicy");
            this.key = key;
            this.subCacheId = subCacheId;
            this.equalityPolicy = equalityPolicy;
        }

        public final K getKey() {
            return this.key;
        }

        public final int getSubCacheId() {
            return this.subCacheId;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (this.getClass() != (object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.util.indexing.impl.SharedCaffeineIndexStorageCacheProvider.SharedCacheKey<K of com.intellij.util.indexing.impl.SharedCaffeineIndexStorageCacheProvider.SharedCacheKey>");
            SharedCacheKey cfr_ignored_0 = (SharedCacheKey)other;
            if (this.subCacheId != ((SharedCacheKey)other).subCacheId) {
                return false;
            }
            return this.equalityPolicy.isEqual(this.key, ((SharedCacheKey)other).key);
        }

        public int hashCode() {
            return this.equalityPolicy.getHashCode(this.key) * 31 + this.subCacheId;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BE\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005H\u00c6\u0003J\u001b\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003JW\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u00052\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/impl/SharedCaffeineIndexStorageCacheProvider$SubCacheDescriptor;", "Key", "Value", "", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "cacheAccessLock", "Ljava/util/concurrent/locks/ReentrantLock;", "<init>", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;Ljava/util/concurrent/locks/ReentrantLock;)V", "getValueReader", "()Ljava/util/function/Function;", "getEvictedValuesPersister", "()Ljava/util/function/BiConsumer;", "getCacheAccessLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.util"})
    private static final class SubCacheDescriptor<Key, Value> {
        @NotNull
        private final Function<Key, ChangeTrackingValueContainer<Value>> valueReader;
        @NotNull
        private final BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister;
        @NotNull
        private final ReentrantLock cacheAccessLock;

        public SubCacheDescriptor(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull ReentrantLock cacheAccessLock) {
            Intrinsics.checkNotNullParameter(valueReader, "valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
            Intrinsics.checkNotNullParameter(cacheAccessLock, "cacheAccessLock");
            this.valueReader = valueReader;
            this.evictedValuesPersister = evictedValuesPersister;
            this.cacheAccessLock = cacheAccessLock;
        }

        public /* synthetic */ SubCacheDescriptor(Function function, BiConsumer biConsumer, ReentrantLock reentrantLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                reentrantLock = new ReentrantLock();
            }
            this(function, biConsumer, reentrantLock);
        }

        @NotNull
        public final Function<Key, ChangeTrackingValueContainer<Value>> getValueReader() {
            return this.valueReader;
        }

        @NotNull
        public final BiConsumer<Key, ChangeTrackingValueContainer<Value>> getEvictedValuesPersister() {
            return this.evictedValuesPersister;
        }

        @NotNull
        public final ReentrantLock getCacheAccessLock() {
            return this.cacheAccessLock;
        }

        @NotNull
        public final Function<Key, ChangeTrackingValueContainer<Value>> component1() {
            return this.valueReader;
        }

        @NotNull
        public final BiConsumer<Key, ChangeTrackingValueContainer<Value>> component2() {
            return this.evictedValuesPersister;
        }

        @NotNull
        public final ReentrantLock component3() {
            return this.cacheAccessLock;
        }

        @NotNull
        public final SubCacheDescriptor<Key, Value> copy(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull ReentrantLock cacheAccessLock) {
            Intrinsics.checkNotNullParameter(valueReader, "valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
            Intrinsics.checkNotNullParameter(cacheAccessLock, "cacheAccessLock");
            return new SubCacheDescriptor<Key, Value>(valueReader, evictedValuesPersister, cacheAccessLock);
        }

        public static /* synthetic */ SubCacheDescriptor copy$default(SubCacheDescriptor subCacheDescriptor, Function function, BiConsumer biConsumer, ReentrantLock reentrantLock, int n, Object object) {
            if ((n & 1) != 0) {
                function = subCacheDescriptor.valueReader;
            }
            if ((n & 2) != 0) {
                biConsumer = subCacheDescriptor.evictedValuesPersister;
            }
            if ((n & 4) != 0) {
                reentrantLock = subCacheDescriptor.cacheAccessLock;
            }
            return subCacheDescriptor.copy(function, biConsumer, reentrantLock);
        }

        @NotNull
        public String toString() {
            return "SubCacheDescriptor(valueReader=" + this.valueReader + ", evictedValuesPersister=" + this.evictedValuesPersister + ", cacheAccessLock=" + this.cacheAccessLock + ')';
        }

        public int hashCode() {
            int result2 = this.valueReader.hashCode();
            result2 = result2 * 31 + this.evictedValuesPersister.hashCode();
            result2 = result2 * 31 + this.cacheAccessLock.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubCacheDescriptor)) {
                return false;
            }
            SubCacheDescriptor subCacheDescriptor = (SubCacheDescriptor)other;
            if (!Intrinsics.areEqual(this.valueReader, subCacheDescriptor.valueReader)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.evictedValuesPersister, subCacheDescriptor.evictedValuesPersister)) {
                return false;
            }
            return Intrinsics.areEqual(this.cacheAccessLock, subCacheDescriptor.cacheAccessLock);
        }
    }
}

