/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.ConfigurationFileManagerKt;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\rJ\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\tH\u0016R-\u0010\u0006\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "clearableLazyValues", "Lcom/intellij/util/containers/ConcurrentList;", "Lkotlin/Function0;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "yamlData", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/snakeyaml/engine/v2/nodes/MappingNode;", "registerClearableLazyValue", "value", "clearClearableValues", "addFileListener", "getConfigurationNode", "findValueNode", "", "Lorg/snakeyaml/engine/v2/nodes/NodeTuple;", "namePath", "", "dispose", "Companion", "intellij.configurationScript"})
@SourceDebugExtension(value={"SMAP\nConfigurationFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationFileManager.kt\ncom/intellij/configurationScript/ConfigurationFileManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1863#2,2:161\n*S KotlinDebug\n*F\n+ 1 ConfigurationFileManager.kt\ncom/intellij/configurationScript/ConfigurationFileManager\n*L\n67#1:161,2\n*E\n"})
public final class ConfigurationFileManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentList<Function0<Unit>> clearableLazyValues;
    @NotNull
    private final SynchronizedClearableLazy<MappingNode> yamlData;

    public ConfigurationFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.clearableLazyValues = concurrentList;
        this.yamlData = new SynchronizedClearableLazy(() -> ConfigurationFileManager.yamlData$lambda$0(project));
        if (!TrustedProjects.isTrusted((Project)project)) {
            TrustedProjectsListener.Companion.onceWhenProjectTrusted((Disposable)this, arg_0 -> ConfigurationFileManager._init_$lambda$1(this, arg_0));
        }
        this.registerClearableLazyValue(this.yamlData);
        this.addFileListener(project);
    }

    public final void registerClearableLazyValue(@NotNull SynchronizedClearableLazy<?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.registerClearableLazyValue((Function0<Unit>)((Function0)() -> ConfigurationFileManager.registerClearableLazyValue$lambda$2(value)));
    }

    public final void registerClearableLazyValue(@NotNull Function0<Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clearableLazyValues.add(value);
    }

    private final void clearClearableValues() {
        Iterable $this$forEach$iv = (Iterable)this.clearableLazyValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void addFileListener(Project project) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(this){
            final /* synthetic */ ConfigurationFileManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file;
                    if (vFileEvent instanceof VFileCopyEvent) continue;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        if (((VFileCreateEvent)vFileEvent).isDirectory()) continue;
                        String string = ((VFileCreateEvent)vFileEvent).getChildName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                        if (!ConfigurationFileManagerKt.isConfigurationFile(string)) {
                            continue;
                        }
                    } else if (vFileEvent.getFile() == null || !ConfigurationFileManagerKt.isConfigurationFile(file)) continue;
                    ConfigurationFileManager.access$clearClearableValues(this.this$0);
                }
            }
        });
    }

    @Nullable
    public final MappingNode getConfigurationNode() {
        return (MappingNode)this.yamlData.getValue();
    }

    @Nullable
    public final List<NodeTuple> findValueNode(@NotNull String namePath) {
        Intrinsics.checkNotNullParameter((Object)namePath, (String)"namePath");
        MappingNode mappingNode = this.getConfigurationNode();
        if (mappingNode == null) {
            return null;
        }
        MappingNode root = mappingNode;
        return ConfigurationFileManagerKt.findValueNode(root, namePath);
    }

    public void dispose() {
    }

    private static final MappingNode yamlData$lambda$0(Project $project) {
        if (!TrustedProjects.isTrusted((Project)$project)) {
            return null;
        }
        String string = $project.getBasePath();
        if (string == null) {
            return null;
        }
        Path projectIdeaDir = Paths.get(string, new String[0]);
        Intrinsics.checkNotNull((Object)projectIdeaDir);
        return ConfigurationFileManagerKt.readProjectConfigurationFile(projectIdeaDir);
    }

    private static final Unit _init_$lambda$1(ConfigurationFileManager this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clearClearableValues();
        return Unit.INSTANCE;
    }

    private static final Unit registerClearableLazyValue$lambda$2(SynchronizedClearableLazy $value) {
        $value.drop();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$clearClearableValues(ConfigurationFileManager $this) {
        $this.clearClearableValues();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/configurationScript/ConfigurationFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.configurationScript"})
    @SourceDebugExtension(value={"SMAP\nConfigurationFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationFileManager.kt\ncom/intellij/configurationScript/ConfigurationFileManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,160:1\n31#2,2:161\n*S KotlinDebug\n*F\n+ 1 ConfigurationFileManager.kt\ncom/intellij/configurationScript/ConfigurationFileManager$Companion\n*L\n55#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigurationFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ConfigurationFileManager> serviceClass$iv = ConfigurationFileManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ConfigurationFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

