/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.model;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracklink.collections.CollectionsCache;
import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.TableAbstractRow;
import com.almworks.tracklink.toolwindow.table.model.TableCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import com.almworks.tracklink.util.StringBundle;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueTableModel
extends AbstractTableModel {
    public static final String EMPTY_FILTER_STRING = "";
    public static final Pattern EMPTY_FILTER_PATTERN = Pattern.compile("");
    public static final int ABSENT = -1;
    public List<String> myModelBeanOrderedList = new ArrayList<String>(3);
    public Map<String, Boolean> myModelBean = new HashMap<String, Boolean>(3);
    private final Map<String, ArtifactCollectionRow> myCollectionMap = new LinkedHashMap<String, ArtifactCollectionRow>();
    private final Map<TableCollectionRow, Integer> myCollectionPositionsMap = new HashMap<TableCollectionRow, Integer>();
    private String myFilterString = "";
    private Pattern myFilterPattern = EMPTY_FILTER_PATTERN;
    private boolean myFiltering = false;
    private TableAbstractRow mySelectedRow = null;
    private int myRowCount;

    public TableAbstractRow getSelectedRow() {
        return this.mySelectedRow;
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        this.updateRowCountAndPositions();
        super.fireTableChanged(e);
    }

    private void updateRowCountAndPositions() {
        int sum = 0;
        this.myCollectionPositionsMap.clear();
        for (ArtifactCollectionRow c : this.myCollectionMap.values()) {
            int collectionVisibleLength = c.getCollectionVisibleLength();
            this.myCollectionPositionsMap.put(c, sum);
            sum += collectionVisibleLength;
        }
        this.myRowCount = sum;
    }

    public Pattern getFilterPattern() {
        return this.myFilterPattern;
    }

    @Override
    public int getRowCount() {
        return this.myRowCount;
    }

    public TableCollectionRow getCollection(String id) {
        return this.myCollectionMap.get(id);
    }

    public int getCollectionSize() {
        return this.myCollectionMap.size();
    }

    public Collection<ArtifactCollectionRow> getCollections() {
        return Collections.unmodifiableCollection(this.myCollectionMap.values());
    }

    public String getFilterString() {
        return this.isFiltering() ? this.myFilterString : EMPTY_FILTER_STRING;
    }

    public boolean isFiltering() {
        return this.myFiltering;
    }

    public void setArtifactCollectionExpand(String ID, boolean exp) {
        if (this.myCollectionMap.containsKey(ID)) {
            this.myCollectionMap.get(ID).setCollectionExpanded(exp);
        }
    }

    public void setFilterString(String filter) {
        if (filter.length() > 0) {
            this.myFiltering = true;
            try {
                this.myFilterPattern = Pattern.compile(filter, 18);
            }
            catch (Exception e) {
                this.myFilterPattern = EMPTY_FILTER_PATTERN;
            }
        } else {
            this.myFiltering = false;
        }
        this.myFilterString = filter;
        this.updateCollectionFilters();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return StringBundle.get("Column.ID", new Object[0]);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getRowByPosition(rowIndex);
    }

    public void addCollection(ArtifactCollectionRow data, String id) {
        this.myCollectionMap.put(id, data);
    }

    public void doDetatch() {
        for (ArtifactCollectionRow collection : this.myCollectionMap.values()) {
            if (!(collection instanceof ArtifactCollectionRow)) continue;
            ArtifactCollectionRow artCol = collection;
            artCol.detach();
        }
        this.myCollectionMap.clear();
    }

    public void forEachArtifact(TObjectProcedure<TableFilteringRow> procedure) {
        boolean maxWidth = false;
        for (ArtifactCollectionRow collectionRow : this.myCollectionMap.values()) {
            collectionRow.forEachChild(procedure);
        }
    }

    public void forEachCollection(TObjectProcedure<TableCollectionRow> proc) {
        for (ArtifactCollectionRow collectionRow : this.myCollectionMap.values()) {
            proc.execute((Object)collectionRow);
        }
    }

    public Collection<TableCollectionRow> getCollapsedCollections() {
        ArrayList<TableCollectionRow> expanded = new ArrayList<TableCollectionRow>();
        for (ArtifactCollectionRow collection : this.myCollectionMap.values()) {
            if (collection.isCollectionExpanded()) continue;
            expanded.add(collection);
        }
        return expanded;
    }

    public TableAbstractRow getItemsBySelection(int selection) {
        return this.getRowByPosition(selection);
    }

    public int getSelectedPos(boolean findParent) {
        int res = -1;
        if (this.mySelectedRow != null) {
            if (this.mySelectedRow instanceof ArtifactInfoRow) {
                TableFilteringRow infoRow = (TableFilteringRow)this.mySelectedRow;
                res = this.getPositionByRow(this.mySelectedRow);
                if (res == -1 && findParent && infoRow.getParent() != null) {
                    res = this.myCollectionPositionsMap.get(infoRow.getParent());
                }
            } else {
                Integer selected = this.myCollectionPositionsMap.get((TableCollectionRow)this.mySelectedRow);
                res = selected != null ? selected : -1;
            }
        }
        return res;
    }

    public int getPositionByRow(TableAbstractRow row) {
        for (ArtifactCollectionRow collection : this.myCollectionMap.values()) {
            int colPos = this.myCollectionPositionsMap.get(collection);
            if (row == collection) {
                return colPos;
            }
            int filteringPos = collection.getPosByChild((TableFilteringRow)row);
            if (filteringPos == -1) continue;
            return filteringPos + colPos + 1;
        }
        return -1;
    }

    public boolean hasCollection(String id) {
        return this.myCollectionMap.containsKey(id);
    }

    public TableCollectionRow removeCollectionFromMap(String id) {
        return this.myCollectionMap.remove(id);
    }

    private void updateCollectionFilters() {
        for (ArtifactCollectionRow collectionRow : this.myCollectionMap.values()) {
            collectionRow.updateFiltering(false);
        }
    }

    public void setSelectedPos(int pos, boolean storeCollectionSelection) {
        if (this.getRowCount() > 0) {
            TableAbstractRow row = this.getRowByPosition(pos);
            if (storeCollectionSelection) {
                this.mySelectedRow = this.getRowByPosition(pos);
            } else if (row instanceof ArtifactInfoRow) {
                this.mySelectedRow = this.getRowByPosition(pos);
            }
        }
    }

    public TableAbstractRow getRowByPosition(int pos) {
        if (pos == -1) {
            return null;
        }
        TableCollectionRow collection = this.getCollectionByRow(pos);
        if (!collection.isCollectionExpanded()) {
            return collection;
        }
        int collectionItemPos = this.myCollectionPositionsMap.get(collection);
        if (collectionItemPos == pos) {
            return collection;
        }
        return collection.getChildByPos(pos - collectionItemPos - 1);
    }

    public TableCollectionRow getCollectionByRow(int rowPos) {
        ArtifactCollectionRow lastCol = null;
        for (ArtifactCollectionRow collection : this.myCollectionMap.values()) {
            if (this.myCollectionPositionsMap.get(collection) > rowPos) {
                return lastCol;
            }
            lastCol = collection;
        }
        return lastCol;
    }

    public void updateArtifactInfo(ArtifactInfo info) {
        Iterator<ArtifactCollectionRow> i$ = this.myCollectionMap.values().iterator();
        while (i$.hasNext()) {
            ArtifactCollectionRow collection;
            ArtifactCollectionRow artColl = collection = i$.next();
            artColl.updateArtifact(info);
        }
        this.fireTableDataChanged();
    }

    public int findFirstVisiblePos() {
        for (ArtifactCollectionRow tableCollectionRow : this.myCollectionMap.values()) {
            if (tableCollectionRow.getCollectionVisibleLength() <= 1) continue;
            return this.getPositionByRow(tableCollectionRow.getChildByPos(0));
        }
        return -1;
    }

    public void storeState(CollectionsCache collectionsCache) {
        this.myModelBean.clear();
        this.myModelBeanOrderedList.clear();
        for (Map.Entry<String, ArtifactCollectionRow> collection : this.myCollectionMap.entrySet()) {
            ArtifactCollectionRow collectionNode = collection.getValue();
            CollectionData collectionData = collection.getValue().getCollectionData();
            this.myModelBean.put(collectionData.getCollectionId(), collectionNode.isCollectionExpanded());
            this.myModelBeanOrderedList.add(collectionData.getCollectionId());
            ArrayList<String> urls = new ArrayList<String>(collectionNode.getCollectionSize());
            for (TableFilteringRow child : collectionNode.getChildrenAsArray()) {
                ArtifactInfoRow infoNode = (ArtifactInfoRow)child;
                urls.add(infoNode.getArtifactInfo().getUrl());
            }
            collectionsCache.store(collectionData, urls);
        }
    }
}

