/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public abstract class BaseZapAddOnXmlData {
    private static final Logger LOGGER = LogManager.getLogger(BaseZapAddOnXmlData.class);
    private static final List<String> ADDON_STATUSES = Arrays.asList("alpha", "beta", "release");
    private static final String NAME_ELEMENT = "name";
    private static final String STATUS = "status";
    private static final String VERSION_ELEMENT = "version";
    private static final String SEM_VER_ELEMENT = "semver";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String AUTHOR_ELEMENT = "author";
    private static final String URL_ELEMENT = "url";
    private static final String CHANGES_ELEMENT = "changes";
    private static final String REPO_ELEMENT = "repo";
    private static final String NOT_BEFORE_VERSION_ELEMENT = "not-before-version";
    private static final String NOT_FROM_VERSION_ELEMENT = "not-from-version";
    private static final String DEPENDENCIES_ELEMENT = "dependencies";
    private static final String DEPENDENCIES_JAVA_VERSION_ELEMENT = "javaversion";
    private static final String DEPENDENCIES_ADDONS_ALL_ELEMENTS = "addons/addon";
    private static final String ZAPADDON_ID_ELEMENT = "id";
    private static final String ZAPADDON_NOT_BEFORE_VERSION_ELEMENT = "not-before-version";
    private static final String ZAPADDON_NOT_FROM_VERSION_ELEMENT = "not-from-version";
    private static final String ZAPADDON_VERSION_ELEMENT = "version";
    private static final String ZAPADDON_SEMVER_ELEMENT = "semver";
    private static final String EXTENSION_ELEMENT = "extension";
    private static final String EXTENSIONS_ALL_ELEMENTS = "extensions/extension";
    private static final String EXTENSIONS_V1_ALL_ELEMENTS = "extensions/extension[@v='1']";
    private static final String EXTENSION_CLASS_NAME = "classname";
    private static final String EXTENSION_DEPENDENCIES = "dependencies/addons/addon";
    private static final String CLASSNAMES_ALLOWED_ELEMENT = "allowed";
    private static final String CLASSNAMES_ALLOWED_ALL_ELEMENTS = "classnames/allowed";
    private static final String CLASSNAMES_RESTRICTED_ELEMENT = "restricted";
    private static final String CLASSNAMES_RESTRICTED_ALL_ELEMENTS = "classnames/restricted";
    private String name;
    private String status;
    private Version version;
    private Version semVer;
    private String description;
    private String author;
    private String url;
    private String changes;
    private String repo;
    private Dependencies dependencies;
    private AddOnClassnames addOnClassnames;
    private String notBeforeVersion;
    private String notFromVersion;
    private List<String> extensions;
    private List<ExtensionWithDeps> extensionsWithDeps;

    public BaseZapAddOnXmlData(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "The InputStream must not be null.");
        ZapXmlConfiguration zapAddOnXml = new ZapXmlConfiguration();
        zapAddOnXml.setExpressionEngine(new XPathExpressionEngine());
        try {
            zapAddOnXml.load(inputStream);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        this.readDataImpl(zapAddOnXml);
    }

    public BaseZapAddOnXmlData(HierarchicalConfiguration zapAddOnXml) {
        this.readDataImpl(zapAddOnXml);
    }

    private void readDataImpl(HierarchicalConfiguration zapAddOnXml) {
        this.name = zapAddOnXml.getString(NAME_ELEMENT, "");
        String v = zapAddOnXml.getString("version", "1.0.0");
        try {
            this.version = new Version(v);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Falling back to integer version [" + v + "] for add-on " + this.name);
            }
            this.version = new Version(Integer.parseInt(v) + ".0.0");
        }
        this.status = zapAddOnXml.getString(STATUS);
        if (this.status == null) {
            LOGGER.log(Constant.isDevMode() ? Level.ERROR : Level.WARN, "No status specified for " + this.name + ", defaulting to \"alpha\". Add-ons should declare its status in the manifest.");
            this.status = "alpha";
        } else if (!ADDON_STATUSES.contains(this.status)) {
            throw new IllegalArgumentException("Unrecognised status \"" + this.status + "\" in " + this.name + ", expected one of " + ADDON_STATUSES);
        }
        this.semVer = BaseZapAddOnXmlData.createVersion(zapAddOnXml.getString("semver", ""));
        this.description = zapAddOnXml.getString(DESCRIPTION_ELEMENT, "");
        this.author = zapAddOnXml.getString(AUTHOR_ELEMENT, "");
        this.url = zapAddOnXml.getString(URL_ELEMENT, "");
        this.changes = zapAddOnXml.getString(CHANGES_ELEMENT, "");
        this.repo = zapAddOnXml.getString(REPO_ELEMENT, "");
        this.dependencies = this.readDependencies(zapAddOnXml, "zapaddon");
        this.notBeforeVersion = zapAddOnXml.getString("not-before-version", "");
        this.notFromVersion = zapAddOnXml.getString("not-from-version", "");
        this.extensions = this.getStrings(zapAddOnXml, EXTENSIONS_ALL_ELEMENTS, EXTENSION_ELEMENT);
        this.extensionsWithDeps = this.readExtensionsWithDeps(zapAddOnXml);
        this.addOnClassnames = this.readAddOnClassnames(zapAddOnXml);
        this.readAdditionalData(zapAddOnXml);
    }

    protected void readAdditionalData(HierarchicalConfiguration zapAddOnData) {
    }

    private static Version createVersion(String version) {
        if (!version.isEmpty()) {
            return new Version(version);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    @Deprecated
    public int getPackageVersion() {
        return this.version.getMajorVersion();
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getSemVer() {
        return this.semVer;
    }

    public String getChanges() {
        return this.changes;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getUrl() {
        return this.url;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public AddOnClassnames getAddOnClassnames() {
        return this.addOnClassnames;
    }

    public String getNotBeforeVersion() {
        return this.notBeforeVersion;
    }

    public String getNotFromVersion() {
        return this.notFromVersion;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<ExtensionWithDeps> getExtensionsWithDeps() {
        return this.extensionsWithDeps;
    }

    protected List<String> getStrings(HierarchicalConfiguration zapAddOnXml, String element, String elementName) {
        String[] fields = zapAddOnXml.getStringArray(element);
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>(fields.length);
        for (String field : fields) {
            if (!field.isEmpty()) {
                strings.add(field);
                continue;
            }
            LOGGER.warn("Ignoring empty \"" + elementName + "\" entry in add-on \"" + this.name + "\".");
        }
        if (strings.isEmpty()) {
            return Collections.emptyList();
        }
        strings.trimToSize();
        return strings;
    }

    private Dependencies readDependencies(HierarchicalConfiguration currentNode, String element) {
        List<HierarchicalConfiguration> dependencies = currentNode.configurationsAt(DEPENDENCIES_ELEMENT);
        if (dependencies.isEmpty()) {
            return null;
        }
        if (dependencies.size() > 1) {
            this.malformedFile("expected at most one \"dependencies\" element for \"" + element + "\" element, found " + dependencies.size() + ".");
        }
        HierarchicalConfiguration node = dependencies.get(0);
        String javaVersion = node.getString(DEPENDENCIES_JAVA_VERSION_ELEMENT, "");
        List<HierarchicalConfiguration> fields = node.configurationsAt(DEPENDENCIES_ADDONS_ALL_ELEMENTS);
        if (fields.isEmpty()) {
            return new Dependencies(javaVersion, Collections.emptyList());
        }
        List<AddOnDep> addOns = this.readAddOnDependencies(fields);
        return new Dependencies(javaVersion, addOns);
    }

    private List<AddOnDep> readAddOnDependencies(List<HierarchicalConfiguration> fields) {
        ArrayList<AddOnDep> addOns = new ArrayList<AddOnDep>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String version;
            String id = sub.getString(ZAPADDON_ID_ELEMENT, "");
            if (id.isEmpty()) {
                this.malformedFile("an add-on dependency has empty \"id\".");
            }
            if ((version = sub.getString("version", "")).isEmpty()) {
                version = sub.getString("semver", "");
            }
            AddOnDep addOnDep = new AddOnDep(id, sub.getString("not-before-version", ""), sub.getString("not-from-version", ""), version);
            addOns.add(addOnDep);
        }
        return addOns;
    }

    private List<ExtensionWithDeps> readExtensionsWithDeps(HierarchicalConfiguration currentNode) {
        List<HierarchicalConfiguration> extensions = currentNode.configurationsAt(EXTENSIONS_V1_ALL_ELEMENTS);
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionWithDeps> extensionsWithDeps = new ArrayList<ExtensionWithDeps>(extensions.size());
        for (HierarchicalConfiguration extensionNode : extensions) {
            List<HierarchicalConfiguration> fields;
            String classname = extensionNode.getString(EXTENSION_CLASS_NAME, "");
            if (classname.isEmpty()) {
                this.malformedFile("a v1 extension has empty \"classname\".");
            }
            if ((fields = extensionNode.configurationsAt(EXTENSION_DEPENDENCIES)).isEmpty()) {
                if (this.extensions.isEmpty()) {
                    this.extensions = new ArrayList<String>(5);
                }
                this.extensions.add(classname);
                continue;
            }
            List<AddOnDep> addOnDeps = this.readAddOnDependencies(fields);
            AddOnClassnames classnames = this.readAddOnClassnames(extensionNode);
            extensionsWithDeps.add(new ExtensionWithDeps(classname, addOnDeps, classnames));
        }
        return extensionsWithDeps;
    }

    private AddOnClassnames readAddOnClassnames(HierarchicalConfiguration node) {
        List<String> allowed = this.getStrings(node, CLASSNAMES_ALLOWED_ALL_ELEMENTS, CLASSNAMES_ALLOWED_ELEMENT);
        List<String> restricted = this.getStrings(node, CLASSNAMES_RESTRICTED_ALL_ELEMENTS, CLASSNAMES_RESTRICTED_ELEMENT);
        if (allowed.isEmpty() && restricted.isEmpty()) {
            return AddOnClassnames.ALL_ALLOWED;
        }
        return new AddOnClassnames(allowed, restricted);
    }

    private void malformedFile(String reason) {
        throw new IllegalArgumentException("Add-on \"" + this.name + "\" contains malformed " + "ZapAddOn.xml" + " file, " + reason);
    }

    public static class ExtensionWithDeps {
        private final String classname;
        private final List<AddOnDep> addOnDependencies;
        private final AddOnClassnames addOnClassnames;

        public ExtensionWithDeps(String classname, List<AddOnDep> addOnDependencies, AddOnClassnames addOnClassnames) {
            this.classname = classname;
            this.addOnDependencies = addOnDependencies;
            this.addOnClassnames = addOnClassnames;
        }

        public String getClassname() {
            return this.classname;
        }

        public List<AddOnDep> getDependencies() {
            return this.addOnDependencies;
        }

        public AddOnClassnames getAddOnClassnames() {
            return this.addOnClassnames;
        }
    }

    public static class AddOnDep {
        private final String id;
        private final int notBeforeVersion;
        private final int notFromVersion;
        private final String version;

        public AddOnDep(String id, String notBeforeVersion, String notFromVersion, String version) {
            this.id = id;
            this.notBeforeVersion = AddOnDep.convertToInt(notBeforeVersion, -1, "not-before-version");
            this.notFromVersion = AddOnDep.convertToInt(notFromVersion, -1, "not-from-version");
            if (version.isEmpty()) {
                StringBuilder versionMatch = new StringBuilder();
                if (this.notBeforeVersion != -1) {
                    versionMatch.append(" >= ").append(this.notBeforeVersion).append(".0.0");
                }
                if (this.notFromVersion != -1) {
                    if (versionMatch.length() != 0) {
                        versionMatch.append(" &");
                    }
                    versionMatch.append(" < ").append(this.notFromVersion).append(".0.0");
                }
                this.version = versionMatch.toString();
            } else {
                if (!Version.isValidVersionRange(version)) {
                    throw new IllegalArgumentException("Invalid version range: " + version);
                }
                this.version = version;
            }
        }

        private static int convertToInt(String value, int defaultValue, String element) {
            if (value == null || value.isEmpty()) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected integer for element \"" + element + "\" but was: " + value);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        @Deprecated
        public int getNotBeforeVersion() {
            return this.notBeforeVersion;
        }

        @Deprecated
        public int getNotFromVersion() {
            return this.notFromVersion;
        }

        @Deprecated
        public String getSemVer() {
            return this.version;
        }
    }

    public static class Dependencies {
        private final String javaVersion;
        private final List<AddOnDep> addOnDependencies;

        public Dependencies(String javaVersion, List<AddOnDep> addOnDependencies) {
            this.javaVersion = javaVersion;
            this.addOnDependencies = addOnDependencies;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public List<AddOnDep> getAddOns() {
            return this.addOnDependencies;
        }
    }
}

