/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.MainClassApplicationType;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.openide.util.NbBundle;

public class MainClassApplicationTypeFactory
extends AbstractModelProvider<ApplicationType, Application> {
    private static final int CLASS_NAME = 0;
    private static final int NAME = 1;
    private static final int DESCRIPTION = 2;
    private static final int ICON_PATH = 3;
    private String[][] appmatrix = new String[][]{{"org.apache.tools.ant.launch.Launcher", "Ant", MainClassApplicationTypeFactory.descr("DESCR_Ant"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.enterprise.server.PELaunch", "GlassFish", MainClassApplicationTypeFactory.descr("DESCR_GlassFish"), "org/graalvm/visualvm/application/type/resources/GlassFish.png"}, {"com.sun.enterprise.glassfish.bootstrap.ASMain", "GlassFish", MainClassApplicationTypeFactory.descr("DESCR_GlassFish"), "org/graalvm/visualvm/application/type/resources/GlassFish.png"}, {"com.sun.enterprise.ee.nodeagent.NodeAgentMain", "GlassFish Node", "GlassFish Node", "org/graalvm/visualvm/application/type/resources/GlassFish.png"}, {"org.apache.catalina.startup.Bootstrap", "Tomcat", MainClassApplicationTypeFactory.descr("DESCR_Tomcat"), "org/graalvm/visualvm/application/type/resources/Tomcat.png"}, {"org.jboss.Main", "JBoss", MainClassApplicationTypeFactory.descr("DESCR_JBoss"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.example.debug.tty.TTY", "Jdb", MainClassApplicationTypeFactory.descr("DESCR_Jdb"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.hat.Main", "JHat", MainClassApplicationTypeFactory.descr("DESCR_Jhat"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.jdeprscan.Main", "Jdeprscan", MainClassApplicationTypeFactory.descr("DESCR_Jdeprscan"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.jdeps.Main", "Jdeps", MainClassApplicationTypeFactory.descr("DESCR_Jdeps"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.script.shell.Main", "Jrunscript", MainClassApplicationTypeFactory.descr("DESCR_Jrunscript"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.incubator.jpackage.main.Main", "Jpackage", MainClassApplicationTypeFactory.descr("DESCR_Jpackage"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.internal.jshell.tool.JShellToolProvider", "JShell", MainClassApplicationTypeFactory.descr("DESCR_JShell"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.jfr.internal.tool.Main", "Jfr", MainClassApplicationTypeFactory.descr("DESCR_Jfr"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.jshell.execution.RemoteExecutionControl", "JShell remote agent", MainClassApplicationTypeFactory.descr("DESCR_JShell"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.tools.jimage.Main", "Jimage", MainClassApplicationTypeFactory.descr("DESCR_Jimage"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.tools.jlink.internal.Main", "Jlink", MainClassApplicationTypeFactory.descr("DESCR_Jlink"), "org/graalvm/visualvm/application/resources/application.png"}, {"jdk.tools.jmod.Main", "Jmod", MainClassApplicationTypeFactory.descr("DESCR_Jmod"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.jvm.hotspot.SALauncher", "Jhsdb", MainClassApplicationTypeFactory.descr("DESCR_Jhsdb"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.jvm.hotspot.jdi.SADebugServer", "jsadebugd", MainClassApplicationTypeFactory.descr("DESCR_Jsadebugd"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.jvm.hotspot.tools.JMap", "JMap", MainClassApplicationTypeFactory.descr("DESCR_Jmap"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.jvm.hotspot.tools.JStack", "JStack", MainClassApplicationTypeFactory.descr("DESCR_Jstack"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.net.httpserver.simpleserver.JWebServer", "Jwebserver", MainClassApplicationTypeFactory.descr("DESCR_Jwebserver"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jcmd.JCmd", "Jcmd", MainClassApplicationTypeFactory.descr("DESCR_Jcmd"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jconsole.JConsole", "JConsole", MainClassApplicationTypeFactory.descr("DESCR_JConsole"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jinfo.JInfo", "JInfo", MainClassApplicationTypeFactory.descr("DESCR_Jinfo"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jmap.JMap", "JMap", MainClassApplicationTypeFactory.descr("DESCR_Jmap"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jps.Jps", "Jps", MainClassApplicationTypeFactory.descr("DESCR_Jps"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jstack.JStack", "JStack", MainClassApplicationTypeFactory.descr("DESCR_Jstack"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jstat.Jstat", "Jstat", MainClassApplicationTypeFactory.descr("DESCR_Jstat"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jstatd.Jstatd", "Jstatd", MainClassApplicationTypeFactory.descr("DESCR_Jstatd"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.jar.Main", "Jar", MainClassApplicationTypeFactory.descr("DESCR_Jar"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.java.util.jar.pack.Driver", "pack200", MainClassApplicationTypeFactory.descr("DESCR_Pack200"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.javadoc.Main", "JavaDoc", MainClassApplicationTypeFactory.descr("DESCR_JavaDoc"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.javac.Main", "Javac", MainClassApplicationTypeFactory.descr("DESCR_Javac"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.javah.Main", "Javah", MainClassApplicationTypeFactory.descr("DESCR_Javah"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.tools.javap.Main", "Javap", MainClassApplicationTypeFactory.descr("DESCR_Javap"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.security.tools.JarSigner", "JarSigner", MainClassApplicationTypeFactory.descr("DESCR_JarSigner"), "org/graalvm/visualvm/application/resources/application.png"}, {"com.sun.tools.apt.Main", "APT", MainClassApplicationTypeFactory.descr("DESCR_Apt"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.applet.Main", "Applet Viewer", MainClassApplicationTypeFactory.descr("DESCR_AppletViewer"), "org/graalvm/visualvm/application/resources/application.png"}, {"sun.applet.AppletViewer", "Applet Viewer", MainClassApplicationTypeFactory.descr("DESCR_AppletViewer"), "org/graalvm/visualvm/application/resources/application.png"}, {"FileChooserDemo", "FileChooserDemo", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"Font2DTest", "Font2DTest", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"java2d.Java2Demo", "Java2Demo", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"Metalworks", "Metalworks", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"Notepad", "Notepad", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"SampleTree", "SampleTree", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"Stylepad", "Stylepad", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"SwingSet2", "SwingSet2", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"TableExample", "TableExample", MainClassApplicationTypeFactory.descr("DESCR_JdkDemoApp"), "org/graalvm/visualvm/application/resources/application.png"}, {"org.apache.derby.drda.NetworkServerControl", "JavaDB", MainClassApplicationTypeFactory.descr("DESCR_JavaDb"), "org/graalvm/visualvm/application/type/resources/JavaDB.png"}, {"com.jrockit.mc.rcp.start.MCMain", "JRockit Mission Control", MainClassApplicationTypeFactory.descr("DESCR_JRMC"), "org/graalvm/visualvm/application/type/resources/JRMC.png"}, {"weblogic.Server", "WebLogic", MainClassApplicationTypeFactory.descr("DESCR_WLS"), "org/graalvm/visualvm/application/type/resources/WLS.png"}, {"org.jruby.Main", MainClassApplicationTypeFactory.descr("LBL_Jruby"), MainClassApplicationTypeFactory.descr("DESCR_Jruby"), "org/graalvm/visualvm/application/type/resources/JRuby.png"}, {"scala.tools.nsc.MainGenericRunner", MainClassApplicationTypeFactory.descr("LBL_Scala"), MainClassApplicationTypeFactory.descr("DESCR_Scala"), "org/graalvm/visualvm/application/type/resources/Scala.png"}, {"clojure.main", MainClassApplicationTypeFactory.descr("LBL_Clojure"), MainClassApplicationTypeFactory.descr("DESCR_Clojure"), "org/graalvm/visualvm/application/type/resources/Clojure.png"}, {"clojure.jar", MainClassApplicationTypeFactory.descr("LBL_Clojure"), MainClassApplicationTypeFactory.descr("DESCR_Clojure"), "org/graalvm/visualvm/application/type/resources/Clojure.png"}, {"clojure.lang.Script", MainClassApplicationTypeFactory.descr("LBL_Clojure"), MainClassApplicationTypeFactory.descr("DESCR_Clojure"), "org/graalvm/visualvm/application/type/resources/Clojure.png"}, {"clojure.lang.Repl", MainClassApplicationTypeFactory.descr("LBL_Clojure"), MainClassApplicationTypeFactory.descr("DESCR_Clojure"), "org/graalvm/visualvm/application/type/resources/Clojure.png"}, {"org.codehaus.groovy.tools.GroovyStarter", MainClassApplicationTypeFactory.descr("LBL_Groovy"), MainClassApplicationTypeFactory.descr("DESCR_Groovy"), "org/graalvm/visualvm/application/type/resources/Groovy.png"}, {"org.python.util.jython", MainClassApplicationTypeFactory.descr("LBL_Jython"), MainClassApplicationTypeFactory.descr("DESCR_Jython"), "org/graalvm/visualvm/application/type/resources/Jython.png"}, {"org.gradle.launcher.daemon.bootstrap.GradleDaemon", MainClassApplicationTypeFactory.descr("LBL_Gradle"), MainClassApplicationTypeFactory.descr("DESCR_Gradle"), "org/graalvm/visualvm/application/type/resources/Gradle.png"}, {"org.gradle.launcher.GradleMain", MainClassApplicationTypeFactory.descr("LBL_GradleLauncher"), MainClassApplicationTypeFactory.descr("DESCR_GradleLauncher"), "org/graalvm/visualvm/application/type/resources/Gradle.png"}};
    Map<String, String[]> map = new HashMap<String, String[]>();

    private static String descr(String key) {
        return NbBundle.getMessage(MainClassApplicationTypeFactory.class, (String)key);
    }

    protected MainClassApplicationTypeFactory() {
        for (String[] appDesc : this.appmatrix) {
            this.map.put(appDesc[0], appDesc);
        }
    }

    public ApplicationType createModelFor(Application appl) {
        String mainClass;
        Jvm jvm = JvmFactory.getJVMFor(appl);
        if (jvm.isBasicInfoSupported() && (mainClass = jvm.getMainClass()) != null) {
            return this.createApplicationTypeFor(appl, jvm, mainClass);
        }
        return null;
    }

    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String[] appDesc = this.map.get(mainClass);
        if (appDesc != null) {
            return new MainClassApplicationType(app, appDesc[1], appDesc[2], appDesc[3]);
        }
        return null;
    }
}

