/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import org.netbeans.core.startup.ManifestSection;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public abstract class CoreBridge {
    public static CoreBridge getDefault() {
        CoreBridge coreBridge = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (coreBridge == null) {
            coreBridge = new FakeBridge();
        }
        return coreBridge;
    }

    protected abstract void attachToCategory(Object var1);

    protected abstract void loadDefaultSection(ManifestSection var1, InstanceContent.Convertor<ManifestSection, Object> var2, boolean var3);

    protected abstract void loadActionSection(ManifestSection.ActionSection var1, boolean var2) throws Exception;

    protected abstract void loadLoaderSection(ManifestSection.LoaderSection var1, boolean var2) throws Exception;

    protected abstract void loaderPoolTransaction(boolean var1);

    public abstract void registerPropertyEditors();

    public abstract Lookup lookupCacheLoad();

    public abstract void setStatusText(String var1);

    public abstract void initializePlaf(Class var1, int var2, URL var3);

    public abstract int cli(String[] var1, InputStream var2, OutputStream var3, OutputStream var4, File var5);

    public static void defineOsTokens(Collection<? super String> collection) {
        if (BaseUtilities.isUnix()) {
            collection.add("org.openide.modules.os.Unix");
            if (!BaseUtilities.isMac()) {
                collection.add("org.openide.modules.os.PlainUnix");
            }
        }
        if (BaseUtilities.isWindows()) {
            collection.add("org.openide.modules.os.Windows");
        }
        if (BaseUtilities.isMac()) {
            collection.add("org.openide.modules.os.MacOSX");
        }
        if ((BaseUtilities.getOperatingSystem() & 0x800) != 0) {
            collection.add("org.openide.modules.os.OS2");
        }
        if ((BaseUtilities.getOperatingSystem() & 0x10) != 0) {
            collection.add("org.openide.modules.os.Linux");
        }
        if ((BaseUtilities.getOperatingSystem() & 8) != 0) {
            collection.add("org.openide.modules.os.Solaris");
        }
        if (CoreBridge.isJavaFX(new File(System.getProperty("java.home")))) {
            collection.add("org.openide.modules.jre.JavaFX");
        }
        collection.add("org.openide.modules.arch." + System.getProperty("os.arch"));
    }

    static boolean isJavaFX(File file) {
        try {
            Class.forName("javafx.application.Platform");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new File(new File(file, "lib"), "jfxrt.jar").exists() || new File(new File(new File(file, "lib"), "ext"), "jfxrt.jar").exists();
        }
    }

    private static final class FakeBridge
    extends CoreBridge {
        private FakeBridge() {
        }

        @Override
        protected void attachToCategory(Object object) {
        }

        protected void loadDefaultSection(ManifestSection manifestSection, InstanceContent.Convertor convertor, boolean bl) {
        }

        @Override
        protected void loadActionSection(ManifestSection.ActionSection actionSection, boolean bl) throws Exception {
            actionSection.getInstance();
        }

        @Override
        protected void loadLoaderSection(ManifestSection.LoaderSection loaderSection, boolean bl) throws Exception {
        }

        @Override
        protected void loaderPoolTransaction(boolean bl) {
        }

        protected void addToSplashMaxSteps(int n) {
        }

        protected void incrementSplashProgressBar() {
        }

        @Override
        public Lookup lookupCacheLoad() {
            return Lookups.forPath((String)"Services");
        }

        public void lookupCacheStore(Lookup lookup) throws IOException {
        }

        @Override
        public void setStatusText(String string) {
            System.err.println(string);
        }

        @Override
        public void initializePlaf(Class clazz, int n, URL uRL) {
        }

        @Override
        public void registerPropertyEditors() {
        }

        @Override
        public int cli(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, File file) {
            return 0;
        }
    }
}

