/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SmartSoleProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("#GTXRP=").number("(d+),").number("d+,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(-?d+),").number("(d+),").number("([01]),").number("(d+),").number("(d+.d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(d+.d+),").number("(d+)").compile();

    public SmartSoleProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setFixTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setAltitude(parser.nextInt().intValue());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setValid(parser.nextInt() == 1);
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        position.setDeviceTime(parser.nextDateTime());
        position.set("battery", parser.nextDouble());
        position.set("status", parser.nextInt());
        return position;
    }
}

