/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Gs100ProtocolDecoder
extends BaseProtocolDecoder {
    public Gs100ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String header = buf.readCharSequence(2, StandardCharsets.US_ASCII).toString();
        if (header.equals("GL")) {
            buf.skipBytes(1);
            String imei = buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (channel != null && deviceSession != null) {
                ByteBuf response = Unpooled.copiedBuffer((CharSequence)"GS100", (Charset)StandardCharsets.US_ASCII);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            int endIndex = buf.readUnsignedByte() + buf.readerIndex();
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            int status = buf.readUnsignedMedium();
            position.set("status", status);
            if (BitUtil.check(status, 23)) {
                DateBuilder dateBuilder = new DateBuilder().setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setYear(BcdUtil.readInteger(buf, 2));
                position.setTime(dateBuilder.getDate());
                position.setValid(true);
                String coordinates = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(9));
                position.setLongitude((double)Integer.parseInt(coordinates.substring(0, 3)) + (double)Integer.parseInt(coordinates.substring(3, 9)) * 1.0E-4 / 60.0);
                position.setLatitude((double)Integer.parseInt(coordinates.substring(10, 12)) + (double)Integer.parseInt(coordinates.substring(12, 18)) * 1.0E-4 / 60.0);
                int flags = Integer.parseInt(coordinates.substring(9, 10), 16);
                if (!BitUtil.check(flags, 3)) {
                    position.setLongitude(-position.getLongitude());
                }
                if (!BitUtil.check(flags, 2)) {
                    position.setLatitude(-position.getLatitude());
                }
                String other = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(4));
                position.setSpeed(UnitsConverter.knotsFromKph((double)Integer.parseInt(other.substring(0, 5)) * 0.01));
                position.setCourse(Integer.parseInt(other.substring(5, 8)));
            } else {
                this.getLastLocation(position, null);
            }
            positions.add(position);
            buf.readerIndex(endIndex);
        }
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeCharSequence((CharSequence)"GS100", StandardCharsets.US_ASCII);
            response.writeByte(count);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions.isEmpty() ? null : positions;
    }
}

