/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class ListAdaptor
extends AbstractAutoCompleteAdaptor
implements ListSelectionListener {
    JList list;
    JTextComponent textComponent;
    ObjectToStringConverter stringConverter;

    public ListAdaptor(JList list, JTextComponent textComponent) {
        this(list, textComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public ListAdaptor(JList list, JTextComponent textComponent, ObjectToStringConverter stringConverter) {
        this.list = list;
        this.textComponent = textComponent;
        this.stringConverter = stringConverter;
        list.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.getTextComponent().setText(this.stringConverter.getPreferredStringForItem(this.list.getSelectedValue()));
        this.markEntireText();
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    public Object getItem(int index) {
        return this.list.getModel().getElementAt(index);
    }

    public void setSelectedItem(Object item) {
        this.list.setSelectedValue(item, true);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }
}

