/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiHttpSession;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiHttpServletRequestWrapper.class);
    private String authType = null;
    private String remoteUser = null;
    private final ServletContext context;
    private final ServletContext osgiContext;
    private final OsgiContextModel osgiContextModel;
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private volatile OsgiHttpSession session;

    public OsgiHttpServletRequestWrapper(HttpServletRequest request, ServletContext context, OsgiSessionAttributeListener osgiSessionsBridge) {
        super(request);
        this.context = context;
        if (context instanceof OsgiServletContext) {
            this.osgiContext = context;
            this.osgiContextModel = ((OsgiServletContext)this.osgiContext).getOsgiContextModel();
        } else if (context instanceof OsgiScopedServletContext) {
            this.osgiContext = context;
            this.osgiContextModel = ((OsgiScopedServletContext)this.osgiContext).getOsgiContextModel();
        } else {
            this.osgiContext = null;
            this.osgiContextModel = null;
        }
        this.osgiSessionsBridge = osgiSessionsBridge;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            this.session = null;
        }
        if (this.session == null) {
            OsgiHttpServletRequestWrapper osgiHttpServletRequestWrapper = this;
            synchronized (osgiHttpServletRequestWrapper) {
                if (this.session == null) {
                    HttpSession original = super.getSession(create);
                    if (original == null) {
                        return null;
                    }
                    if (original instanceof OsgiHttpSession) {
                        this.session = (OsgiHttpSession)original;
                        return this.session;
                    }
                    this.session = new OsgiHttpSession(original, this.osgiContext, this.context, this.osgiSessionsBridge);
                }
            }
        }
        return this.session;
    }

    public void setAttribute(String name, Object o) {
        if ("org.osgi.service.http.authentication.type".equals(name)) {
            if (o != null && !(o instanceof String)) {
                String message = "Wrong type of org.osgi.service.http.authentication.type attribute. Expected String, was " + o.getClass();
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            this.authType = o == null ? null : (String)o;
        } else if ("org.osgi.service.http.authentication.remote.user".equals(name)) {
            if (o != null && !(o instanceof String)) {
                String message = "Wrong type of org.osgi.service.http.authentication.remote.user attribute. Expected String, was " + o.getClass();
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            this.remoteUser = o == null ? null : (String)o;
        }
        super.setAttribute(name, o);
    }

    public String getAuthType() {
        return this.authType == null ? super.getAuthType() : this.authType;
    }

    public String getRemoteUser() {
        return this.remoteUser == null ? super.getRemoteUser() : this.remoteUser;
    }

    public Principal getUserPrincipal() {
        return super.getUserPrincipal();
    }
}

