/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.repository.ChainedWorkspaceReader;

public final class MavenChainedWorkspaceReader
implements MavenWorkspaceReader {
    private ChainedWorkspaceReader delegate;
    private WorkspaceReader[] readers;

    private MavenChainedWorkspaceReader(WorkspaceReader ... readers) {
        this.delegate = new ChainedWorkspaceReader(readers);
        this.readers = readers;
    }

    public Model findModel(Artifact artifact) {
        for (WorkspaceReader workspaceReader : this.readers) {
            Model model;
            if (!(workspaceReader instanceof MavenWorkspaceReader) || (model = ((MavenWorkspaceReader)workspaceReader).findModel(artifact)) == null) continue;
            return model;
        }
        return null;
    }

    public WorkspaceRepository getRepository() {
        return this.delegate.getRepository();
    }

    public File findArtifact(Artifact artifact) {
        return this.delegate.findArtifact(artifact);
    }

    public List<String> findVersions(Artifact artifact) {
        return this.delegate.findVersions(artifact);
    }

    public static WorkspaceReader of(Collection<WorkspaceReader> workspaceReaderCollection) {
        WorkspaceReader[] readers = workspaceReaderCollection.toArray(new WorkspaceReader[0]);
        if (readers.length == 1) {
            return readers[0];
        }
        return new MavenChainedWorkspaceReader(readers);
    }
}

