/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandPoseTypeInfoMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackerCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HAND;
    public static final int HANDJOINTSET;

    public XrHandTrackerCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandTrackerCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackerCreateInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandTrackerCreateInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrHandEXT")
    public int hand() {
        return XrHandTrackerCreateInfoEXT.nhand(this.address());
    }

    @NativeType(value="XrHandJointSetEXT")
    public int handJointSet() {
        return XrHandTrackerCreateInfoEXT.nhandJointSet(this.address());
    }

    public XrHandTrackerCreateInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackerCreateInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT type$Default() {
        return this.type(1000051001);
    }

    public XrHandTrackerCreateInfoEXT next(@NativeType(value="void const *") long value) {
        XrHandTrackerCreateInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT next(XrHandPoseTypeInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandTrackerCreateInfoEXT hand(@NativeType(value="XrHandEXT") int value) {
        XrHandTrackerCreateInfoEXT.nhand(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT handJointSet(@NativeType(value="XrHandJointSetEXT") int value) {
        XrHandTrackerCreateInfoEXT.nhandJointSet(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT set(int type, long next, int hand, int handJointSet) {
        this.type(type);
        this.next(next);
        this.hand(hand);
        this.handJointSet(handJointSet);
        return this;
    }

    public XrHandTrackerCreateInfoEXT set(XrHandTrackerCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandTrackerCreateInfoEXT malloc() {
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrHandTrackerCreateInfoEXT calloc() {
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrHandTrackerCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrHandTrackerCreateInfoEXT create(long address) {
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)address);
    }

    @Nullable
    public static XrHandTrackerCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrHandTrackerCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackerCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrHandTrackerCreateInfoEXT malloc(MemoryStack stack) {
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandTrackerCreateInfoEXT calloc(MemoryStack stack) {
        return (XrHandTrackerCreateInfoEXT)XrHandTrackerCreateInfoEXT.wrap(XrHandTrackerCreateInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandTrackerCreateInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nhand(long struct) {
        return UNSAFE.getInt(null, struct + (long)HAND);
    }

    public static int nhandJointSet(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDJOINTSET);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nhand(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HAND, value);
    }

    public static void nhandJointSet(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDJOINTSET, value);
    }

    static {
        Struct.Layout layout = XrHandTrackerCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{XrHandTrackerCreateInfoEXT.__member((int)4), XrHandTrackerCreateInfoEXT.__member((int)POINTER_SIZE), XrHandTrackerCreateInfoEXT.__member((int)4), XrHandTrackerCreateInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HAND = layout.offsetof(2);
        HANDJOINTSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackerCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final XrHandTrackerCreateInfoEXT ELEMENT_FACTORY = XrHandTrackerCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandTrackerCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackerCreateInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandTrackerCreateInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrHandEXT")
        public int hand() {
            return XrHandTrackerCreateInfoEXT.nhand(this.address());
        }

        @NativeType(value="XrHandJointSetEXT")
        public int handJointSet() {
            return XrHandTrackerCreateInfoEXT.nhandJointSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackerCreateInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandTrackerCreateInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrHandPoseTypeInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer hand(@NativeType(value="XrHandEXT") int value) {
            XrHandTrackerCreateInfoEXT.nhand(this.address(), value);
            return this;
        }

        public Buffer handJointSet(@NativeType(value="XrHandJointSetEXT") int value) {
            XrHandTrackerCreateInfoEXT.nhandJointSet(this.address(), value);
            return this;
        }
    }
}

