/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.api;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.jboss.logging.Logger;
import org.keycloak.federation.sssd.api.SSSDException;
import org.keycloak.models.UserModel;

public class Sssd {
    private final DBusConnection dBusConnection;
    private final String username;
    private static final Logger logger = Logger.getLogger(Sssd.class);

    public Sssd(String username, DBusConnection dbusConnection) throws SSSDException {
        this.username = username;
        this.dBusConnection = dbusConnection;
    }

    public static String getRawAttribute(Variant variant) {
        List value;
        if (variant != null && variant.getType() instanceof DBusListType && !(value = (List)variant.getValue()).isEmpty()) {
            return value.iterator().next().toString();
        }
        return null;
    }

    public List<String> getGroups() {
        List<String> userGroups;
        try {
            InfoPipe infoPipe = this.dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            userGroups = infoPipe.getUserGroups(this.username);
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's groups from SSSD. Check if SSSD service is active.", e);
        }
        return userGroups;
    }

    public User getUser() {
        String[] attr = new String[]{"mail", "givenname", "sn", "telephoneNumber"};
        User user = null;
        try {
            InfoPipe infoPipe = this.dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            user = new User(infoPipe.getUserAttributes(this.username, Arrays.asList(attr)));
        }
        catch (Exception e) {
            logger.debugf((Throwable)e, "Failed to retrieve attributes for user '%s'. Check if SSSD service is active.", (Object)this.username);
        }
        return user;
    }

    public class User {
        private final String email;
        private final String firstName;
        private final String lastName;

        public User(Map<String, Variant> userAttributes) {
            this.email = Sssd.getRawAttribute(userAttributes.get("mail"));
            this.firstName = Sssd.getRawAttribute(userAttributes.get("givenname"));
            this.lastName = Sssd.getRawAttribute(userAttributes.get("sn"));
        }

        public String getEmail() {
            return this.email;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            UserModel userModel = (UserModel)o;
            if (this.firstName != null && !this.firstName.equals(userModel.getFirstName())) {
                return false;
            }
            if (this.lastName != null && !this.lastName.equals(userModel.getLastName())) {
                return false;
            }
            if (this.email != null) {
                return this.email.equalsIgnoreCase(userModel.getEmail());
            }
            return userModel.getEmail() == null;
        }

        public int hashCode() {
            int result = this.email != null ? this.email.hashCode() : 0;
            result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
            result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
            return result;
        }
    }
}

