/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.tracker;

import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingValueTransformer;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ConfigTrackingWriter {
    private static boolean matches(String name, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static void write(Map<String, String> readOptions, ConfigTrackingConfig config, BuildTimeConfigurationReader.ReadResult configReadResult, LaunchMode launchMode, Path buildDirectory) {
        if (!config.enabled()) {
            return;
        }
        Path file = config.file().orElse(null);
        if (file == null) {
            Path dir = config.directory().orElseGet(() -> (buildDirectory.getParent() == null ? buildDirectory : buildDirectory.getParent()).resolve(".quarkus"));
            file = dir.resolve(config.filePrefix() + "-" + launchMode.getDefaultProfile() + config.fileSuffix());
        } else if (!file.isAbsolute()) {
            file = config.directory().orElse(buildDirectory).resolve(file);
        }
        if (file.getParent() != null) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ConfigTrackingWriter.write(readOptions, config, configReadResult, file);
    }

    public static void write(Map<String, String> readOptions, ConfigTrackingConfig config, BuildTimeConfigurationReader.ReadResult configReadResult, Path file) {
        List<Pattern> excludePatterns = config.getExcludePatterns();
        ConfigTrackingValueTransformer valueTransformer = ConfigTrackingValueTransformer.newInstance(config);
        Map<String, String> allBuildTimeValues = configReadResult.getAllBuildTimeValues();
        Map<String, String> buildTimeRuntimeValues = configReadResult.getBuildTimeRunTimeValues();
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            ArrayList<String> names = new ArrayList<String>(readOptions.size());
            for (String name : readOptions.keySet()) {
                if (!allBuildTimeValues.containsKey(name) && !buildTimeRuntimeValues.containsKey(name) || ConfigTrackingWriter.matches(name, excludePatterns)) continue;
                names.add(name);
            }
            Collections.sort(names);
            for (String name : names) {
                String value = valueTransformer.transform(name, readOptions.get(name));
                ConfigTrackingWriter.write(writer, name, value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Writer writer, String name, String value) throws IOException {
        PropertyUtils.store((Writer)writer, (String)name, (String)value);
    }
}

