/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.tool.schema.internal.ColumnDefinitions;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardTableExporter
implements Exporter<Table> {
    protected final Dialect dialect;

    public StandardTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedName tableName = StandardTableExporter.getTableName(table);
        try {
            String formattedTableName = context.format(tableName);
            StringBuilder createTable = new StringBuilder();
            String viewQuery = table.getViewQuery();
            if (viewQuery != null) {
                createTable.append("create view ").append(formattedTableName).append(" as ").append(viewQuery);
            } else {
                String rowIdColumn;
                StringBuilder extra = new StringBuilder();
                createTable.append(this.tableCreateString(table.hasPrimaryKey())).append(' ').append(formattedTableName).append(" (");
                boolean isFirst = true;
                for (Column column : table.getColumns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        createTable.append(", ");
                    }
                    ColumnDefinitions.appendColumn(createTable, column, table, metadata, this.dialect, context);
                    extra.append(column.getValue().getExtraCreateTableInfo());
                }
                if (table.getRowId() != null && (rowIdColumn = this.dialect.getRowIdColumnString(table.getRowId())) != null) {
                    createTable.append(", ").append(rowIdColumn);
                }
                if (table.hasPrimaryKey()) {
                    createTable.append(", ").append(table.getPrimaryKey().sqlConstraintString(this.dialect));
                }
                createTable.append(this.dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table, context));
                this.applyTableCheck(table, createTable);
                createTable.append(')');
                createTable.append((CharSequence)extra);
                if (table.getComment() != null) {
                    createTable.append(this.dialect.getTableComment(table.getComment()));
                }
                this.applyTableTypeString(createTable);
            }
            ArrayList<String> sqlStrings = new ArrayList<String>();
            sqlStrings.add(createTable.toString());
            this.applyComments(table, formattedTableName, sqlStrings);
            this.applyInitCommands(table, sqlStrings, context);
            return sqlStrings.toArray(StringHelper.EMPTY_STRINGS);
        }
        catch (Exception e) {
            throw new MappingException("Error creating SQL 'create' commands for table '" + table.getName() + "' [" + e.getMessage() + "]", e);
        }
    }

    @Deprecated
    protected void applyComments(Table table, QualifiedTableName tableName, List<String> sqlStrings) {
        this.applyComments(table, tableName.toString(), sqlStrings);
    }

    protected void applyComments(Table table, String formattedTableName, List<String> sqlStrings) {
        if (this.dialect.supportsCommentOn()) {
            if (table.getComment() != null && this.dialect.getTableComment("").isEmpty()) {
                sqlStrings.add("comment on table " + formattedTableName + " is '" + table.getComment() + "'");
            }
            if (this.dialect.getColumnComment("").isEmpty()) {
                for (Column column : table.getColumns()) {
                    String columnComment = column.getComment();
                    if (columnComment == null) continue;
                    sqlStrings.add("comment on column " + formattedTableName + "." + column.getQuotedName(this.dialect) + " is '" + columnComment + "'");
                }
            }
        }
    }

    protected void applyInitCommands(Table table, List<String> sqlStrings, SqlStringGenerationContext context) {
        for (InitCommand initCommand : table.getInitCommands(context)) {
            Collections.addAll(sqlStrings, initCommand.getInitCommands());
        }
    }

    protected void applyTableTypeString(StringBuilder buf) {
        buf.append(this.dialect.getTableTypeString());
    }

    protected void applyTableCheck(Table table, StringBuilder buf) {
        if (this.dialect.supportsTableCheck()) {
            for (CheckConstraint constraint : table.getChecks()) {
                buf.append(",").append(constraint.constraintString());
            }
            AggregateSupport aggregateSupport = this.dialect.getAggregateSupport();
            if (aggregateSupport != null && aggregateSupport.supportsComponentCheckConstraints()) {
                for (Column column : table.getColumns()) {
                    AggregateColumn aggregateColumn;
                    if (!(column instanceof AggregateColumn) || this.isArray(aggregateColumn = (AggregateColumn)column)) continue;
                    this.applyAggregateColumnCheck(buf, aggregateColumn);
                }
            }
        }
    }

    private boolean isArray(AggregateColumn aggregateColumn) {
        BasicValue value = (BasicValue)aggregateColumn.getValue();
        switch (value.getResolution().getJdbcType().getDefaultSqlTypeCode()) {
            case 2003: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: {
                return true;
            }
        }
        return false;
    }

    private void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
        AggregateSupport aggregateSupport = this.dialect.getAggregateSupport();
        int checkStart = buf.length();
        buf.append(", check (");
        int start = buf.length();
        this.applyAggregateColumnCheck(buf, "", aggregateColumn, null, aggregateSupport, aggregateColumn.getComponent());
        if (buf.length() == start) {
            buf.setLength(checkStart);
        } else {
            buf.append(')');
        }
    }

    private String applyAggregateColumnCheck(StringBuilder buf, String separator, AggregateColumn aggregateColumn, String aggregatePath, AggregateSupport aggregateSupport, Value value) {
        block7: {
            block6: {
                block8: {
                    if (!(value instanceof Component)) break block6;
                    Component component = (Component)value;
                    AggregateColumn subAggregateColumn = component.getAggregateColumn();
                    if (subAggregateColumn == null || this.isArray(subAggregateColumn)) break block7;
                    String subAggregatePath = subAggregateColumn.getAggregateReadExpressionTemplate(this.dialect).replace("$PlaceHolder$.", "");
                    int checkStart = buf.length();
                    if (subAggregateColumn.isNullable()) {
                        buf.append(subAggregatePath);
                        buf.append(" is null or (");
                    }
                    int start = buf.length();
                    separator = "";
                    for (Property property : component.getProperties()) {
                        separator = this.applyAggregateColumnCheck(buf, separator, subAggregateColumn, subAggregatePath, aggregateSupport, property.getValue());
                    }
                    if (buf.length() != start) break block8;
                    buf.setLength(checkStart);
                    break block7;
                }
                if (!aggregateColumn.isNullable()) break block7;
                buf.append(')');
                break block7;
            }
            for (Column subColumn : value.getColumns()) {
                String checkConstraint = StandardTableExporter.getCheckConstraint(subColumn);
                if (subColumn.isNullable() && checkConstraint == null) continue;
                String subColumnName = subColumn.getQuotedName(this.dialect);
                String columnExpression = aggregateSupport.aggregateComponentCustomReadExpression(subColumnName, subColumnName, aggregatePath, subColumnName, aggregateColumn, subColumn);
                if (!subColumn.isNullable()) {
                    buf.append(separator);
                    buf.append(columnExpression);
                    buf.append(" is not null");
                    separator = " and ";
                }
                if (checkConstraint == null) continue;
                if (subColumn.isNullable()) {
                    buf.append(separator);
                    buf.append('(');
                    buf.append(columnExpression);
                    buf.append(" is null");
                    separator = " or ";
                }
                buf.append(separator);
                buf.append(checkConstraint.replace(subColumnName, columnExpression));
                if (subColumn.isNullable()) {
                    buf.append(')');
                }
                separator = " and ";
            }
        }
        return separator;
    }

    private static String getCheckConstraint(Column subColumn) {
        List<CheckConstraint> checkConstraints = subColumn.getCheckConstraints();
        if (checkConstraints.isEmpty()) {
            return null;
        }
        if (checkConstraints.size() > 1) {
            throw new MappingException("Multiple check constraints not supported for aggregate columns");
        }
        return checkConstraints.get(0).getConstraint();
    }

    protected String tableCreateString(boolean hasPrimaryKey) {
        return hasPrimaryKey ? this.dialect.getCreateTableString() : this.dialect.getCreateMultisetTableString();
    }

    @Override
    public String[] getSqlDropStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        StringBuilder dropTable = new StringBuilder();
        if (table.getViewQuery() == null) {
            dropTable.append("drop table ");
        } else {
            dropTable.append("drop view ");
        }
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            dropTable.append("if exists ");
        }
        dropTable.append(context.format(StandardTableExporter.getTableName(table))).append(this.dialect.getCascadeConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            dropTable.append(" if exists");
        }
        return new String[]{dropTable.toString()};
    }

    private static QualifiedName getTableName(Table table) {
        return new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
    }
}

