/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.NaturalIdStatistics;
import org.hibernate.stat.internal.AbstractCacheableDataStatistics;

public class NaturalIdStatisticsImpl
extends AbstractCacheableDataStatistics
implements NaturalIdStatistics,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String rootEntityName;
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong executionCount = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong executionMaxTime = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong totalExecutionTime = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized Lock readLock;
    private final @UnknownKeyFor @NonNull @Initialized Lock writeLock;

    NaturalIdStatisticsImpl(@UnknownKeyFor @NonNull @Initialized EntityPersister rootEntityDescriptor) {
        super(() -> rootEntityDescriptor.getNaturalIdCacheAccessStrategy() != null ? rootEntityDescriptor.getNaturalIdCacheAccessStrategy().getRegion() : null);
        this.rootEntityName = rootEntityDescriptor.getRootEntityName();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionCount() {
        return this.executionCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long avgExecutionTime = 0L;
            if (this.executionCount.get() > 0L) {
                avgExecutionTime = this.totalExecutionTime.get() / this.executionCount.get();
            }
            long l = avgExecutionTime;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryExecuted(@UnknownKeyFor @NonNull @Initialized long time) {
        this.readLock.lock();
        try {
            long old = this.executionMinTime.get();
            while (time < old && !this.executionMinTime.compareAndSet(old, time)) {
                old = this.executionMinTime.get();
            }
            old = this.executionMaxTime.get();
            while (time > old && !this.executionMaxTime.compareAndSet(old, time)) {
                old = this.executionMaxTime.get();
            }
            this.executionCount.getAndIncrement();
            this.totalExecutionTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder buf = new StringBuilder().append("NaturalIdCacheStatistics").append("[rootEntityName=").append(this.rootEntityName).append(",executionCount=").append(this.executionCount).append(",executionAvgTime=").append(this.getExecutionAvgTime()).append(",executionMinTime=").append(this.executionMinTime).append(",executionMaxTime=").append(this.executionMaxTime);
        this.appendCacheStats(buf);
        return buf.append(']').toString();
    }
}

