/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.dialect.StructAttributeValues;
import org.hibernate.dialect.StructHelper;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;

@Internal
public class XmlHelper {
    public static final String ROOT_TAG = "e";
    private static final String START_TAG = "<e>";
    private static final String END_TAG = "</e>";

    private static Object fromEscapedString(JdbcMapping jdbcMapping, String string, int start, int end) {
        String unescaped = XmlHelper.unescape(string, start, end);
        return XmlHelper.fromString(jdbcMapping, unescaped, 0, unescaped.length());
    }

    private static Object fromString(JdbcMapping jdbcMapping, String string, int start, int end) {
        return jdbcMapping.getJdbcJavaType().fromEncodedString(string, start, end);
    }

    private static Object fromRawObject(JdbcMapping jdbcMapping, Object raw, WrapperOptions options) {
        return jdbcMapping.getJdbcJavaType().wrap(raw, options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String unescape(String string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        block9: for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '&': {
                    if (i + 3 >= end) throw new IllegalArgumentException("Illegal XML content: " + string.substring(start, end));
                    char c1 = string.charAt(i + 1);
                    switch (c1) {
                        case 'l': {
                            if (string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') continue block9;
                            sb.append('<');
                            i += 3;
                            continue block9;
                        }
                        case 'a': {
                            if (i + 4 >= end || string.charAt(i + 2) != 'm' || string.charAt(i + 3) != 'p' || string.charAt(i + 4) != ';') continue block9;
                            sb.append('&');
                            i += 4;
                            continue block9;
                        }
                        case 'g': {
                            if (string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') continue block9;
                            sb.append('>');
                            i += 3;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal XML content: " + string.substring(start, end));
                        }
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static Object fromString(EmbeddableMappingType embeddableMappingType, String string, WrapperOptions options, int selectableIndex, int start, int end) {
        JdbcMapping jdbcMapping = embeddableMappingType.getJdbcValueSelectable(selectableIndex).getJdbcMapping();
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                Class<?> javaTypeClass = jdbcMapping.getMappedJavaType().getJavaTypeClass();
                if (javaTypeClass.isEnum()) {
                    return javaTypeClass.getEnumConstants()[(Integer)IntegerJavaType.INSTANCE.fromEncodedString(string, start, end)];
                }
                return XmlHelper.fromString(jdbcMapping, string, start, end);
            }
            case 91: {
                return XmlHelper.fromRawObject(jdbcMapping, JdbcDateJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 92: 
            case 2013: 
            case 3007: {
                return XmlHelper.fromRawObject(jdbcMapping, JdbcTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 93: {
                return XmlHelper.fromRawObject(jdbcMapping, JdbcTimestampJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 2014: 
            case 3003: {
                return XmlHelper.fromRawObject(jdbcMapping, OffsetDateTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case -4: 
            case -3: 
            case -2: 
            case 3000: 
            case 4003: {
                return XmlHelper.fromRawObject(jdbcMapping, Base64.getDecoder().decode(string.substring(start, end)), options);
            }
        }
        return XmlHelper.fromEscapedString(jdbcMapping, string, start, end);
    }

    public static <X> X fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        Object[] array;
        int end;
        if (!string.startsWith(START_TAG) || !string.endsWith(END_TAG)) {
            throw new IllegalArgumentException("Illegal XML for struct: " + string);
        }
        if (embeddableMappingType == null) {
            assert (!returnEmbeddable);
            ArrayList<Object> values = new ArrayList<Object>(8);
            end = XmlHelper.fromString(string, values, START_TAG.length());
            array = values.toArray();
        } else {
            array = new Object[embeddableMappingType.getJdbcValueCount() + (embeddableMappingType.isPolymorphic() ? 1 : 0)];
            end = XmlHelper.fromString(embeddableMappingType, string, returnEmbeddable, options, array, START_TAG.length());
        }
        assert (end + END_TAG.length() == string.length());
        if (returnEmbeddable) {
            StructAttributeValues attributeValues = StructHelper.getAttributeValues(embeddableMappingType, array, options);
            return (X)StructHelper.instantiate(embeddableMappingType, attributeValues, options.getSessionFactory());
        }
        return (X)array;
    }

    private static int fromString(String string, List<Object> values, int start) {
        int tagNameStart = -1;
        int contentStart = -1;
        String tagName = null;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (tagNameStart == -1) {
                        if (string.charAt(i + 1) == '/') {
                            assert (tagName == null);
                            assert (contentStart == -1);
                            return i;
                        }
                        tagNameStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    if (string.charAt(i + 1) == '/') {
                        assert (tagName != null);
                        values.add(XmlHelper.unescape(string, contentStart, i));
                    } else {
                        ArrayList<Object> subValues = new ArrayList<Object>(8);
                        int end = XmlHelper.fromString(string, subValues, i);
                        values.add(subValues.toArray());
                        assert (string.charAt(end) == '<');
                        assert (string.charAt(end + 1) == '/');
                        assert (string.regionMatches(end + 2, tagName, 0, tagName.length()));
                        i = end;
                    }
                    i += tagName.length() + 2;
                    tagNameStart = -1;
                    contentStart = -1;
                    tagName = null;
                    continue block5;
                }
                case '>': {
                    if (tagName == null) {
                        assert (contentStart == -1);
                        assert (tagNameStart != -1);
                        tagName = string.substring(tagNameStart, i);
                        contentStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
                case '/': {
                    if (tagName == null) {
                        values.add(null);
                        tagNameStart = -1;
                        assert (string.charAt(++i) == '>');
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
            }
        }
        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
    }

    private static int fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options, Object[] values, int start) throws SQLException {
        int tagNameStart = -1;
        int contentStart = -1;
        String tagName = null;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (tagNameStart == -1) {
                        if (string.charAt(i + 1) == '/') {
                            assert (tagName == null);
                            assert (contentStart == -1);
                            return i;
                        }
                        tagNameStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    if (string.charAt(i + 1) == '/') {
                        assert (tagName != null);
                        int selectableMapping = XmlHelper.getSelectableMapping(embeddableMappingType, tagName);
                        values[selectableMapping] = XmlHelper.fromString(embeddableMappingType, string, options, selectableMapping, contentStart, i);
                    } else {
                        int end;
                        Object[] subValues;
                        int selectableIndex = XmlHelper.getSelectableMapping(embeddableMappingType, tagName);
                        SelectableMapping selectable = embeddableMappingType.getJdbcValueSelectable(selectableIndex);
                        if (!(selectable.getJdbcMapping().getJdbcType() instanceof AggregateJdbcType)) {
                            throw new IllegalArgumentException(String.format("XML starts sub-object for a non-aggregate type at index %d. Selectable [%s] is of type [%s]", i, selectable.getSelectableName(), selectable.getJdbcMapping().getJdbcType().getClass().getName()));
                        }
                        AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)selectable.getJdbcMapping().getJdbcType();
                        EmbeddableMappingType subMappingType = aggregateJdbcType.getEmbeddableMappingType();
                        if (aggregateJdbcType.getJdbcTypeCode() == 2009 || aggregateJdbcType.getDefaultSqlTypeCode() == 2009) {
                            subValues = new Object[subMappingType.getJdbcValueCount()];
                            end = XmlHelper.fromString(subMappingType, string, returnEmbeddable, options, subValues, i);
                        } else {
                            while (string.charAt(i) != '<') {
                                ++i;
                            }
                            end = i;
                            subValues = aggregateJdbcType.extractJdbcValues(CharSequenceHelper.subSequence(string, start, end), options);
                        }
                        if (returnEmbeddable) {
                            StructAttributeValues attributeValues = StructHelper.getAttributeValues(subMappingType, subValues, options);
                            values[selectableIndex] = StructHelper.instantiate(subMappingType, attributeValues, options.getSessionFactory());
                        } else {
                            values[selectableIndex] = subValues;
                        }
                        assert (string.charAt(end) == '<');
                        assert (string.charAt(end + 1) == '/');
                        assert (string.regionMatches(end + 2, tagName, 0, tagName.length()));
                        i = end;
                    }
                    i += tagName.length() + 2;
                    tagNameStart = -1;
                    contentStart = -1;
                    tagName = null;
                    continue block5;
                }
                case '>': {
                    if (tagName == null) {
                        assert (contentStart == -1);
                        assert (tagNameStart != -1);
                        tagName = string.substring(tagNameStart, i);
                        contentStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
                case '/': {
                    if (tagName == null) {
                        tagNameStart = -1;
                        assert (string.charAt(++i) == '>');
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
            }
        }
        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
    }

    public static String toString(EmbeddableMappingType embeddableMappingType, Object value, WrapperOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append(START_TAG);
        XmlHelper.toString(embeddableMappingType, value, options, new XMLAppender(sb));
        sb.append(END_TAG);
        return sb.toString();
    }

    private static void toString(EmbeddableMappingType embeddableMappingType, Object value, WrapperOptions options, XMLAppender sb) {
        Object[] array = embeddableMappingType.getValues(value);
        int numberOfAttributes = embeddableMappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            ValuedModelPart attributeMapping = StructHelper.getEmbeddedPart(embeddableMappingType, i);
            if (attributeMapping instanceof SelectableMapping) {
                SelectableMapping selectable = (SelectableMapping)((Object)attributeMapping);
                String tagName = selectable.getSelectableName();
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
                XmlHelper.serializeValueTo(sb, selectable, array[i], options);
                sb.append('<');
                sb.append('/');
                sb.append(tagName);
                sb.append('>');
                continue;
            }
            if (attributeMapping instanceof EmbeddedAttributeMapping) {
                EmbeddableMappingType mappingType = (EmbeddableMappingType)attributeMapping.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    XmlHelper.toString(mappingType, array[i], options, sb);
                    continue;
                }
                String tagName = aggregateMapping.getSelectableName();
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
                XmlHelper.toString(mappingType, array[i], options, sb);
                sb.append('<');
                sb.append('/');
                sb.append(tagName);
                sb.append('>');
                continue;
            }
            throw new UnsupportedOperationException("Unsupported attribute mapping: " + attributeMapping);
        }
    }

    private static void serializeValueTo(XMLAppender appender, SelectableMapping selectable, Object value, WrapperOptions options) {
        JdbcMapping jdbcMapping = selectable.getJdbcMapping();
        JavaType<?> jdbcJavaType = jdbcMapping.getJdbcJavaType();
        Object relationalValue = jdbcMapping.convertToRelationalValue(value);
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (relationalValue instanceof Boolean) {
                    appender.append((Boolean)relationalValue != false ? (char)'1' : '0');
                    break;
                }
            }
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 3015: {
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(relationalValue, jdbcJavaType.getJavaTypeClass(), options));
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (relationalValue instanceof Boolean) {
                    appender.append((Boolean)relationalValue != false ? (char)'Y' : 'N');
                    break;
                }
            }
            case -16: 
            case -1: 
            case 4001: 
            case 4002: {
                appender.startEscaping();
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(relationalValue, jdbcJavaType.getJavaTypeClass(), options));
                appender.endEscaping();
                break;
            }
            case 91: {
                JdbcDateJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Date.class, options));
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                JdbcTimeJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Time.class, options));
                break;
            }
            case 93: {
                JdbcTimestampJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Timestamp.class, options));
                break;
            }
            case 2014: 
            case 3003: {
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(jdbcJavaType.unwrap(value, OffsetDateTime.class, options), appender);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 3000: 
            case 4003: {
                appender.writeBase64(jdbcJavaType.unwrap(relationalValue, byte[].class, options));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in struct: " + jdbcMapping.getJdbcType());
            }
        }
    }

    private static int getSelectableMapping(EmbeddableMappingType embeddableMappingType, String name) {
        int selectableIndex = embeddableMappingType.getSelectableIndex(name);
        if (selectableIndex == -1) {
            throw new IllegalArgumentException(String.format("Could not find selectable [%s] in embeddable type [%s] for JSON processing.", name, embeddableMappingType.getMappedJavaType().getJavaTypeClass().getName()));
        }
        return selectableIndex;
    }

    private static class XMLAppender
    extends OutputStream
    implements SqlAppender {
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        private final StringBuilder sb;
        private boolean escape;
        private OutputStream base64OutputStream;

        public XMLAppender(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void appendSql(String fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(char fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(int value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(long value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(boolean value) {
            this.sb.append(value);
        }

        public String toString() {
            return this.sb.toString();
        }

        public void startEscaping() {
            assert (!this.escape);
            this.escape = true;
        }

        public void endEscaping() {
            assert (this.escape);
            this.escape = false;
        }

        @Override
        public XMLAppender append(char fragment) {
            if (this.escape) {
                this.appendEscaped(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public XMLAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public XMLAppender append(CharSequence csq, int start, int end) {
            if (this.escape) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendEscaped(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        private void appendEscaped(char fragment) {
            switch (fragment) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '&': {
                    this.sb.append("&amp;");
                    break;
                }
                default: {
                    this.sb.append(fragment);
                }
            }
        }

        @Override
        public void write(int v) {
            String hex = Integer.toHexString(v);
            this.sb.ensureCapacity(this.sb.length() + hex.length() + 1);
            if ((hex.length() & 1) == 1) {
                this.sb.append('0');
            }
            this.sb.append(hex);
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.sb.ensureCapacity(this.sb.length() + (len << 1));
            for (int i = 0; i < len; ++i) {
                int v = bytes[off + i] & 0xFF;
                this.sb.append(HEX_ARRAY[v >>> 4]);
                this.sb.append(HEX_ARRAY[v & 0xF]);
            }
        }

        public void writeBase64(byte[] bytes) {
            if (this.base64OutputStream == null) {
                this.base64OutputStream = Base64.getEncoder().wrap(this);
            }
            try {
                this.base64OutputStream.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

