/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.util.AutoCloseableElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
extends AutoCloseableElement
implements XAResource {
    private static final String CLOSED_HANDLER_STRING = XAResourceWrapper.class.getSimpleName() + ".CLOSED_XA_RESOURCE";
    private static final InvocationHandler CLOSED_HANDLER = (proxy, method, args) -> {
        switch (method.getName()) {
            case "close": {
                return Void.TYPE;
            }
            case "isClosed": {
                return Boolean.TRUE;
            }
            case "toString": {
                return CLOSED_HANDLER_STRING;
            }
        }
        throw new SQLException("XAConnection for the XAResource is closed");
    };
    private static final XAResource CLOSED_XA_RESOURCE = (XAResource)Proxy.newProxyInstance(XAResource.class.getClassLoader(), new Class[]{XAResource.class}, CLOSED_HANDLER);
    private final ConnectionHandler handler;
    private XAResource wrappedXAResource;

    public XAResourceWrapper(ConnectionHandler connectionHandler, XAResource resource, AutoCloseableElement head) {
        super(head);
        this.handler = connectionHandler;
        this.wrappedXAResource = resource;
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrappedXAResource == CLOSED_XA_RESOURCE;
    }

    @Override
    public void close() throws Exception {
        this.handler.traceConnectionOperation("xaResource.close()");
        if (this.wrappedXAResource != CLOSED_XA_RESOURCE) {
            this.wrappedXAResource = CLOSED_XA_RESOURCE;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.handler.traceConnectionOperation("xaResource.commit()");
        this.wrappedXAResource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.handler.traceConnectionOperation("xaResource.end()");
        this.wrappedXAResource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.handler.traceConnectionOperation("xaResource.forget()");
        this.wrappedXAResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        this.handler.traceConnectionOperation("xaResource.getTransactionTimeout()");
        return this.wrappedXAResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        this.handler.traceConnectionOperation("xaResource.isSameRM()");
        return this.wrappedXAResource.isSameRM(xares);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.handler.traceConnectionOperation("xaResource.prepare()");
        return this.wrappedXAResource.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        this.handler.traceConnectionOperation("xaResource.recover()");
        return this.wrappedXAResource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.handler.traceConnectionOperation("xaResource.rollback()");
        this.wrappedXAResource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.handler.traceConnectionOperation("xaResource.setTransactionTimeout()");
        return this.wrappedXAResource.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.handler.traceConnectionOperation("xaResource.start()");
        this.wrappedXAResource.start(xid, flags);
    }
}

