/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;

@ProtoTypeId(value=65543)
public class WrapperClusterEvent
implements ClusterEvent {
    @ProtoField(value=1)
    final String eventKey;
    @ProtoField(value=2)
    final String senderAddress;
    @ProtoField(value=3)
    final String senderSite;
    @ProtoField(value=4)
    final SiteFilter siteFilter;
    private final Collection<? extends ClusterEvent> events;

    private WrapperClusterEvent(String eventKey, String senderAddress, String senderSite, SiteFilter siteFilter, Collection<? extends ClusterEvent> events) {
        this.eventKey = Objects.requireNonNull(eventKey);
        this.senderAddress = senderAddress;
        this.senderSite = senderSite;
        this.siteFilter = Objects.requireNonNull(siteFilter);
        this.events = Objects.requireNonNull(events);
    }

    @ProtoFactory
    static WrapperClusterEvent protoFactory(String eventKey, String senderAddress, String senderSite, SiteFilter siteFilter, List<WrappedMessage> eventPS) {
        List<ClusterEvent> events = eventPS.stream().map(WrappedMessage::getValue).map(ClusterEvent.class::cast).toList();
        return new WrapperClusterEvent(eventKey, senderAddress, senderSite, siteFilter, events);
    }

    public static WrapperClusterEvent wrap(String eventKey, Collection<? extends ClusterEvent> events, String senderAddress, String senderSite, ClusterProvider.DCNotify dcNotify, boolean ignoreSender) {
        senderAddress = ignoreSender ? Objects.requireNonNull(senderAddress) : null;
        senderSite = dcNotify == ClusterProvider.DCNotify.ALL_DCS ? null : senderSite;
        SiteFilter siteNotification = switch (dcNotify) {
            default -> throw new IncompatibleClassChangeError();
            case ClusterProvider.DCNotify.ALL_DCS -> SiteFilter.ALL;
            case ClusterProvider.DCNotify.LOCAL_DC_ONLY -> SiteFilter.LOCAL;
            case ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC -> SiteFilter.REMOTE;
        };
        return new WrapperClusterEvent(eventKey, senderAddress, senderSite, siteNotification, events);
    }

    @ProtoField(value=5)
    List<WrappedMessage> getEventPS() {
        return this.events.stream().map(WrappedMessage::new).toList();
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public Collection<? extends ClusterEvent> getDelegateEvents() {
        return this.events;
    }

    public boolean rejectEvent(String mySiteAddress, String mySiteName) {
        return this.senderAddress != null && this.senderAddress.equals(mySiteAddress) || this.senderSite != null && this.siteFilter.reject(this.senderSite, mySiteName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapperClusterEvent that = (WrapperClusterEvent)o;
        return this.eventKey.equals(that.eventKey) && Objects.equals(this.senderAddress, that.senderAddress) && Objects.equals(this.senderSite, that.senderSite) && this.siteFilter == that.siteFilter && this.events.equals(that.events);
    }

    public int hashCode() {
        int result = this.eventKey.hashCode();
        result = 31 * result + Objects.hashCode(this.senderAddress);
        result = 31 * result + Objects.hashCode(this.senderSite);
        result = 31 * result + this.siteFilter.hashCode();
        result = 31 * result + this.events.hashCode();
        return result;
    }

    public String toString() {
        return String.format("WrapperClusterEvent [ eventKey=%s, sender=%s, senderSite=%s, delegateEvents=%s ]", this.eventKey, this.senderAddress, this.senderSite, this.events);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Proto
    @ProtoTypeId(value=65544)
    public static enum SiteFilter {
        ALL{

            @Override
            boolean reject(String senderSite, String mySite) {
                return false;
            }
        }
        ,
        LOCAL{

            @Override
            boolean reject(String senderSite, String mySite) {
                return !Objects.equals(senderSite, mySite);
            }
        }
        ,
        REMOTE{

            @Override
            boolean reject(String senderSite, String mySite) {
                return Objects.equals(senderSite, mySite);
            }
        };


        abstract boolean reject(String var1, String var2);
    }
}

