/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.KeyMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    @Deprecated(forRemoval=true)
    public static boolean isPropertyInRoot(Set<String> roots, NameIterator propertyName) {
        block0: for (String root : roots) {
            if (root.length() == 0) {
                return true;
            }
            if (propertyName.getName().length() <= root.length()) continue;
            NameIterator rootNi = new NameIterator(root);
            while (rootNi.hasNext()) {
                String segment = rootNi.getNextSegment();
                if (!propertyName.hasNext()) {
                    propertyName.goToStart();
                    continue block0;
                }
                String nextSegment = propertyName.getNextSegment();
                if (!segment.equals(nextSegment)) {
                    propertyName.goToStart();
                    continue block0;
                }
                rootNi.next();
                propertyName.next();
                if (rootNi.hasNext() || !propertyName.hasNext()) continue;
                propertyName.goToStart();
                return true;
            }
        }
        return false;
    }

    public static Iterable<String> filterPropertiesInRoots(Iterable<String> properties, Set<String> roots) {
        if (roots.isEmpty()) {
            return properties;
        }
        if (roots.contains("")) {
            return properties;
        }
        ArrayList<String> matchedProperties = new ArrayList<String>();
        for (String property : properties) {
            if (property.startsWith("\"quarkus.")) {
                matchedProperties.add(property);
                continue;
            }
            if (!PropertiesUtil.isPropertyInRoots(property, roots)) continue;
            matchedProperties.add(property);
        }
        return matchedProperties;
    }

    public static boolean isPropertyInRoots(String property, Set<String> roots) {
        for (String root : roots) {
            if (!PropertiesUtil.isPropertyInRoot(property, root)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyInRoot(String property, String root) {
        if (property.length() < root.length()) {
            return false;
        }
        if (property.equals(root)) {
            return true;
        }
        if (property.length() == root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    public static boolean isPropertyQuarkusCompoundName(NameIterator propertyName) {
        return propertyName.getName().startsWith("\"quarkus.");
    }

    public static void filterUnknown(Set<String> unknownProperties, KeyMap<Boolean> filterPatterns) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String unknownProperty : unknownProperties) {
            if (!filterPatterns.hasRootValue(unknownProperty)) continue;
            toRemove.add(unknownProperty);
        }
        unknownProperties.removeAll(toRemove);
    }
}

