/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.jidtype.FromJidTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepListener;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.filter.EventItemsExtensionFilter;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public final class PepManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PepManager.class.getName());
    private static final Map<XMPPConnection, PepManager> INSTANCES = new WeakHashMap<XMPPConnection, PepManager>();
    private static final StanzaFilter PEP_EVENTS_FILTER = new AndFilter(MessageTypeFilter.NORMAL_OR_HEADLINE, FromJidTypeFilter.ENTITY_BARE_JID, EventItemsExtensionFilter.INSTANCE);
    private final Set<PepListener> pepListeners = new CopyOnWriteArraySet<PepListener>();
    private final AsyncButOrdered<EntityBareJid> asyncButOrdered = new AsyncButOrdered();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final PubSubManager pepPubSubManager;
    private final MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> pepEventListeners = new MultiMap();
    private final Map<PepEventListener<?>, PepEventListenerCoupling<?>> listenerToCouplingMap = new HashMap();
    private static final PubSubFeature[] REQUIRED_FEATURES = new PubSubFeature[]{PubSubFeature.auto_create, PubSubFeature.auto_subscribe, PubSubFeature.filtered_notifications};

    public static synchronized PepManager getInstanceFor(XMPPConnection connection) {
        PepManager pepManager = INSTANCES.get(connection);
        if (pepManager == null) {
            pepManager = new PepManager(connection);
            INSTANCES.put(connection, pepManager);
        }
        return pepManager;
    }

    private PepManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        this.pepPubSubManager = PubSubManager.getInstanceFor(connection, null);
        StanzaListener packetListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) {
                final Message message = (Message)stanza;
                final EventElement event = EventElement.from(stanza);
                assert (event != null);
                final EntityBareJid from = message.getFrom().asEntityBareJidIfPossible();
                assert (from != null);
                PepManager.this.asyncButOrdered.performAsyncButOrdered(from, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List nodeListeners;
                        ItemsExtension itemsExtension = (ItemsExtension)event.getEvent();
                        String node2 = itemsExtension.getNode();
                        for (PepListener listener : PepManager.this.pepListeners) {
                            listener.eventReceived(from, event, message);
                        }
                        MultiMap multiMap = PepManager.this.pepEventListeners;
                        synchronized (multiMap) {
                            nodeListeners = PepManager.this.pepEventListeners.getAll(node2);
                            if (nodeListeners.isEmpty()) {
                                return;
                            }
                            nodeListeners = CollectionUtil.newListWith(nodeListeners);
                        }
                        for (PepEventListenerCoupling listener : nodeListeners) {
                            List<? extends NamedElement> items = itemsExtension.getItems();
                            for (NamedElement namedElement : items) {
                                Item item = (Item)namedElement;
                                String id = item.getId();
                                PayloadItem payloadItem = (PayloadItem)item;
                                Object payload = payloadItem.getPayload();
                                listener.invoke(from, payload, id, message);
                            }
                        }
                    }
                });
            }
        };
        connection.addSyncStanzaListener(packetListener, PEP_EVENTS_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends ExtensionElement> boolean addPepEventListener(String node2, Class<E> extensionElementType, PepEventListener<E> pepEventListener) {
        PepEventListenerCoupling pepEventListenerCoupling = new PepEventListenerCoupling(node2, extensionElementType, pepEventListener);
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            if (this.listenerToCouplingMap.containsKey(pepEventListener)) {
                return false;
            }
            this.listenerToCouplingMap.put(pepEventListener, pepEventListenerCoupling);
            boolean listenerForNodeExisted = this.pepEventListeners.put(node2, pepEventListenerCoupling);
            if (!listenerForNodeExisted) {
                this.serviceDiscoveryManager.addFeature(node2 + "+notify");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePepEventListener(PepEventListener<?> pepEventListener) {
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            PepEventListenerCoupling<?> pepEventListenerCoupling = this.listenerToCouplingMap.remove(pepEventListener);
            if (pepEventListenerCoupling == null) {
                return false;
            }
            String node2 = ((PepEventListenerCoupling)pepEventListenerCoupling).node;
            boolean mappingExisted = this.pepEventListeners.removeOne(node2, pepEventListenerCoupling);
            assert (mappingExisted);
            if (!this.pepEventListeners.containsKey(((PepEventListenerCoupling)pepEventListenerCoupling).node)) {
                this.serviceDiscoveryManager.removeFeature(node2 + "+notify");
            }
        }
        return true;
    }

    public PubSubManager getPepPubSubManager() {
        return this.pepPubSubManager;
    }

    @Deprecated
    public boolean addPepListener(PepListener pepListener) {
        return this.pepListeners.add(pepListener);
    }

    @Deprecated
    public boolean removePepListener(PepListener pepListener) {
        return this.pepListeners.remove(pepListener);
    }

    public LeafNode publish(String nodeId, Item item) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        return this.pepPubSubManager.tryToPublishAndPossibleAutoCreate(nodeId, item);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        BareJid localBareJid = connection.getUser().asBareJid();
        return serviceDiscoveryManager.supportsFeatures((Jid)localBareJid, REQUIRED_FEATURES);
    }

    private static final class PepEventListenerCoupling<E extends ExtensionElement> {
        private final String node;
        private final Class<E> extensionElementType;
        private final PepEventListener<E> pepEventListener;

        private PepEventListenerCoupling(String node2, Class<E> extensionElementType, PepEventListener<E> pepEventListener) {
            this.node = node2;
            this.extensionElementType = extensionElementType;
            this.pepEventListener = pepEventListener;
        }

        private void invoke(EntityBareJid from, ExtensionElement payload, String id, Message carrierMessage) {
            if (!this.extensionElementType.isInstance(payload)) {
                LOGGER.warning("Ignoring " + payload + " from " + carrierMessage + " as it is not of type " + this.extensionElementType);
                return;
            }
            ExtensionElement extensionElementPayload = (ExtensionElement)this.extensionElementType.cast(payload);
            this.pepEventListener.onPepEvent(from, extensionElementPayload, id, carrierMessage);
        }
    }
}

