/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.packet;

import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public interface SaslNonza
extends Nonza {
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-sasl";

    @Override
    default public String getNamespace() {
        return NAMESPACE;
    }

    public static class SASLFailure
    extends AbstractError
    implements SaslNonza {
        public static final String ELEMENT = "failure";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "failure");
        private final SASLError saslError;
        private final String saslErrorString;

        public SASLFailure(String saslError) {
            this(saslError, null);
        }

        public SASLFailure(String saslError, Map<String, String> descriptiveTexts) {
            super(descriptiveTexts);
            SASLError error = SASLError.fromString(saslError);
            this.saslError = error == null ? SASLError.not_authorized : error;
            this.saslErrorString = saslError;
        }

        public SASLError getSASLError() {
            return this.saslError;
        }

        public String getSASLErrorString() {
            return this.saslErrorString;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslNonza.NAMESPACE).rightAngleBracket();
            xml.emptyElement(this.saslErrorString);
            this.addDescriptiveTextsAndExtensions(xml);
            xml.closeElement(ELEMENT);
            return xml;
        }

        public String toString() {
            return this.toXML().toString();
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Success
    implements SaslNonza {
        public static final String ELEMENT = "success";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "success");
        private final String data;

        public Success(String data2) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data2);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.optTextChild(this.data, this);
            return xml;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Response
    implements SaslNonza {
        public static final String ELEMENT = "response";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "response");
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String authenticationText) {
            this.authenticationText = StringUtils.returnIfNotEmptyTrimmed(authenticationText);
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.optTextChild(this.authenticationText, this);
            return xml;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Challenge
    implements SaslNonza {
        public static final String ELEMENT = "challenge";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "challenge");
        private final String data;

        public Challenge(String data2) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data2);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.optTextChild(this.data, this);
            return xml;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class AuthMechanism
    implements SaslNonza {
        public static final String ELEMENT = "auth";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "auth");
        private final String mechanism;
        private final String authenticationText;

        public AuthMechanism(String mechanism, String authenticationText) {
            this.mechanism = Objects.requireNonNull(mechanism, "SASL mechanism shouldn't be null.");
            this.authenticationText = StringUtils.requireNotNullNorEmpty(authenticationText, "SASL authenticationText must not be null nor empty (RFC6120 6.4.2)");
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.attribute("mechanism", this.mechanism).rightAngleBracket();
            xml.escape(this.authenticationText);
            xml.closeElement(this);
            return xml;
        }

        public String getMechanism() {
            return this.mechanism;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }
}

