/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public final class TomlPosition {
    private final int line;
    private final int column;

    public static TomlPosition positionAt(int line, int column) {
        if (line < 1) {
            throw new IllegalArgumentException("line must be >= 1");
        }
        if (column < 1) {
            throw new IllegalArgumentException("column must be >= 1");
        }
        return new TomlPosition(line, column);
    }

    private TomlPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    TomlPosition(ParserRuleContext ctx) {
        this(ctx, 0);
    }

    TomlPosition(ParserRuleContext ctx, int offset) {
        Token token = ctx.getStart();
        this.line = token.getLine();
        this.column = token.getCharPositionInLine() + 1 + offset;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TomlPosition)) {
            return false;
        }
        TomlPosition other = (TomlPosition)obj;
        return this.line == other.line && this.column == other.column;
    }

    public int hashCode() {
        return 31 * this.line + this.column;
    }

    public String toString() {
        return "line " + this.line + ", column " + this.column;
    }
}

