/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.util.Formatter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateStep<C extends IncrementalChangesContext>
implements Step<C, UpToDateResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateStep.class);
    private final Step<? super C, ? extends AfterExecutionResult> delegate;

    public SkipUpToDateStep(Step<? super C, ? extends AfterExecutionResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(UnitOfWork work, C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determining if {} is up-to-date", (Object)work.getDisplayName());
        }
        ImmutableList<String> reasons = ((IncrementalChangesContext)context).getRebuildReasons();
        return ((IncrementalChangesContext)context).getChanges().filter(__ -> reasons.isEmpty()).map(changes -> this.skipExecution(work, changes.getBeforeExecutionState(), context)).orElseGet(() -> this.executeBecause(work, reasons, context));
    }

    private UpToDateResult skipExecution(final UnitOfWork work, BeforeExecutionState beforeExecutionState, C context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Skipping {} as it is up-to-date.", (Object)work.getDisplayName());
        }
        PreviousExecutionState previousExecutionState = ((PreviousExecutionContext)context).getPreviousExecutionState().get();
        DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, previousExecutionState.getOutputFilesProducedByWork(), previousExecutionState.getOriginMetadata(), true);
        Try execution = Try.successful((Object)new ExecutionEngine.Execution((IncrementalChangesContext)context){
            final /* synthetic */ IncrementalChangesContext val$context;
            {
                this.val$context = incrementalChangesContext;
            }

            @Override
            public ExecutionEngine.ExecutionOutcome getOutcome() {
                return ExecutionEngine.ExecutionOutcome.UP_TO_DATE;
            }

            @Override
            public Object getOutput() {
                return work.loadAlreadyProducedOutput(this.val$context.getWorkspace());
            }
        });
        return new UpToDateResult(previousExecutionState.getOriginMetadata().getExecutionTime(), (Try<ExecutionEngine.Execution>)execution, afterExecutionState, (ImmutableList<String>)ImmutableList.of(), previousExecutionState.getOriginMetadata());
    }

    private UpToDateResult executeBecause(UnitOfWork work, ImmutableList<String> reasons, C context) {
        this.logExecutionReasons((List<String>)reasons, work);
        AfterExecutionResult result = this.delegate.execute(work, context);
        return new UpToDateResult(result, reasons, result.getAfterExecutionState().filter(AfterExecutionState::isReused).map(AfterExecutionState::getOriginMetadata).orElse(null));
    }

    private void logExecutionReasons(List<String> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("%s is not up-to-date because:", StringUtils.capitalize((String)work.getDisplayName()));
            for (String message : reasons) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

