/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.DefaultCacheCleanupStrategy;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.DirectoryBuildCacheFileStoreFactory;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.time.TimestampSuppliers;

public class DirectoryBuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    public static final String FAILED_READ_SUFFIX = ".failed";
    private static final String BUILD_CACHE_VERSION = "1";
    private static final String BUILD_CACHE_KEY = "build-cache-1";
    private static final String DIRECTORY_BUILD_CACHE_TYPE = "directory";
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final UnscopedCacheBuilderFactory unscopedCacheBuilderFactory;
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final PathToFileResolver resolver;
    private final DirectoryBuildCacheFileStoreFactory fileStoreFactory;
    private final CleanupActionDecorator cleanupActionDecorator;
    private final FileAccessTimeJournal fileAccessTimeJournal;
    private final TemporaryFileProvider temporaryFileProvider;

    @Inject
    public DirectoryBuildCacheServiceFactory(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, GlobalScopedCacheBuilderFactory cacheBuilderFactory, PathToFileResolver resolver, DirectoryBuildCacheFileStoreFactory fileStoreFactory, CleanupActionDecorator cleanupActionDecorator, FileAccessTimeJournal fileAccessTimeJournal, TemporaryFileProvider temporaryFileProvider) {
        this.unscopedCacheBuilderFactory = unscopedCacheBuilderFactory;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.resolver = resolver;
        this.fileStoreFactory = fileStoreFactory;
        this.cleanupActionDecorator = cleanupActionDecorator;
        this.fileAccessTimeJournal = fileAccessTimeJournal;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheBuilderFactory.baseDirForCrossVersionCache(BUILD_CACHE_KEY);
        DirectoryBuildCacheServiceFactory.checkDirectory(target);
        int removeUnusedEntriesAfterDays = configuration.getRemoveUnusedEntriesAfterDays();
        Supplier removeUnusedEntriesOlderThan = TimestampSuppliers.daysAgo((int)removeUnusedEntriesAfterDays);
        describer.type(DIRECTORY_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath()).config("removeUnusedEntriesAfter", String.valueOf(removeUnusedEntriesAfterDays) + " days");
        PathKeyFileStore fileStore = this.fileStoreFactory.createFileStore(target);
        PersistentCache persistentCache = this.unscopedCacheBuilderFactory.cache(target).withCleanupStrategy(this.createCacheCleanupStrategy(removeUnusedEntriesOlderThan)).withDisplayName("Build cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).open();
        DefaultBuildCacheTempFileStore tempFileStore = new DefaultBuildCacheTempFileStore(this.temporaryFileProvider);
        SingleDepthFileAccessTracker fileAccessTracker = new SingleDepthFileAccessTracker(this.fileAccessTimeJournal, target, 1);
        return new DirectoryBuildCacheService(fileStore, persistentCache, tempFileStore, (FileAccessTracker)fileAccessTracker, FAILED_READ_SUFFIX);
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(Supplier<Long> removeUnusedEntriesTimestamp) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)this.cleanupActionDecorator.decorate((CleanupAction)this.createCleanupAction(removeUnusedEntriesTimestamp)));
    }

    private LeastRecentlyUsedCacheCleanup createCleanupAction(Supplier<Long> removeUnusedEntriesTimestamp) {
        return new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), this.fileAccessTimeJournal, removeUnusedEntriesTimestamp);
    }

    private static void checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
    }
}

