/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.collection;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.EqualityComparator;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableSet;
import io.usethesource.capsule.util.iterator.SupplierIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class Set3<K>
extends AbstractSpecialisedImmutableSet<K> {
    private final K key1;
    private final K key2;
    private final K key3;

    Set3(K key1, K key2, K key3) {
        if (key1.equals(key2) || key1.equals(key3) || key2.equals(key3)) {
            throw new IllegalArgumentException("Duplicate elements are not allowed in specialised set.");
        }
        this.key1 = key1;
        this.key2 = key2;
        this.key3 = key3;
    }

    @Override
    public boolean contains(Object key) {
        if (key.equals(this.key1)) {
            return true;
        }
        if (key.equals(this.key2)) {
            return true;
        }
        return key.equals(this.key3);
    }

    @Override
    public boolean containsEquivalent(Object key, EqualityComparator<Object> cmp) {
        if (cmp.equals(key, this.key1)) {
            return true;
        }
        if (cmp.equals(key, this.key2)) {
            return true;
        }
        return cmp.equals(key, this.key3);
    }

    @Override
    public K get(Object key) {
        if (key.equals(this.key1)) {
            return this.key1;
        }
        if (key.equals(this.key2)) {
            return this.key2;
        }
        if (key.equals(this.key3)) {
            return this.key3;
        }
        return null;
    }

    @Override
    public K getEquivalent(Object key, EqualityComparator<Object> cmp) {
        if (cmp.equals(key, this.key1)) {
            return this.key1;
        }
        if (cmp.equals(key, this.key2)) {
            return this.key2;
        }
        if (cmp.equals(key, this.key3)) {
            return this.key3;
        }
        return null;
    }

    @Override
    public int size() {
        return 3;
    }

    public SupplierIterator<K, K> keyIterator() {
        return new SupplierIterator<K, K>(){
            int cursor = 1;
            boolean hasGet;

            @Override
            public boolean hasNext() {
                return this.cursor <= Set3.this.size();
            }

            @Override
            public K next() {
                switch (this.cursor++) {
                    case 1: {
                        return Set3.this.key1;
                    }
                    case 2: {
                        return Set3.this.key2;
                    }
                    case 3: {
                        return Set3.this.key3;
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public K get() {
                if (this.hasGet) {
                    this.hasGet = false;
                    switch (this.cursor) {
                        case 1: {
                            return Set3.this.key1;
                        }
                        case 2: {
                            return Set3.this.key2;
                        }
                        case 3: {
                            return Set3.this.key3;
                        }
                    }
                    throw new IllegalStateException();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set.Immutable<K> __insert(K key) {
        if (key.equals(this.key1)) {
            return Set3.setOf(key, this.key2, this.key3);
        }
        if (key.equals(this.key2)) {
            return Set3.setOf(this.key1, key, this.key3);
        }
        if (key.equals(this.key3)) {
            return Set3.setOf(this.key1, this.key2, key);
        }
        return Set3.setOf(this.key1, this.key2, this.key3, key);
    }

    @Override
    public Set.Immutable<K> __insertEquivalent(K key, EqualityComparator<Object> cmp) {
        if (cmp.equals(key, this.key1)) {
            return Set3.setOf(key, this.key2, this.key3);
        }
        if (cmp.equals(key, this.key2)) {
            return Set3.setOf(this.key1, key, this.key3);
        }
        if (cmp.equals(key, this.key3)) {
            return Set3.setOf(this.key1, this.key2, key);
        }
        return Set3.setOf(this.key1, this.key2, this.key3, key);
    }

    @Override
    public Set.Immutable<K> __remove(K key) {
        if (key.equals(this.key1)) {
            return Set3.setOf(this.key2, this.key3);
        }
        if (key.equals(this.key2)) {
            return Set3.setOf(this.key1, this.key3);
        }
        if (key.equals(this.key3)) {
            return Set3.setOf(this.key1, this.key2);
        }
        return this;
    }

    @Override
    public Set.Immutable<K> __removeEquivalent(K key, EqualityComparator<Object> cmp) {
        if (cmp.equals(key, this.key1)) {
            return Set3.setOf(this.key2, this.key3);
        }
        if (cmp.equals(key, this.key2)) {
            return Set3.setOf(this.key1, this.key3);
        }
        if (cmp.equals(key, this.key3)) {
            return Set3.setOf(this.key1, this.key2);
        }
        return this;
    }

    @Override
    public Set.Transient<K> asTransient() {
        return Set.Transient.of(this.key1, this.key2, this.key3);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key1) + Objects.hashCode(this.key2) + Objects.hashCode(this.key3);
    }

    @Override
    public String toString() {
        return String.format("{%s, %s, %s}", this.key1, this.key2, this.key3);
    }
}

